/*
 * Decompiled with CFR 0.152.
 */
package br.com.madeinlabs.dropsky;

import android.content.Context;
import android.view.View;
import br.com.madeinlabs.dropsky.DropSkyItem;
import java.util.LinkedList;
import java.util.List;

public class DropSkyAdapter {
    private final Context mContext;
    private List<DropSkyItem> mDropSkyItems = new LinkedList<DropSkyItem>();
    private Listener mListener;
    private boolean mReverse;
    private List<Integer> mHeights = new LinkedList<Integer>();

    public boolean isReverse() {
        return this.mReverse;
    }

    public DropSkyAdapter(Context context) {
        this.mContext = context;
    }

    public DropSkyAdapter(Context context, boolean reverseMode) {
        this(context);
        this.mReverse = reverseMode;
    }

    public int getCount() {
        return this.mDropSkyItems.size();
    }

    public DropSkyItem getDropSkyItem(int index) {
        return this.mDropSkyItems.get(index);
    }

    public void addViewItem(View view, int color) {
        final DropSkyItem dropSkyItem = new DropSkyItem(this.mContext, view, color, this.mReverse);
        view.measure(0, 0);
        this.mHeights.add(view.getMeasuredHeight());
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DropSkyAdapter.this.mListener != null) {
                    DropSkyAdapter.this.mListener.onItemClicked(dropSkyItem, DropSkyAdapter.this.mDropSkyItems.indexOf((Object)dropSkyItem));
                }
            }
        });
        this.mDropSkyItems.add(dropSkyItem);
    }

    public int getTotalHeight() {
        int totalHeight = 0;
        for (int height : this.mHeights) {
            totalHeight += height;
        }
        return totalHeight;
    }

    public int getItemY(int index) {
        int y = 0;
        for (int i = 0; i < index; ++i) {
            y += this.mHeights.get(i).intValue();
        }
        return y;
    }

    public void setOnItemClickListener(Listener onItemClickListener) {
        this.mListener = onItemClickListener;
    }

    public int getTrueHeight(int index) {
        return this.mHeights.get(index);
    }

    public static interface Listener {
        public void onItemClicked(DropSkyItem var1, int var2);
    }
}

