/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import butterknife.BindView;
import butterknife.ButterKnife;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import de.hdodenhof.circleimageview.CircleImageView;
import edu.ben.materialchip.R;
import edu.ben.materialchip.model.ChipInterface;
import edu.ben.materialchip.util.ColorUtil;
import edu.ben.materialchip.util.LetterTileProvider;
import edu.ben.materialchip.util.RTLUtil;
import edu.ben.materialchip.util.ViewUtil;

public class DetailedChipView
extends RelativeLayout {
    private static final String TAG = DetailedChipView.class.toString();
    private Context mContext;
    @BindView(value=2131427416)
    LinearLayout mContentLayout;
    @BindView(value=2131427420)
    CircleImageView mAvatarIconImageView;
    @BindView(value=2131427422)
    TextView mNameTextView;
    @BindView(value=2131427423)
    TextView mInfoTextView;
    @BindView(value=2131427418)
    ImageButton mDeleteButton;
    private static LetterTileProvider mLetterTileProvider;
    private ColorStateList mBackgroundColor;

    public DetailedChipView(Context context) {
        super(context);
        this.mContext = context;
        this.init(null);
    }

    public DetailedChipView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        View rootView = DetailedChipView.inflate((Context)this.getContext(), (int)R.layout.detailed_chip_view, (ViewGroup)this);
        ButterKnife.bind((Object)((Object)this), (View)rootView);
        mLetterTileProvider = new LetterTileProvider(this.mContext);
        this.setVisibility(8);
        this.hideOnTouchOutside();
    }

    private void hideOnTouchOutside() {
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
    }

    public void fadeIn() {
        AlphaAnimation anim2 = new AlphaAnimation(0.0f, 1.0f);
        anim2.setDuration(200L);
        this.startAnimation((Animation)anim2);
        this.setVisibility(0);
        this.requestFocus();
    }

    public void fadeOut() {
        AlphaAnimation anim2 = new AlphaAnimation(1.0f, 0.0f);
        anim2.setDuration(200L);
        this.startAnimation((Animation)anim2);
        this.setVisibility(8);
        this.clearFocus();
        this.setClickable(false);
    }

    public void setAvatarIcon(Drawable icon) {
        this.mAvatarIconImageView.setImageDrawable(icon);
    }

    public void setAvatarIcon(Bitmap icon) {
        this.mAvatarIconImageView.setImageBitmap(icon);
    }

    public void setAvatarIcon(Uri icon) {
        this.mAvatarIconImageView.setImageURI(icon);
    }

    public void setAvatarIcon(String icon, final Bitmap letterTile) {
        Picasso.with((Context)this.mContext).load(icon).centerCrop().resize(50, 50).error(R.drawable.ic_broken_image_grey_24dp).into((ImageView)this.mAvatarIconImageView, new Callback(){

            public void onSuccess() {
            }

            public void onError() {
                DetailedChipView.this.mAvatarIconImageView.setImageBitmap(letterTile);
            }
        });
    }

    public void setName(String name) {
        this.mNameTextView.setText((CharSequence)name);
    }

    public void setInfo(String info) {
        if (info != null) {
            this.mInfoTextView.setVisibility(0);
            this.mInfoTextView.setText((CharSequence)info);
        } else {
            this.mInfoTextView.setVisibility(8);
        }
    }

    public void setTextColor(ColorStateList color2) {
        this.mNameTextView.setTextColor(color2);
        this.mInfoTextView.setTextColor(ColorUtil.alpha(color2.getDefaultColor(), 150));
    }

    public void setBackGroundColor(ColorStateList color2) {
        this.mBackgroundColor = color2;
        this.mContentLayout.getBackground().setColorFilter(color2.getDefaultColor(), PorterDuff.Mode.SRC_ATOP);
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor == null ? ContextCompat.getColor((Context)this.mContext, (int)R.color.colorAccent) : this.mBackgroundColor.getDefaultColor();
    }

    public void setDeleteIconColor(ColorStateList color2) {
        this.mDeleteButton.getDrawable().mutate().setColorFilter(color2.getDefaultColor(), PorterDuff.Mode.SRC_ATOP);
    }

    public void setOnDeleteClicked(View.OnClickListener onClickListener) {
        this.mDeleteButton.setOnClickListener(onClickListener);
    }

    public void alignLeft() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mContentLayout.getLayoutParams();
        params.leftMargin = 0;
        this.mContentLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void alignRight() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mContentLayout.getLayoutParams();
        params.rightMargin = ViewUtil.dpToPx(12);
        this.mContentLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private static DetailedChipView newInstance(Builder builder) {
        DetailedChipView detailedChipView = new DetailedChipView(builder.context);
        if (RTLUtil.checkRTL(builder.name)) {
            RTLUtil.changLayoutDirection((View)detailedChipView, true);
        } else {
            RTLUtil.changLayoutDirection((View)detailedChipView, false);
        }
        if (builder.avatarUri != null) {
            detailedChipView.setAvatarIcon(builder.avatarUri);
        } else if (builder.avatarUrl != null && !builder.avatarUrl.equals("")) {
            detailedChipView.setAvatarIcon(builder.avatarUrl, mLetterTileProvider.getLetterTile(builder.name));
        } else if (builder.avatarDrawable != null) {
            detailedChipView.setAvatarIcon(builder.avatarDrawable);
        } else {
            detailedChipView.setAvatarIcon(mLetterTileProvider.getLetterTile(builder.name));
        }
        if (builder.backgroundColor != null) {
            detailedChipView.setBackGroundColor(builder.backgroundColor);
        }
        if (builder.textColor != null) {
            detailedChipView.setTextColor(builder.textColor);
        } else if (ColorUtil.isColorDark(detailedChipView.getBackgroundColor())) {
            detailedChipView.setTextColor(ColorStateList.valueOf((int)-1));
        } else {
            detailedChipView.setTextColor(ColorStateList.valueOf((int)-16777216));
        }
        if (builder.deleteIconColor != null) {
            detailedChipView.setDeleteIconColor(builder.deleteIconColor);
        } else if (ColorUtil.isColorDark(detailedChipView.getBackgroundColor())) {
            detailedChipView.setDeleteIconColor(ColorStateList.valueOf((int)-1));
        } else {
            detailedChipView.setDeleteIconColor(ColorStateList.valueOf((int)-16777216));
        }
        detailedChipView.setName(builder.name);
        detailedChipView.setInfo(builder.info);
        return detailedChipView;
    }

    public static class Builder {
        private Context context;
        private Uri avatarUri;
        private String avatarUrl;
        private Drawable avatarDrawable;
        private String name;
        private String info;
        private ColorStateList textColor;
        private ColorStateList backgroundColor;
        private ColorStateList deleteIconColor;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder avatar(Uri avatarUri) {
            this.avatarUri = avatarUri;
            return this;
        }

        public Builder avatar(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        public Builder avatar(Drawable avatarDrawable) {
            this.avatarDrawable = avatarDrawable;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder info(String info) {
            this.info = info;
            return this;
        }

        public Builder chip(ChipInterface chip) {
            this.avatarUri = chip.getAvatarUri();
            this.avatarUrl = chip.getAvatarUrl();
            this.avatarDrawable = chip.getAvatarDrawable();
            this.name = chip.getLabel();
            this.info = chip.getInfo();
            return this;
        }

        public Builder textColor(ColorStateList textColor) {
            this.textColor = textColor;
            return this;
        }

        public Builder backgroundColor(ColorStateList backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder deleteIconColor(ColorStateList deleteIconColor) {
            this.deleteIconColor = deleteIconColor;
            return this;
        }

        public DetailedChipView build() {
            return DetailedChipView.newInstance(this);
        }
    }
}

