/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.util;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;

public class ViewUtil {
    private static int windowWidthPortrait = 0;
    private static int windowWidthLandscape = 0;

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static int getWindowWidth(Context context) {
        if (context.getResources().getConfiguration().orientation == 1) {
            return ViewUtil.getWindowWidthPortrait(context);
        }
        return ViewUtil.getWindowWidthLandscape(context);
    }

    public static int getLayoutWidth(final View layout2) {
        final int[] width = new int[1];
        ViewTreeObserver vto = layout2.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    layout2.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    layout2.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                width[0] = layout2.getMeasuredWidth();
            }
        });
        return width[0];
    }

    private static int getWindowWidthPortrait(Context context) {
        if (windowWidthPortrait == 0) {
            DisplayMetrics metrics = context.getResources().getDisplayMetrics();
            windowWidthPortrait = metrics.widthPixels;
        }
        return windowWidthPortrait;
    }

    private static int getWindowWidthLandscape(Context context) {
        if (windowWidthLandscape == 0) {
            DisplayMetrics metrics = context.getResources().getDisplayMetrics();
            windowWidthLandscape = metrics.widthPixels;
        }
        return windowWidthLandscape;
    }

    public static int getNavBarHeight(Context context) {
        int result = 0;
        boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        if (!hasMenuKey && !hasBackKey) {
            Resources resources = context.getResources();
            int orientation = context.getResources().getConfiguration().orientation;
            int resourceId = ViewUtil.isTablet(context) ? resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android") : resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_width", "dimen", "android");
            if (resourceId > 0) {
                return context.getResources().getDimensionPixelSize(resourceId);
            }
        }
        return result;
    }

    public static int getWindowBottomNavBarHeight(Context context) {
        Resources resources = context.getResources();
        int orientation = context.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
            if (resourceId > 0) {
                return resources.getDimensionPixelSize(resourceId);
            }
        } else {
            int resourceId = resources.getIdentifier("navigation_bar_height_landscape", "dimen", "android");
            if (resourceId > 0) {
                return resources.getDimensionPixelSize(resourceId);
            }
        }
        return 0;
    }

    private static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static int getScreenOrientation(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        if (orientation == 1) {
            return 1;
        }
        return 2;
    }
}

