/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import butterknife.BindView;
import butterknife.ButterKnife;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import de.hdodenhof.circleimageview.CircleImageView;
import edu.ben.materialchip.R;
import edu.ben.materialchip.model.ChipInterface;
import edu.ben.materialchip.util.LetterTileProvider;
import edu.ben.materialchip.util.RTLUtil;
import edu.ben.materialchip.util.ViewUtil;

public class ChipView
extends RelativeLayout {
    private static final String TAG = ChipView.class.toString();
    private Context mContext;
    @BindView(value=2131427416)
    LinearLayout mContentLayout;
    @BindView(value=2131427373)
    CircleImageView mAvatarIconImageView;
    @BindView(value=2131427417)
    TextView mLabelTextView;
    @BindView(value=2131427418)
    ImageButton mDeleteButton;
    private static final int NONE = -1;
    private String mLabel;
    private ColorStateList mLabelColor;
    private boolean mHasAvatarIcon = false;
    private Drawable mAvatarIconDrawable;
    private Uri mAvatarIconUri;
    private String mAvatarIconUrl;
    private boolean mDeletable = false;
    private Drawable mDeleteIcon;
    private ColorStateList mDeleteIconColor;
    private ColorStateList mBackgroundColor;
    private LetterTileProvider mLetterTileProvider;
    private ChipInterface mChip;
    private boolean mIsRtl;

    public ChipView(Context context) {
        super(context);
        this.mContext = context;
        this.init(null);
    }

    public ChipView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        View rootView = ChipView.inflate((Context)this.getContext(), (int)R.layout.chip_view, (ViewGroup)this);
        ButterKnife.bind((Object)((Object)this), (View)rootView);
        this.mLetterTileProvider = new LetterTileProvider(this.mContext);
        if (attrs != null) {
            TypedArray a = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.ChipView, 0, 0);
            try {
                this.mLabel = a.getString(R.styleable.ChipView_label);
                this.mLabelColor = a.getColorStateList(R.styleable.ChipView_labelColor);
                this.mHasAvatarIcon = a.getBoolean(R.styleable.ChipView_hasAvatarIcon, false);
                int avatarIconId = a.getResourceId(R.styleable.ChipView_avatarIcon, -1);
                if (avatarIconId != -1) {
                    this.mAvatarIconDrawable = ContextCompat.getDrawable((Context)this.mContext, (int)avatarIconId);
                }
                if (this.mAvatarIconDrawable != null) {
                    this.mHasAvatarIcon = true;
                }
                this.mDeletable = a.getBoolean(R.styleable.ChipView_deletable, false);
                this.mDeleteIconColor = a.getColorStateList(R.styleable.ChipView_deleteIconColor);
                int deleteIconId = a.getResourceId(R.styleable.ChipView_deleteIcon, -1);
                if (deleteIconId != -1) {
                    this.mDeleteIcon = ContextCompat.getDrawable((Context)this.mContext, (int)deleteIconId);
                }
                this.mBackgroundColor = a.getColorStateList(R.styleable.ChipView_backgroundColor);
            }
            finally {
                a.recycle();
            }
        }
        this.inflateWithAttributes();
    }

    private void inflateWithAttributes() {
        this.setLabel(this.mLabel);
        if (this.mLabelColor != null) {
            this.setLabelColor(this.mLabelColor);
        }
        this.setHasAvatarIcon(this.mHasAvatarIcon);
        this.setDeletable(this.mDeletable);
        if (this.mBackgroundColor != null) {
            this.setChipBackgroundColor(this.mBackgroundColor);
        }
    }

    public void inflate(ChipInterface chip) {
        this.mChip = chip;
        this.mLabel = this.mChip.getLabel();
        this.mIsRtl = RTLUtil.checkRTL(this.mLabel);
        if (this.mIsRtl) {
            RTLUtil.changLayoutDirection((View)this.mContentLayout, true);
        } else {
            RTLUtil.changLayoutDirection((View)this.mContentLayout, false);
        }
        this.mAvatarIconUri = this.mChip.getAvatarUri();
        this.mAvatarIconUrl = this.mChip.getAvatarUrl();
        this.mAvatarIconDrawable = this.mChip.getAvatarDrawable();
        this.inflateWithAttributes();
    }

    public String getLabel() {
        return this.mLabel;
    }

    public void setLabel(String label) {
        this.mLabel = label;
        this.mLabelTextView.setText((CharSequence)label);
    }

    public void setLabelColor(ColorStateList color2) {
        this.mLabelColor = color2;
        this.mLabelTextView.setTextColor(color2);
    }

    public void setLabelColor(@ColorInt int color2) {
        this.mLabelColor = ColorStateList.valueOf((int)color2);
        this.mLabelTextView.setTextColor(color2);
    }

    public void setHasAvatarIcon(boolean hasAvatarIcon) {
        this.mHasAvatarIcon = hasAvatarIcon;
        if (!this.mHasAvatarIcon) {
            this.mAvatarIconImageView.setVisibility(8);
            if (this.mDeleteButton.getVisibility() == 0) {
                if (this.mIsRtl) {
                    this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(12), 0, 0, 0);
                } else {
                    this.mLabelTextView.setPadding(ViewUtil.dpToPx(12), 0, 0, 0);
                }
            } else if (this.mIsRtl) {
                this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(12), 0, ViewUtil.dpToPx(12), 0);
            } else {
                this.mLabelTextView.setPadding(ViewUtil.dpToPx(12), 0, ViewUtil.dpToPx(12), 0);
            }
        } else {
            this.mAvatarIconImageView.setVisibility(0);
            if (this.mDeleteButton.getVisibility() == 0) {
                if (this.mIsRtl) {
                    this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(8), 0, 0, 0);
                } else {
                    this.mLabelTextView.setPadding(ViewUtil.dpToPx(8), 0, 0, 0);
                }
            } else if (this.mIsRtl) {
                this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(8), 0, ViewUtil.dpToPx(12), 0);
            } else {
                this.mLabelTextView.setPadding(ViewUtil.dpToPx(8), 0, ViewUtil.dpToPx(12), 0);
            }
            if (this.mAvatarIconUri != null) {
                this.mAvatarIconImageView.setImageURI(this.mAvatarIconUri);
            } else if (this.mAvatarIconUrl != null && !this.mAvatarIconUrl.equals("")) {
                Picasso.with((Context)this.mContext).load(this.mAvatarIconUrl).centerCrop().resize(50, 50).into((ImageView)this.mAvatarIconImageView, new Callback(){

                    public void onSuccess() {
                    }

                    public void onError() {
                        ChipView.this.mAvatarIconImageView.setImageBitmap(ChipView.this.mLetterTileProvider.getLetterTile(ChipView.this.getLabel()));
                    }
                });
            } else if (this.mAvatarIconDrawable != null) {
                this.mAvatarIconImageView.setImageDrawable(this.mAvatarIconDrawable);
            } else {
                this.mAvatarIconImageView.setImageBitmap(this.mLetterTileProvider.getLetterTile(this.getLabel()));
            }
        }
    }

    public void setAvatarIcon(Drawable avatarIcon) {
        this.mAvatarIconDrawable = avatarIcon;
        this.mHasAvatarIcon = true;
        this.inflateWithAttributes();
    }

    public void setAvatarIcon(Uri avatarUri) {
        this.mAvatarIconUri = avatarUri;
        this.mHasAvatarIcon = true;
        this.inflateWithAttributes();
    }

    public void setDeletable(boolean deletable) {
        this.mDeletable = deletable;
        if (!this.mDeletable) {
            this.mDeleteButton.setVisibility(8);
            if (this.mAvatarIconImageView.getVisibility() == 0) {
                if (this.mIsRtl) {
                    this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(8), 0, ViewUtil.dpToPx(12), 0);
                } else {
                    this.mLabelTextView.setPadding(ViewUtil.dpToPx(8), 0, ViewUtil.dpToPx(12), 0);
                }
            } else if (this.mIsRtl) {
                this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(12), 0, ViewUtil.dpToPx(12), 0);
            } else {
                this.mLabelTextView.setPadding(ViewUtil.dpToPx(12), 0, ViewUtil.dpToPx(12), 0);
            }
        } else {
            this.mDeleteButton.setVisibility(0);
            if (this.mAvatarIconImageView.getVisibility() == 0) {
                if (this.mIsRtl) {
                    this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(8), 0, 0, 0);
                } else {
                    this.mLabelTextView.setPadding(ViewUtil.dpToPx(8), 0, 0, 0);
                }
            } else if (this.mIsRtl) {
                this.mLabelTextView.setPaddingRelative(ViewUtil.dpToPx(12), 0, 0, 0);
            } else {
                this.mLabelTextView.setPadding(ViewUtil.dpToPx(12), 0, 0, 0);
            }
            if (this.mDeleteIcon != null) {
                this.mDeleteButton.setImageDrawable(this.mDeleteIcon);
            }
            if (this.mDeleteIconColor != null) {
                this.mDeleteButton.getDrawable().mutate().setColorFilter(this.mDeleteIconColor.getDefaultColor(), PorterDuff.Mode.SRC_ATOP);
            }
        }
    }

    public void setDeleteIconColor(ColorStateList color2) {
        this.mDeleteIconColor = color2;
        this.mDeletable = true;
        this.inflateWithAttributes();
    }

    public void setDeleteIconColor(@ColorInt int color2) {
        this.mDeleteIconColor = ColorStateList.valueOf((int)color2);
        this.mDeletable = true;
        this.inflateWithAttributes();
    }

    public void setDeleteIcon(Drawable deleteIcon) {
        this.mDeleteIcon = deleteIcon;
        this.mDeletable = true;
        this.inflateWithAttributes();
    }

    public void setChipBackgroundColor(ColorStateList color2) {
        this.mBackgroundColor = color2;
        this.setChipBackgroundColor(color2.getDefaultColor());
    }

    public void setChipBackgroundColor(@ColorInt int color2) {
        this.mBackgroundColor = ColorStateList.valueOf((int)color2);
        this.mContentLayout.getBackground().setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    public void setChip(ChipInterface chip) {
        this.mChip = chip;
    }

    public void setOnDeleteClicked(View.OnClickListener onClickListener) {
        this.mDeleteButton.setOnClickListener(onClickListener);
    }

    public void setOnChipClicked(View.OnClickListener onClickListener) {
        this.mContentLayout.setOnClickListener(onClickListener);
    }

    private static ChipView newInstance(Builder builder) {
        ChipView chipView = new ChipView(builder.context);
        chipView.mLabel = builder.label;
        chipView.mLabelColor = builder.labelColor;
        chipView.mHasAvatarIcon = builder.hasAvatarIcon;
        chipView.mAvatarIconUri = builder.avatarIconUri;
        chipView.mAvatarIconDrawable = builder.avatarIconDrawable;
        chipView.mDeletable = builder.deletable;
        chipView.mDeleteIcon = builder.deleteIcon;
        chipView.mDeleteIconColor = builder.deleteIconColor;
        chipView.mBackgroundColor = builder.backgroundColor;
        chipView.mChip = builder.chip;
        chipView.inflateWithAttributes();
        return chipView;
    }

    public static class Builder {
        private Context context;
        private String label;
        private ColorStateList labelColor;
        private boolean hasAvatarIcon = false;
        private Uri avatarIconUri;
        private Drawable avatarIconDrawable;
        private boolean deletable = false;
        private Drawable deleteIcon;
        private ColorStateList deleteIconColor;
        private ColorStateList backgroundColor;
        private ChipInterface chip;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder labelColor(ColorStateList labelColor) {
            this.labelColor = labelColor;
            return this;
        }

        public Builder hasAvatarIcon(boolean hasAvatarIcon) {
            this.hasAvatarIcon = hasAvatarIcon;
            return this;
        }

        public Builder avatarIcon(Uri avatarUri) {
            this.avatarIconUri = avatarUri;
            return this;
        }

        public Builder avatarIcon(Drawable avatarIcon) {
            this.avatarIconDrawable = avatarIcon;
            return this;
        }

        public Builder deletable(boolean deletable) {
            this.deletable = deletable;
            return this;
        }

        public Builder deleteIcon(Drawable deleteIcon) {
            this.deleteIcon = deleteIcon;
            return this;
        }

        public Builder deleteIconColor(ColorStateList deleteIconColor) {
            this.deleteIconColor = deleteIconColor;
            return this;
        }

        public Builder backgroundColor(ColorStateList backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Builder chip(ChipInterface chip) {
            this.chip = chip;
            this.label = chip.getLabel();
            this.avatarIconDrawable = chip.getAvatarDrawable();
            this.avatarIconUri = chip.getAvatarUri();
            return this;
        }

        public ChipView build() {
            return ChipView.newInstance(this);
        }
    }
}

