/*
 * Decompiled with CFR 0.152.
 */
package com.github.macgregor.alexandria;

import com.github.macgregor.alexandria.Alexandria;
import com.github.macgregor.alexandria.Context;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AlexandriaMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    @NonNull
    private MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    @NonNull
    private MavenSession mavenSession;
    @Parameter(property="alexandria.configPath")
    private String configPath;
    @Parameter(property="alexandria.outputPath", defaultValue="${project.build.directory}/alexandria")
    private String outputPath;
    @Parameter(property="alexandria.inputs")
    private List<String> inputs = new ArrayList<String>();
    @Parameter(property="alexandria.includes")
    private List<String> includes = new ArrayList<String>();
    @Parameter(property="alexandria.excludes")
    private List<String> excludes = new ArrayList<String>();
    @Parameter(property="alexandria.timeout", defaultValue="30")
    private Integer timeout = 30;
    @Parameter(property="alexandria.failBuild", defaultValue="false")
    private boolean failBuild = false;
    private Alexandria alexandria = new Alexandria();

    public Alexandria init() throws IOException {
        if (this.inputs == null || this.inputs.size() < 1) {
            this.inputs.add(this.rootDir());
        }
        if (this.configPath == null) {
            this.configPath = Paths.get(this.rootDir(), ".alexandria").toString();
        }
        this.alexandria.context(Context.load((String)Paths.get(this.configPath, new String[0]).toAbsolutePath().toString()));
        this.alexandria.context().searchPath(this.inputs.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
        this.alexandria.context().outputPath(Optional.of(Paths.get(this.outputPath, new String[0])));
        this.alexandria.context().config().remote().requestTimeout(this.timeout);
        if (this.includes.size() > 0) {
            this.alexandria.context().include(this.includes);
        }
        if (this.excludes.size() > 0) {
            this.alexandria.context().exclude(this.excludes);
        }
        return this.alexandria;
    }

    public void logContext() {
        this.getLog().debug((CharSequence)("Alexandria - config file: " + this.alexandria.context().configPath()));
        this.getLog().debug((CharSequence)("Alexandria - project base dir: " + this.alexandria.context().projectBase()));
        this.getLog().debug((CharSequence)("Alexandria - inputs directories: " + this.alexandria.context().searchPath()));
        this.getLog().debug((CharSequence)("Alexandria - outputPath directory: " + this.alexandria.context().outputPath()));
        this.getLog().debug((CharSequence)("Alexandria - includes files: " + this.alexandria.context().include()));
        this.getLog().debug((CharSequence)("Alexandria - excludes files: " + this.alexandria.context().exclude()));
    }

    public boolean isExecutionRoot() {
        return this.mavenSession.getExecutionRootDirectory().equalsIgnoreCase(this.project.getBasedir().toString());
    }

    public String rootDir() {
        MavenProject parent = this.project;
        String dir = parent.getBasedir().toString();
        while (parent.getParent() != null) {
            if ((parent = parent.getParent()).getBasedir() == null) continue;
            dir = parent.getBasedir().toString();
        }
        return dir;
    }

    @NonNull
    @Generated
    public MavenProject project() {
        return this.project;
    }

    @NonNull
    @Generated
    public MavenSession mavenSession() {
        return this.mavenSession;
    }

    @Generated
    public String configPath() {
        return this.configPath;
    }

    @Generated
    public String outputPath() {
        return this.outputPath;
    }

    @Generated
    public List<String> inputs() {
        return this.inputs;
    }

    @Generated
    public List<String> includes() {
        return this.includes;
    }

    @Generated
    public List<String> excludes() {
        return this.excludes;
    }

    @Generated
    public Integer timeout() {
        return this.timeout;
    }

    @Generated
    public boolean failBuild() {
        return this.failBuild;
    }

    @Generated
    public Alexandria alexandria() {
        return this.alexandria;
    }

    @Generated
    public AlexandriaMojo project(@NonNull MavenProject project) {
        if (project == null) {
            throw new NullPointerException("project is marked @NonNull but is null");
        }
        this.project = project;
        return this;
    }

    @Generated
    public AlexandriaMojo mavenSession(@NonNull MavenSession mavenSession) {
        if (mavenSession == null) {
            throw new NullPointerException("mavenSession is marked @NonNull but is null");
        }
        this.mavenSession = mavenSession;
        return this;
    }

    @Generated
    public AlexandriaMojo configPath(String configPath) {
        this.configPath = configPath;
        return this;
    }

    @Generated
    public AlexandriaMojo outputPath(String outputPath) {
        this.outputPath = outputPath;
        return this;
    }

    @Generated
    public AlexandriaMojo inputs(List<String> inputs) {
        this.inputs = inputs;
        return this;
    }

    @Generated
    public AlexandriaMojo includes(List<String> includes) {
        this.includes = includes;
        return this;
    }

    @Generated
    public AlexandriaMojo excludes(List<String> excludes) {
        this.excludes = excludes;
        return this;
    }

    @Generated
    public AlexandriaMojo timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Generated
    public AlexandriaMojo failBuild(boolean failBuild) {
        this.failBuild = failBuild;
        return this;
    }

    @Generated
    public AlexandriaMojo alexandria(Alexandria alexandria) {
        this.alexandria = alexandria;
        return this;
    }
}

