/*
 * Decompiled with CFR 0.152.
 */
package in.mayanknagwanshi.imagepicker.imagePicker;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import in.mayanknagwanshi.imagepicker.provider.ImageSelectionProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ImagePickerUtil {
    static String filePath;

    public static Intent getPickImageChooserIntent(Context context, boolean isCamera, boolean isGallery) {
        Intent intent;
        Uri outputFileUri = ImagePickerUtil.getCaptureImageOutputUri(context);
        ArrayList<Intent> allIntents = new ArrayList<Intent>();
        PackageManager packageManager = context.getPackageManager();
        if (isCamera) {
            Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            captureIntent.setAction("android.media.action.IMAGE_CAPTURE");
            List listCam = packageManager.queryIntentActivities(captureIntent, 0);
            for (ResolveInfo res : listCam) {
                intent = new Intent(captureIntent);
                intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
                intent.setPackage(res.activityInfo.packageName);
                if (outputFileUri != null) {
                    intent.putExtra("output", (Parcelable)outputFileUri);
                }
                allIntents.add(intent);
            }
        }
        if (isGallery) {
            Intent galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            List listGallery = packageManager.queryIntentActivities(galleryIntent, 0);
            Iterator iterator = listGallery.iterator();
            while (iterator.hasNext()) {
                ResolveInfo res;
                res = (ResolveInfo)iterator.next();
                intent = new Intent(galleryIntent);
                intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
                intent.setPackage(res.activityInfo.packageName);
                allIntents.add(intent);
            }
        }
        Intent mainIntent = (Intent)allIntents.get(allIntents.size() - 1);
        for (Intent intent2 : allIntents) {
            if (intent2.getComponent() == null || !intent2.getComponent().getClassName().equals("com.android.documentsui.DocumentsActivity")) continue;
            mainIntent = intent2;
            break;
        }
        allIntents.remove(mainIntent);
        Intent chooserIntent = Intent.createChooser((Intent)mainIntent, (CharSequence)"Select source");
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", allIntents.toArray(new Parcelable[allIntents.size()]));
        return chooserIntent;
    }

    private static Uri getCaptureImageOutputUri(Context context) {
        Uri outputFileUri = null;
        File getImage = context.getExternalFilesDir("");
        if (getImage != null) {
            String fileName = "IMG_" + System.currentTimeMillis() + ".png";
            filePath = new File(getImage.getPath(), fileName).getPath();
            outputFileUri = ImageSelectionProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".image-selection-provider"), (File)new File(getImage.getPath(), fileName));
        }
        return outputFileUri;
    }

    public static String getImageFilePath(Context context, Intent data) {
        return ImagePickerUtil.getPickImageResultFilePath(context, data);
    }

    private static String getPickImageResultFilePath(Context context, Intent data) {
        boolean isCamera;
        boolean bl = isCamera = data == null || data.getData() == null;
        if (isCamera) {
            return filePath;
        }
        return ImagePickerUtil.getRealPathFromURI(context, data.getData());
    }

    private static String getRealPathFromURI(Context context, Uri contentUri) {
        File file = new File(ImagePickerUtil.getFilename(context));
        try {
            if (file.createNewFile()) {
                InputStream iStream = context.getContentResolver().openInputStream(contentUri);
                byte[] inputData = ImagePickerUtil.getBytes(iStream);
                FileOutputStream out = new FileOutputStream(file);
                ((OutputStream)out).write(inputData);
                ((OutputStream)out).close();
                return file.getAbsolutePath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    private static String getFilename(Context context) {
        File mediaStorageDir = new File(context.getExternalFilesDir(""), "uncompressed");
        if (!mediaStorageDir.exists()) {
            mediaStorageDir.mkdirs();
        }
        String mImageName = "IMG_" + String.valueOf(System.currentTimeMillis()) + ".png";
        return mediaStorageDir.getAbsolutePath() + "/" + mImageName;
    }
}

