/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.note;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.tools.speedlib.views.components.note.Note;

public class ImageNote
extends Note<ImageNote> {
    private Bitmap image;
    private int width;
    private int height;
    private RectF imageRect = new RectF();
    private Paint notePaint = new Paint(1);

    public ImageNote(Context context, int resource) {
        this(context, BitmapFactory.decodeResource((Resources)context.getResources(), (int)resource));
    }

    public ImageNote(Context context, int resource, int width, int height) {
        this(context, BitmapFactory.decodeResource((Resources)context.getResources(), (int)resource), width, height);
    }

    public ImageNote(Context context, Bitmap image) {
        this(context, image, image.getWidth(), image.getHeight());
    }

    public ImageNote(Context context, Bitmap image, int width, int height) {
        super(context);
        if (image == null) {
            throw new IllegalArgumentException("image cannot be null.");
        }
        this.image = image;
        this.width = width;
        this.height = height;
        if (width <= 0) {
            throw new IllegalArgumentException("width must be bigger than 0");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height must be bigger than 0");
        }
    }

    @Override
    public void build(int viewWidth) {
        this.noticeContainsSizeChange(this.width, this.height);
    }

    @Override
    protected void drawContains(Canvas canvas, float leftX, float topY) {
        this.imageRect.set(leftX, topY, leftX + (float)this.width, topY + (float)this.height);
        canvas.drawBitmap(this.image, null, this.imageRect, this.notePaint);
    }
}

