/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.Indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import com.tools.speedlib.views.components.Indicators.Indicator;

public class LineIndicator
extends Indicator<LineIndicator> {
    private Path indicatorPath = new Path();
    public static final float LINE = 1.0f;
    public static final float HALF_LINE = 0.5f;
    public static final float QUARTER_LINE = 0.25f;
    private float mode;

    public LineIndicator(Context context, float mode) {
        super(context);
        this.mode = mode;
        this.updateIndicator();
    }

    @Override
    protected float getDefaultIndicatorWidth() {
        return this.dpTOpx(8.0f);
    }

    @Override
    public void draw(Canvas canvas, float degree) {
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.indicatorPaint);
        canvas.restore();
    }

    @Override
    protected void updateIndicator() {
        this.indicatorPath.reset();
        this.indicatorPath.moveTo(this.getCenterX(), (float)this.getPadding());
        this.indicatorPath.lineTo(this.getCenterX(), this.getCenterY() * this.mode);
        this.indicatorPaint.setStyle(Paint.Style.STROKE);
        this.indicatorPaint.setStrokeWidth(this.getIndicatorWidth());
        this.indicatorPaint.setColor(this.getIndicatorColor());
    }

    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects && !this.isInEditMode()) {
            this.indicatorPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
        } else {
            this.indicatorPaint.setMaskFilter(null);
        }
    }
}

