/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.tools.speedlib.helper.ProgressHelper;
import com.tools.speedlib.listener.NetDelayListener;
import com.tools.speedlib.listener.SpeedListener;
import com.tools.speedlib.listener.impl.UIProgressListener;
import com.tools.speedlib.runnable.NetworkDelayRunnable;
import com.tools.speedlib.utils.TimerTaskUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class SpeedManager {
    private static final int MSG_TIMEOUT = 1000;
    private OkHttpClient client;
    private Call call;
    private String pingCmd;
    private String url;
    private int maxCount;
    private long timeOut;
    private NetDelayListener delayListener;
    private SpeedListener speedListener;
    private SparseArray<Long> mTotalSpeeds = new SparseArray();
    private long mTempSpeed = 0L;
    private int mSpeedCount = 0;
    private boolean mIsStopSpeed = false;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1000: {
                    if (SpeedManager.this.mIsStopSpeed) break;
                    SpeedManager.this.handleResultSpeed(0L, true);
                }
            }
        }
    };

    private SpeedManager() {
        this.client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).build();
    }

    public void startSpeed() {
        this.mSpeedCount = 0;
        this.mTempSpeed = 0L;
        this.mIsStopSpeed = false;
        this.mTotalSpeeds = new SparseArray();
        boolean isPingSucc = this.pingDelay(this.pingCmd);
        if (isPingSucc && null != this.speedListener) {
            this.speed();
        }
    }

    public void finishSpeed() {
        if (this.call != null) {
            this.call.cancel();
        }
        this.mIsStopSpeed = true;
        TimerTaskUtil.cacleTimer(this.mHandler, 1000);
    }

    private void speed() {
        TimerTaskUtil.setTimer(this.mHandler, 1000, this.timeOut);
        UIProgressListener uiProgressListener = new UIProgressListener(){

            @Override
            public void onUIProgress(int taskId, long currentBytes, long contentLength, boolean done) {
                SpeedManager.this.handleSpeed(currentBytes, done);
            }

            @Override
            public void onUIStart(int taskId, long currentBytes, long contentLength, boolean done) {
                super.onUIStart(taskId, currentBytes, contentLength, done);
            }

            @Override
            public void onUIFinish(int taskId, long currentBytes, long contentLength, boolean done) {
                super.onUIFinish(taskId, currentBytes, contentLength, done);
                SpeedManager.this.handleResultSpeed(currentBytes, done);
            }
        };
        Request request = new Request.Builder().url(this.url).cacheControl(CacheControl.FORCE_NETWORK).build();
        this.call = ProgressHelper.addProgressResponseListener(this.client, uiProgressListener).newCall(request);
        this.call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
                SpeedManager.this.readBytesFromStream(response.body().byteStream());
            }
        });
    }

    private boolean pingDelay(String cmd) {
        if (null == this.delayListener) {
            return true;
        }
        try {
            NetworkDelayRunnable delayRunnable = new NetworkDelayRunnable(cmd);
            Thread thread = new Thread(delayRunnable);
            thread.start();
            thread.join(5000L);
            this.delayListener.result(delayRunnable.getDelayTime());
            return delayRunnable.isPingSucc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void handleSpeed(long currentBytes, boolean done) {
        if (this.mSpeedCount < this.maxCount) {
            this.mTempSpeed = currentBytes / (long)(this.mSpeedCount + 1);
            this.mTotalSpeeds.put(this.mSpeedCount, (Object)this.mTempSpeed);
            ++this.mSpeedCount;
            if (null != this.speedListener) {
                this.speedListener.speeding(this.mTempSpeed, this.mTempSpeed / 4L);
            }
        }
        this.handleResultSpeed(currentBytes, this.mSpeedCount >= this.maxCount || done);
    }

    private void handleResultSpeed(long currentBytes, boolean isDone) {
        if (isDone) {
            this.finishSpeed();
            long finalSpeedTotal = 0L;
            for (int i = 0; i < this.mTotalSpeeds.size(); ++i) {
                finalSpeedTotal += ((Long)this.mTotalSpeeds.get(i)).longValue();
            }
            if (null != this.speedListener) {
                if (this.mTotalSpeeds.size() > 0) {
                    this.speedListener.finishSpeed(finalSpeedTotal / (long)this.mTotalSpeeds.size(), finalSpeedTotal / (long)this.mTotalSpeeds.size() / 4L);
                } else if (0L != currentBytes) {
                    this.speedListener.finishSpeed(currentBytes, currentBytes / 4L);
                } else {
                    this.speedListener.finishSpeed(0L, 0L);
                }
                this.speedListener = null;
                TimerTaskUtil.cacleTimer(this.mHandler, 1000);
            }
        }
    }

    private void readBytesFromStream(InputStream is) throws IOException {
        int len;
        int size = 1024;
        byte[] buf = new byte[size];
        while (!this.mIsStopSpeed && (len = is.read(buf, 0, size)) != -1) {
            Log.d((String)"TAG", (String)("byte length : " + len));
        }
    }

    public static final class Builder {
        private static final String DEFAULE_CMD = "www.baidu.com";
        private static final String DEFAULT_URL = "http://dldir1.qq.com/qqfile/QQIntl/QQi_wireless/Android/qqi_4.6.13.6034_office.apk";
        private static final int MAX_COUNT = 6;
        private String pingCmd = "www.baidu.com";
        private String url = "http://dldir1.qq.com/qqfile/QQIntl/QQi_wireless/Android/qqi_4.6.13.6034_office.apk";
        private int maxCount = 6;
        private long timeOut = 11000L;
        private NetDelayListener delayListener;
        private SpeedListener speedListener;

        public Builder setPindCmd(String cmd) {
            this.pingCmd = cmd;
            return this;
        }

        public Builder setSpeedUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setSpeedCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public Builder setSpeedTimeOut(long timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder setNetDelayListener(NetDelayListener delayListener) {
            this.delayListener = delayListener;
            return this;
        }

        public Builder setSpeedListener(SpeedListener speedListener) {
            this.speedListener = speedListener;
            return this;
        }

        private void applayConfig(SpeedManager manager) {
            if (!TextUtils.isEmpty((CharSequence)this.pingCmd)) {
                manager.pingCmd = "ping -c 3 " + this.pingCmd;
            }
            if (!TextUtils.isEmpty((CharSequence)this.url)) {
                manager.url = this.url;
            }
            if (0 != this.maxCount) {
                manager.maxCount = this.maxCount;
            }
            if (0L != this.timeOut) {
                manager.timeOut = this.timeOut;
            }
            if (null != this.delayListener) {
                manager.delayListener = this.delayListener;
            }
            if (null != this.speedListener) {
                manager.speedListener = this.speedListener;
            }
        }

        public SpeedManager builder() {
            SpeedManager manager = new SpeedManager();
            this.applayConfig(manager);
            return manager;
        }
    }
}

