/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogress;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.github.lzyzsd.circleprogress.R;
import com.github.lzyzsd.circleprogress.Utils;

public class CircleProgress
extends View {
    private Paint textPaint;
    private RectF rectF = new RectF();
    private float textSize;
    private int textColor;
    private int progress = 0;
    private int max;
    private int finishedColor;
    private int unfinishedColor;
    private String prefixText = "";
    private String suffixText = "%";
    private final int default_finished_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
    private final int default_text_color = -1;
    private final int default_max = 100;
    private final float default_text_size;
    private final int min_size;
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_SUFFIX = "suffix";
    private static final String INSTANCE_PREFIX = "prefix";
    private Paint paint = new Paint();

    public CircleProgress(Context context) {
        this(context, null);
    }

    public CircleProgress(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgress(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_text_size = Utils.sp2px(this.getResources(), 18.0f);
        this.min_size = (int)Utils.dp2px(this.getResources(), 100.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircleProgress, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    protected void initByAttributes(TypedArray attributes) {
        this.finishedColor = attributes.getColor(3, this.default_finished_color);
        this.unfinishedColor = attributes.getColor(2, this.default_unfinished_color);
        this.textColor = attributes.getColor(5, -1);
        this.textSize = attributes.getDimension(4, this.default_text_size);
        this.setMax(attributes.getInt(1, 100));
        this.setProgress(attributes.getInt(0, 0));
        if (attributes.getString(6) != null) {
            this.setPrefixText(attributes.getString(6));
        }
        if (attributes.getString(7) != null) {
            this.setSuffixText(attributes.getString(7));
        }
    }

    protected void initPainters() {
        this.textPaint = new TextPaint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setAntiAlias(true);
        this.paint.setAntiAlias(true);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (this.progress > this.getMax()) {
            this.progress %= this.getMax();
        }
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public int getFinishedColor() {
        return this.finishedColor;
    }

    public void setFinishedColor(int finishedColor) {
        this.finishedColor = finishedColor;
        this.invalidate();
    }

    public int getUnfinishedColor() {
        return this.unfinishedColor;
    }

    public void setUnfinishedColor(int unfinishedColor) {
        this.unfinishedColor = unfinishedColor;
        this.invalidate();
    }

    public String getPrefixText() {
        return this.prefixText;
    }

    public void setPrefixText(String prefixText) {
        this.prefixText = prefixText;
        this.invalidate();
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
        this.invalidate();
    }

    public String getDrawText() {
        return this.getPrefixText() + this.getProgress() + this.getSuffixText();
    }

    protected int getSuggestedMinimumHeight() {
        return this.min_size;
    }

    protected int getSuggestedMinimumWidth() {
        return this.min_size;
    }

    public float getProgressPercentage() {
        return (float)this.getProgress() / (float)this.getMax();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.rectF.set(0.0f, 0.0f, (float)View.MeasureSpec.getSize((int)widthMeasureSpec), (float)View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        float yHeight = (float)this.getProgress() / (float)this.getMax() * (float)this.getHeight();
        float radius = (float)this.getWidth() / 2.0f;
        float angle = (float)(Math.acos((radius - yHeight) / radius) * 180.0 / Math.PI);
        float startAngle = 90.0f + angle;
        float sweepAngle = 360.0f - angle * 2.0f;
        this.paint.setColor(this.getUnfinishedColor());
        canvas.drawArc(this.rectF, startAngle, sweepAngle, false, this.paint);
        canvas.save();
        canvas.rotate(180.0f, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.paint.setColor(this.getFinishedColor());
        canvas.drawArc(this.rectF, 270.0f - angle, angle * 2.0f, false, this.paint);
        canvas.restore();
        String text = this.getDrawText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            float textHeight = this.textPaint.descent() + this.textPaint.ascent();
            canvas.drawText(text, ((float)this.getWidth() - this.textPaint.measureText(text)) / 2.0f, ((float)this.getWidth() - textHeight) / 2.0f, this.textPaint);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedColor());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_PROGRESS, this.getProgress());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        bundle.putString(INSTANCE_PREFIX, this.getPrefixText());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.textColor = bundle.getInt(INSTANCE_TEXT_COLOR);
            this.textSize = bundle.getFloat(INSTANCE_TEXT_SIZE);
            this.finishedColor = bundle.getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedColor = bundle.getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.initPainters();
            this.setMax(bundle.getInt(INSTANCE_MAX));
            this.setProgress(bundle.getInt(INSTANCE_PROGRESS));
            this.prefixText = bundle.getString(INSTANCE_PREFIX);
            this.suffixText = bundle.getString(INSTANCE_SUFFIX);
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }
}

