/*
 * Decompiled with CFR 0.152.
 */
package com.lzj.sidebar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;

public class SideBarSortView
extends View {
    private Canvas mCanvas;
    private int mSelectIndex = 0;
    private float mTextSize;
    private int mTextColor;
    private float mTextSizeChoose;
    private int mTextColorChoose;
    public static String[] mList = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    public Paint paint = new Paint();
    private OnIndexChangedListener mClickListener;

    public void setmTextSize(float mTextSize) {
        this.mTextSize = mTextSize;
    }

    public void setmTextColor(int mTextColor) {
        this.mTextColor = mTextColor;
    }

    public void setmTextSizeChoose(float mTextSizeChoose) {
        this.mTextSizeChoose = mTextSizeChoose;
    }

    public void setmTextColorChoose(int mTextColorChoose) {
        this.mTextColorChoose = mTextColorChoose;
    }

    public SideBarSortView(Context context) {
        super(context);
    }

    public SideBarSortView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mCanvas = canvas;
        this.paintText();
    }

    private void paintText() {
        int height = this.getHeight() / mList.length;
        for (int i = 0; i < mList.length; ++i) {
            if (i == this.mSelectIndex) {
                this.paint.setColor(this.mTextColorChoose);
                this.paint.setTextSize(this.mTextSizeChoose);
            } else {
                this.paint.setColor(this.mTextColor);
                this.paint.setTextSize(this.mTextSize);
            }
            this.paint.setAntiAlias(true);
            this.paint.setTypeface(Typeface.DEFAULT_BOLD);
            float paintX = (float)this.getWidth() / 2.0f - this.paint.measureText(mList[i]) / 2.0f;
            int paintY = height * i + height;
            this.mCanvas.drawText(mList[i], paintX, (float)paintY, this.paint);
            this.paint.reset();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: 
            case 2: {
                int index = (int)(event.getY() / (float)this.getHeight() * (float)mList.length);
                if (index < 0 || index >= mList.length) break;
                if (this.mClickListener != null) {
                    this.mClickListener.onSideBarScrollUpdateItem(mList[index]);
                }
                this.mSelectIndex = index;
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                if (this.mClickListener == null) break;
                this.mClickListener.onSideBarScrollEndHideText();
            }
        }
        return true;
    }

    public void setIndexChangedListener(OnIndexChangedListener listener) {
        this.mClickListener = listener;
    }

    public void onitemScrollUpdateText(String word) {
        for (int i = 0; i < mList.length; ++i) {
            if (!mList[i].equals(word) || this.mSelectIndex == i) continue;
            this.mSelectIndex = i;
            this.invalidate();
        }
    }

    public static interface OnIndexChangedListener {
        public void onSideBarScrollUpdateItem(String var1);

        public void onSideBarScrollEndHideText();
    }
}

