/*
 * Decompiled with CFR 0.152.
 */
package com.lzj.sidebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.lzj.sidebar.R;
import com.lzj.sidebar.SideBarSortView;

public class SideBarLayout
extends RelativeLayout
implements SideBarSortView.OnIndexChangedListener {
    private View mLayout;
    private Context mContext;
    private TextView mTvTips;
    private SideBarSortView mSortView;
    private int selectTextColor;
    private int unselectTextColor;
    private float selectTextSize;
    private float unselectTextSize;
    private int wordTextColor;
    private float wordTextSize;
    private Drawable wordBackground;
    private OnSideBarLayoutListener mListener;

    public SideBarLayout(Context context) {
        super(context);
    }

    public SideBarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        this.initView();
    }

    public SideBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        this.initView();
    }

    private void init(Context context, AttributeSet attrs) {
        this.mContext = context;
        if (attrs != null) {
            TypedArray ta = this.mContext.obtainStyledAttributes(attrs, R.styleable.SideBarView);
            this.unselectTextColor = ta.getColor(R.styleable.SideBarView_sidebarUnSelectTextColor, Color.parseColor((String)"#1ABDE6"));
            this.selectTextColor = ta.getColor(R.styleable.SideBarView_sidebarSelectTextColor, Color.parseColor((String)"#2E56D7"));
            this.selectTextSize = ta.getDimension(R.styleable.SideBarView_sidebarSelectTextSize, (float)SideBarLayout.dip2px(this.mContext, 12.0f));
            this.unselectTextSize = ta.getDimension(R.styleable.SideBarView_sidebarUnSelectTextSize, (float)SideBarLayout.dip2px(this.mContext, 10.0f));
            this.wordTextSize = ta.getDimension(R.styleable.SideBarView_sidebarWordTextSize, (float)SideBarLayout.px2sp(this.mContext, 45.0f));
            this.wordTextColor = ta.getColor(R.styleable.SideBarView_sidebarWordTextColor, Color.parseColor((String)"#FFFFFF"));
            this.wordBackground = ta.getDrawable(R.styleable.SideBarView_sidebarWordBackground);
            if (this.wordBackground == null) {
                this.wordBackground = context.getResources().getDrawable(R.drawable.sort_text_view_hint_bg);
            }
            ta.recycle();
        }
    }

    private void initView() {
        this.mLayout = LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_sidebar_layout, null, true);
        this.mTvTips = (TextView)this.mLayout.findViewById(R.id.tvTips);
        this.mSortView = (SideBarSortView)this.mLayout.findViewById(R.id.sortView);
        this.mSortView.setIndexChangedListener(this);
        this.mSortView.setmTextColor(this.unselectTextColor);
        this.mSortView.setmTextSize(this.unselectTextSize);
        this.mSortView.setmTextColorChoose(this.selectTextColor);
        this.mSortView.setmTextSizeChoose(this.selectTextSize);
        this.mSortView.invalidate();
        this.mTvTips.setTextColor(this.wordTextColor);
        this.mTvTips.setTextSize((float)SideBarLayout.px2sp(this.mContext, this.wordTextSize));
        this.mTvTips.setBackground(this.wordBackground);
        this.addView(this.mLayout);
    }

    public void setSideBarLayout(OnSideBarLayoutListener listener) {
        this.mListener = listener;
    }

    @Override
    public void onSideBarScrollUpdateItem(String word) {
        this.mTvTips.setVisibility(0);
        this.mTvTips.setText((CharSequence)word);
        if (this.mListener != null) {
            this.mListener.onSideBarScrollUpdateItem(word);
        }
    }

    @Override
    public void onSideBarScrollEndHideText() {
        this.mTvTips.setVisibility(8);
    }

    public void onItemScrollUpdateSideBarText(String word) {
        if (this.mListener != null) {
            this.mSortView.onUpdateSideBarText(word);
        }
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static interface OnSideBarLayoutListener {
        public void onSideBarScrollUpdateItem(String var1);
    }
}

