/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library.helper;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.View;
import com.allen.library.data.AttributeSetData;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u0002032\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J\u000e\u00108\u001a\u0002032\u0006\u00105\u001a\u000206J\u0010\u00109\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J\u0018\u0010:\u001a\u0002032\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010;\u001a\u000203H\u0002J\b\u0010<\u001a\u000203H\u0002J\b\u0010=\u001a\u000203H\u0002J\b\u0010>\u001a\u000203H\u0002J\b\u0010?\u001a\u000203H\u0002J\u0016\u0010@\u001a\u0002032\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u000eJ\b\u0010C\u001a\u000203H\u0002J\b\u0010D\u001a\u000203H\u0002J\b\u0010E\u001a\u000203H\u0002J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010G\u001a\u000203H\u0002J\u000e\u0010H\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004J\b\u0010I\u001a\u000203H\u0002J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000eJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0004J\b\u0010L\u001a\u000203H\u0002J\u000e\u0010M\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010N\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010O\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0004J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0004J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0004J\b\u0010T\u001a\u000203H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/allen/library/helper/ShadowHelper;", "", "()V", "allRadius", "", "attributeSetData", "Lcom/allen/library/data/AttributeSetData;", "getAttributeSetData", "()Lcom/allen/library/data/AttributeSetData;", "setAttributeSetData", "(Lcom/allen/library/data/AttributeSetData;)V", "contentCornersArcRectF", "Landroid/graphics/RectF;", "contentCornersColor", "", "cornersPathList", "", "Landroid/graphics/Path;", "fixBorder", "height", "leftBottomCornersPath", "leftBottomRadius", "leftTopCornersPath", "leftTopRadius", "maxRadius", "paint", "Landroid/graphics/Paint;", "rightBottomCornersPath", "rightBottomRadius", "rightTopCornersPath", "rightTopRadius", "shadowAreaPath", "shadowBottomWidth", "shadowColor", "shadowColorAlpha", "shadowColorAlphaList", "shadowColorPathList", "shadowColorRect", "shadowInnerRect", "shadowLeftWidth", "shadowMaxWidth", "shadowOuterRect", "shadowRadii", "", "shadowRightWidth", "shadowStrokeWidth", "shadowTopWidth", "targetView", "Landroid/view/View;", "width", "applyToView", "", "drawBefore", "canvas", "Landroid/graphics/Canvas;", "drawContent", "drawOver", "drawShadow", "init", "initColor", "initPaint", "initParams", "initRadius", "initShadowWidth", "onSizeChanged", "w", "h", "resetData", "setCornersPath", "setRadius", "setShadowAllRadius", "setShadowAreaPath", "setShadowBottomWidth", "setShadowColor", "setShadowColorAlpha", "shadowColorAlphaPercent", "setShadowColorPathList", "setShadowLeftBottomRadius", "setShadowLeftTopRadius", "setShadowLeftWidth", "setShadowRightBottomRadius", "setShadowRightTopRadius", "setShadowRightWidth", "setShadowTopWidth", "setShadowWidthAndContentPadding", "library_release"})
public final class ShadowHelper {
    private View targetView;
    @NotNull
    private AttributeSetData attributeSetData = new AttributeSetData();
    private int width;
    private int height;
    private List<Path> cornersPathList;
    private Path leftTopCornersPath;
    private Path leftBottomCornersPath;
    private Path rightTopCornersPath;
    private Path rightBottomCornersPath;
    private float allRadius;
    private float leftTopRadius;
    private float leftBottomRadius;
    private float rightTopRadius;
    private float rightBottomRadius;
    private float shadowLeftWidth;
    private float shadowRightWidth;
    private float shadowTopWidth;
    private float shadowBottomWidth;
    private RectF contentCornersArcRectF;
    private int contentCornersColor;
    private Paint paint;
    private float shadowStrokeWidth;
    private Path shadowAreaPath;
    private RectF shadowOuterRect;
    private RectF shadowInnerRect;
    private RectF shadowColorRect;
    private List<Path> shadowColorPathList;
    private float[] shadowRadii;
    private float shadowMaxWidth;
    private int shadowColor;
    private float shadowColorAlpha;
    private List<Integer> shadowColorAlphaList;
    private float fixBorder;
    private float maxRadius;

    @NotNull
    public final AttributeSetData getAttributeSetData() {
        return this.attributeSetData;
    }

    public final void setAttributeSetData(@NotNull AttributeSetData attributeSetData) {
        Intrinsics.checkParameterIsNotNull((Object)attributeSetData, (String)"<set-?>");
        this.attributeSetData = attributeSetData;
    }

    public final void init(@Nullable View targetView, @NotNull AttributeSetData attributeSetData) {
        Intrinsics.checkParameterIsNotNull((Object)attributeSetData, (String)"attributeSetData");
        this.attributeSetData = attributeSetData;
        this.targetView = targetView;
        View view = targetView;
        if (view != null) {
            view.setLayerType(1, null);
        }
        this.initParams();
    }

    private final void initParams() {
        this.initColor();
        this.initRadius();
        this.initShadowWidth();
        this.initPaint();
    }

    private final void initColor() {
        this.shadowColor = this.attributeSetData.getShadowColor();
        this.shadowColorAlpha = this.attributeSetData.getShadowColorAlpha();
        this.setShadowColor();
    }

    private final void initRadius() {
        this.allRadius = this.attributeSetData.getShadowCornersRadius();
        this.leftTopRadius = this.attributeSetData.getShadowCornersTopLeftRadius();
        this.leftBottomRadius = this.attributeSetData.getShadowCornersBottomLeftRadius();
        this.rightTopRadius = this.attributeSetData.getShadowCornersTopRightRadius();
        this.rightBottomRadius = this.attributeSetData.getShadowCornersBottomRightRadius();
    }

    private final void initShadowWidth() {
        this.shadowLeftWidth = this.attributeSetData.getShadowLeftWidth();
        this.shadowTopWidth = this.attributeSetData.getShadowTopWidth();
        this.shadowRightWidth = this.attributeSetData.getShadowRightWidth();
        this.shadowBottomWidth = this.attributeSetData.getShadowBottomWidth();
    }

    private final void initPaint() {
        this.paint.setColor(this.contentCornersColor);
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth(0.0f);
        this.paint.setStyle(Paint.Style.FILL);
    }

    private final void setShadowColor() {
        int colorAlpha = Color.alpha((int)this.shadowColor);
        if (colorAlpha != 255) {
            this.shadowColorAlpha = (float)colorAlpha / 255.0f;
        }
    }

    private final void resetData() {
        this.setShadowColor();
        this.setShadowWidthAndContentPadding();
        this.setRadius();
        this.setCornersPath();
        this.setShadowAreaPath();
        this.setShadowColorPathList();
    }

    private final void setShadowWidthAndContentPadding() {
        View view = this.targetView;
        if (view != null) {
            view.setPadding((int)this.shadowLeftWidth, (int)this.shadowTopWidth, (int)this.shadowRightWidth, (int)this.shadowBottomWidth);
        }
        Float f = CollectionsKt.max((Iterable)CollectionsKt.listOf((Object[])new Float[]{Float.valueOf(this.shadowLeftWidth), Float.valueOf(this.shadowRightWidth), Float.valueOf(this.shadowTopWidth), Float.valueOf(this.shadowBottomWidth)}));
        this.shadowMaxWidth = f != null ? f.floatValue() : 0.0f;
        this.maxRadius = ((float)this.height - this.shadowTopWidth - this.shadowBottomWidth) / (float)2;
    }

    private final void setRadius() {
        if (this.maxRadius > 0.0f) {
            float f;
            float f2 = this.allRadius;
            float f3 = this.maxRadius;
            ShadowHelper shadowHelper = this;
            boolean bl = false;
            shadowHelper.allRadius = f = Math.min(f2, f3);
            if (this.allRadius > 0.0f) {
                this.leftTopRadius = this.allRadius;
                this.leftBottomRadius = this.allRadius;
                this.rightTopRadius = this.allRadius;
                this.rightBottomRadius = this.allRadius;
            } else {
                f2 = this.leftTopRadius;
                f3 = this.maxRadius;
                shadowHelper = this;
                bl = false;
                shadowHelper.leftTopRadius = f = Math.min(f2, f3);
                f2 = this.leftBottomRadius;
                f3 = this.maxRadius;
                shadowHelper = this;
                bl = false;
                shadowHelper.leftBottomRadius = f = Math.min(f2, f3);
                f2 = this.rightTopRadius;
                f3 = this.maxRadius;
                shadowHelper = this;
                bl = false;
                shadowHelper.rightTopRadius = f = Math.min(f2, f3);
                f2 = this.rightBottomRadius;
                f3 = this.maxRadius;
                shadowHelper = this;
                bl = false;
                shadowHelper.rightBottomRadius = f = Math.min(f2, f3);
            }
        } else if (this.allRadius > 0.0f) {
            this.leftTopRadius = this.allRadius;
            this.leftBottomRadius = this.allRadius;
            this.rightTopRadius = this.allRadius;
            this.rightBottomRadius = this.allRadius;
        }
    }

    private final void setCornersPath() {
        this.cornersPathList.clear();
        this.contentCornersArcRectF.setEmpty();
        if (this.leftTopRadius > 0.0f) {
            this.leftTopCornersPath.reset();
            this.leftTopCornersPath.moveTo(this.shadowLeftWidth, this.shadowTopWidth);
            this.contentCornersArcRectF.set(this.shadowLeftWidth, this.shadowTopWidth, this.shadowLeftWidth + this.leftTopRadius * (float)2, this.shadowTopWidth + this.leftTopRadius * (float)2);
            this.leftTopCornersPath.arcTo(this.contentCornersArcRectF, 270.0f, -90.0f);
            this.cornersPathList.add(this.leftTopCornersPath);
        }
        if (this.leftBottomRadius > 0.0f) {
            this.leftBottomCornersPath.reset();
            this.leftBottomCornersPath.moveTo(this.shadowLeftWidth, (float)this.height - this.shadowBottomWidth);
            this.contentCornersArcRectF.set(this.shadowLeftWidth, (float)this.height - this.shadowBottomWidth - this.leftBottomRadius * (float)2, this.shadowLeftWidth + this.leftBottomRadius * (float)2, (float)this.height - this.shadowBottomWidth);
            this.leftBottomCornersPath.arcTo(this.contentCornersArcRectF, 180.0f, -90.0f);
            this.cornersPathList.add(this.leftBottomCornersPath);
        }
        if (this.rightTopRadius > 0.0f) {
            this.rightTopCornersPath.reset();
            this.rightTopCornersPath.moveTo((float)this.width - this.shadowRightWidth, this.shadowTopWidth);
            this.contentCornersArcRectF.set((float)this.width - this.shadowRightWidth - this.rightTopRadius * (float)2, this.shadowTopWidth, (float)this.width - this.shadowRightWidth, this.shadowTopWidth + this.rightTopRadius * (float)2);
            this.rightTopCornersPath.arcTo(this.contentCornersArcRectF, 0.0f, -90.0f);
            this.cornersPathList.add(this.rightTopCornersPath);
        }
        if (this.rightBottomRadius > 0.0f) {
            this.rightBottomCornersPath.reset();
            this.rightBottomCornersPath.moveTo((float)this.width - this.shadowRightWidth, (float)this.height - this.shadowBottomWidth);
            this.contentCornersArcRectF.set((float)this.width - this.shadowRightWidth - this.rightBottomRadius * (float)2, (float)this.height - this.shadowBottomWidth - this.rightBottomRadius * (float)2, (float)this.width - this.shadowRightWidth, (float)this.height - this.shadowBottomWidth);
            this.rightBottomCornersPath.arcTo(this.contentCornersArcRectF, 90.0f, -90.0f);
            this.cornersPathList.add(this.rightBottomCornersPath);
        }
    }

    private final void setShadowAreaPath() {
        this.shadowAreaPath.reset();
        this.shadowOuterRect.set(this.fixBorder, this.fixBorder, (float)this.width - this.fixBorder, (float)this.height - this.fixBorder);
        this.shadowAreaPath.addRect(this.shadowOuterRect, Path.Direction.CW);
        this.shadowInnerRect.set(this.shadowLeftWidth + this.fixBorder, this.shadowTopWidth + this.fixBorder, (float)this.width - this.shadowRightWidth - this.fixBorder, (float)this.height - this.shadowBottomWidth - this.fixBorder);
        this.shadowRadii = new float[]{this.leftTopRadius, this.leftTopRadius, this.rightTopRadius, this.rightTopRadius, this.rightBottomRadius, this.rightBottomRadius, this.leftBottomRadius, this.leftBottomRadius};
        this.shadowAreaPath.addRoundRect(this.shadowInnerRect, this.shadowRadii, Path.Direction.CCW);
    }

    /*
     * WARNING - void declaration
     */
    private final void setShadowColorPathList() {
        this.shadowColorPathList.clear();
        this.shadowColorAlphaList.clear();
        int n = (int)this.shadowMaxWidth;
        boolean bl = false;
        while (n >= 0) {
            void i;
            Path shadowColorPath = new Path();
            this.shadowColorRect.set((float)i + this.fixBorder, (float)i + this.fixBorder, (float)(this.width - i) - this.fixBorder, (float)(this.height - i) - this.fixBorder);
            shadowColorPath.addRoundRect(this.shadowColorRect, this.shadowRadii, Path.Direction.CW);
            this.shadowColorPathList.add(shadowColorPath);
            this.shadowColorAlphaList.add((int)(this.shadowColorAlpha * (float)255 * (float)i / this.shadowMaxWidth));
            --i;
        }
    }

    public final void onSizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
        this.fixBorder = this.shadowStrokeWidth / (float)2;
        this.resetData();
    }

    public final void drawBefore(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.saveLayer(0.0f, 0.0f, (float)this.width, (float)this.height, null, 31);
    }

    public final void drawOver(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawContent(canvas);
        this.drawShadow(canvas);
    }

    private final void drawContent(Canvas canvas) {
        this.paint.setColor(this.contentCornersColor);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeWidth(0.0f);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        for (Path path : this.cornersPathList) {
            canvas.drawPath(path, this.paint);
        }
        canvas.restore();
        this.paint.setXfermode((Xfermode)null);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawShadow(Canvas canvas) {
        canvas.clipPath(this.shadowAreaPath);
        this.paint.setColor(this.shadowColor);
        this.paint.setStrokeWidth(this.shadowStrokeWidth);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        Iterable $this$forEachIndexed$iv = this.shadowColorPathList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void path;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            Path path2 = (Path)item$iv;
            int index = n2;
            boolean bl2 = false;
            this.paint.setAlpha(((Number)this.shadowColorAlphaList.get(index)).intValue());
            canvas.drawPath((Path)path, this.paint);
        }
    }

    @NotNull
    public final ShadowHelper setShadowLeftWidth(float shadowLeftWidth) {
        this.shadowLeftWidth = shadowLeftWidth;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowTopWidth(float shadowTopWidth) {
        this.shadowTopWidth = shadowTopWidth;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowRightWidth(float shadowRightWidth) {
        this.shadowRightWidth = shadowRightWidth;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowBottomWidth(float shadowBottomWidth) {
        this.shadowBottomWidth = shadowBottomWidth;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowLeftTopRadius(float leftTopRadius) {
        this.leftTopRadius = leftTopRadius;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowLeftBottomRadius(float leftBottomRadius) {
        this.leftBottomRadius = leftBottomRadius;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowRightTopRadius(float rightTopRadius) {
        this.rightTopRadius = rightTopRadius;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowRightBottomRadius(float rightBottomRadius) {
        this.rightBottomRadius = rightBottomRadius;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowAllRadius(float allRadius) {
        this.allRadius = allRadius;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
        return this;
    }

    @NotNull
    public final ShadowHelper setShadowColorAlpha(float shadowColorAlphaPercent) {
        this.shadowColorAlpha = this.shadowColorAlpha < 0.0f ? 0.0f : (this.shadowColorAlpha > 1.0f ? 1.0f : shadowColorAlphaPercent);
        return this;
    }

    public final void applyToView() {
        block0: {
            this.resetData();
            View view = this.targetView;
            if (view == null) break block0;
            view.invalidate();
        }
    }

    public ShadowHelper() {
        List list;
        ShadowHelper shadowHelper = this;
        boolean bl = false;
        shadowHelper.cornersPathList = list = (List)new ArrayList();
        this.leftTopCornersPath = new Path();
        this.leftBottomCornersPath = new Path();
        this.rightTopCornersPath = new Path();
        this.rightBottomCornersPath = new Path();
        this.contentCornersArcRectF = new RectF();
        this.contentCornersColor = -1;
        this.paint = new Paint();
        this.shadowStrokeWidth = 1.0f;
        this.shadowAreaPath = new Path();
        this.shadowOuterRect = new RectF();
        this.shadowInnerRect = new RectF();
        this.shadowColorRect = new RectF();
        shadowHelper = this;
        bl = false;
        shadowHelper.shadowColorPathList = list = (List)new ArrayList();
        this.shadowRadii = new float[0];
        this.shadowColor = -7829368;
        shadowHelper = this;
        bl = false;
        shadowHelper.shadowColorAlphaList = list = (List)new ArrayList();
    }
}

