/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library.helper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.allen.library.R;
import com.allen.library.helper.ShapeBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/allen/library/helper/AttributeSetHelper;", "", "()V", "defaultColor", "", "defaultSelectorColor", "dip2px", "context", "Landroid/content/Context;", "dipValue", "", "initShapeBuilderFromAttributeSet", "Lcom/allen/library/helper/ShapeBuilder;", "attrs", "Landroid/util/AttributeSet;", "library_release"})
public final class AttributeSetHelper {
    private final int defaultColor = 0x20000000;
    private final int defaultSelectorColor = 0x20000000;

    @NotNull
    public final ShapeBuilder initShapeBuilderFromAttributeSet(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (attrs == null) {
            return new ShapeBuilder();
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeView);
        int shapeType = typedArray.getInt(R.styleable.ShapeView_shapeType, 0);
        int solidColor = typedArray.getColor(R.styleable.ShapeView_shapeSolidColor, this.defaultColor);
        int selectorPressedColor = typedArray.getColor(R.styleable.ShapeView_shapeSelectorPressedColor, this.defaultSelectorColor);
        int selectorDisableColor = typedArray.getColor(R.styleable.ShapeView_shapeSelectorDisableColor, this.defaultSelectorColor);
        int selectorNormalColor = typedArray.getColor(R.styleable.ShapeView_shapeSelectorNormalColor, this.defaultSelectorColor);
        float cornersRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersRadius, 0);
        float cornersTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersTopLeftRadius, 0);
        float cornersTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersTopRightRadius, 0);
        float cornersBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersBottomLeftRadius, 0);
        float cornersBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersBottomRightRadius, 0);
        int strokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeStrokeWidth, 0);
        float strokeDashWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeStrokeDashWidth, 0);
        float strokeDashGap = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeStrokeDashGap, 0);
        int strokeColor = typedArray.getColor(R.styleable.ShapeView_shapeStrokeColor, this.defaultColor);
        int sizeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeSizeWidth, 0);
        int sizeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeSizeHeight, this.dip2px(context, 48.0f));
        int gradientAngle = (int)typedArray.getFloat(R.styleable.ShapeView_shapeGradientAngle, -1.0f);
        int gradientCenterX = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeGradientCenterX, 0);
        int gradientCenterY = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeGradientCenterY, 0);
        int gradientGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeView_shapeGradientGradientRadius, 0);
        int gradientStartColor = typedArray.getColor(R.styleable.ShapeView_shapeGradientStartColor, -1);
        int gradientCenterColor = typedArray.getColor(R.styleable.ShapeView_shapeGradientCenterColor, -1);
        int gradientEndColor = typedArray.getColor(R.styleable.ShapeView_shapeGradientEndColor, -1);
        int gradientType = typedArray.getInt(R.styleable.ShapeView_shapeGradientType, 0);
        boolean gradientUseLevel = typedArray.getBoolean(R.styleable.ShapeView_shapeGradientUseLevel, false);
        boolean useSelector = typedArray.getBoolean(R.styleable.ShapeView_shapeUseSelector, false);
        typedArray.recycle();
        ShapeBuilder shapeBuilder = new ShapeBuilder();
        shapeBuilder.setShapeType(shapeType).setShapeCornersRadius(cornersRadius).setShapeCornersTopLeftRadius(cornersTopLeftRadius).setShapeCornersTopRightRadius(cornersTopRightRadius).setShapeCornersBottomRightRadius(cornersBottomRightRadius).setShapeCornersBottomLeftRadius(cornersBottomLeftRadius).setShapeSolidColor(solidColor).setShapeStrokeColor(strokeColor).setShapeStrokeWidth(strokeWidth).setShapeStrokeDashWidth(strokeDashWidth).setShapeStrokeDashGap(strokeDashGap).setShapeUseSelector(useSelector).setShapeSelectorNormalColor(selectorNormalColor).setShapeSelectorPressedColor(selectorPressedColor).setShapeSelectorDisableColor(selectorDisableColor).setShapeSizeWidth(sizeWidth).setShapeSizeHeight(sizeHeight).setShapeGradientType(gradientType).setShapeGradientAngle(gradientAngle).setShapeGradientGradientRadius(gradientGradientRadius).setShapeGradientUseLevel(gradientUseLevel).setShapeGradientCenterX(gradientCenterX).setShapeGradientCenterY(gradientCenterY).setShapeGradientStartColor(gradientStartColor).setShapeGradientCenterColor(gradientCenterColor).setShapeGradientEndColor(gradientEndColor);
        return shapeBuilder;
    }

    private final int dip2px(Context context, float dipValue) {
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

