/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.GradientDrawable;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import com.allen.library.R;
import com.allen.library.utils.ShapeBuilder;

public class SuperButton
extends AppCompatButton {
    private Context mContext;
    private int defaultColor = 0x20000000;
    private int defaultSelectorColor = 0x20000000;
    private int solidColor;
    private int selectorPressedColor;
    private int selectorDisableColor;
    private int selectorNormalColor;
    private float cornersRadius;
    private float cornersTopLeftRadius;
    private float cornersTopRightRadius;
    private float cornersBottomLeftRadius;
    private float cornersBottomRightRadius;
    private int strokeWidth;
    private int strokeColor;
    private float strokeDashWidth;
    private float strokeDashGap;
    private int sizeWidth;
    private int sizeHeight;
    private int gradientAngle;
    private int gradientCenterX;
    private int gradientCenterY;
    private int gradientGradientRadius;
    private int gradientStartColor;
    private int gradientCenterColor;
    private int gradientEndColor;
    private int gradientType;
    private static final int linear = 0;
    private static final int radial = 1;
    private static final int sweep = 2;
    private boolean gradientUseLevel;
    private boolean useSelector;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    public static final int TOP_BOTTOM = 0;
    public static final int TR_BL = 1;
    public static final int RIGHT_LEFT = 2;
    public static final int BR_TL = 3;
    public static final int BOTTOM_TOP = 4;
    public static final int BL_TR = 5;
    public static final int LEFT_RIGHT = 6;
    public static final int TL_BR = 7;
    public static final int TEXT_GRAVITY_CENTER = 0;
    public static final int TEXT_GRAVITY_LEFT = 1;
    public static final int TEXT_GRAVITY_RIGHT = 2;
    public static final int TEXT_GRAVITY_TOP = 3;
    public static final int TEXT_GRAVITY_BOTTOM = 4;
    private int shapeType;
    private int gravity;
    private GradientDrawable gradientDrawable;
    private ShapeBuilder shapeBuilder;

    public SuperButton(Context context) {
        this(context, null);
    }

    public SuperButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getAttr(attrs);
        this.init();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.SuperButton);
        this.gravity = typedArray.getInt(R.styleable.SuperButton_sGravity, 0);
        this.shapeType = typedArray.getInt(R.styleable.SuperButton_sShapeType, 0);
        this.solidColor = typedArray.getColor(R.styleable.SuperButton_sSolidColor, this.defaultColor);
        this.selectorPressedColor = typedArray.getColor(R.styleable.SuperButton_sSelectorPressedColor, this.defaultSelectorColor);
        this.selectorDisableColor = typedArray.getColor(R.styleable.SuperButton_sSelectorDisableColor, this.defaultSelectorColor);
        this.selectorNormalColor = typedArray.getColor(R.styleable.SuperButton_sSelectorNormalColor, this.defaultSelectorColor);
        this.cornersRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersRadius, 0);
        this.cornersTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersTopLeftRadius, 0);
        this.cornersTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersTopRightRadius, 0);
        this.cornersBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersBottomLeftRadius, 0);
        this.cornersBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersBottomRightRadius, 0);
        this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sStrokeWidth, 0);
        this.strokeDashWidth = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sStrokeDashWidth, 0);
        this.strokeDashGap = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sStrokeDashGap, 0);
        this.strokeColor = typedArray.getColor(R.styleable.SuperButton_sStrokeColor, this.defaultColor);
        this.sizeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sSizeWidth, 0);
        this.sizeHeight = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sSizeHeight, this.dip2px(this.mContext, 48.0f));
        this.gradientAngle = (int)typedArray.getFloat(R.styleable.SuperButton_sGradientAngle, -1.0f);
        this.gradientCenterX = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientCenterX, 0);
        this.gradientCenterY = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientCenterY, 0);
        this.gradientGradientRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientGradientRadius, 0);
        this.gradientStartColor = typedArray.getColor(R.styleable.SuperButton_sGradientStartColor, -1);
        this.gradientCenterColor = typedArray.getColor(R.styleable.SuperButton_sGradientCenterColor, -1);
        this.gradientEndColor = typedArray.getColor(R.styleable.SuperButton_sGradientEndColor, -1);
        this.gradientType = typedArray.getInt(R.styleable.SuperButton_sGradientType, 0);
        this.gradientUseLevel = typedArray.getBoolean(R.styleable.SuperButton_sGradientUseLevel, false);
        this.useSelector = typedArray.getBoolean(R.styleable.SuperButton_sUseSelector, false);
        typedArray.recycle();
    }

    private void init() {
        this.setClickable(true);
        this.shapeBuilder = new ShapeBuilder();
        this.shapeBuilder.setShapeType(this.shapeType).setShapeCornersRadius(this.cornersRadius).setShapeCornersTopLeftRadius(this.cornersTopLeftRadius).setShapeCornersTopRightRadius(this.cornersTopRightRadius).setShapeCornersBottomRightRadius(this.cornersBottomRightRadius).setShapeCornersBottomLeftRadius(this.cornersBottomLeftRadius).setShapeSolidColor(this.solidColor).setShapeStrokeColor(this.strokeColor).setShapeStrokeWidth(this.strokeWidth).setShapeStrokeDashWidth(this.strokeDashWidth).setShapeStrokeDashGap(this.strokeDashGap).setShapeUseSelector(this.useSelector).setShapeSelectorNormalColor(this.selectorNormalColor).setShapeSelectorPressedColor(this.selectorPressedColor).setShapeSelectorDisableColor(this.selectorDisableColor).setShapeSizeWidth(this.sizeWidth).setShapeSizeHeight(this.sizeHeight).setShapeGradientType(this.gradientType).setShapeGradientAngle(this.gradientAngle).setShapeGradientUseLevel(this.gradientUseLevel).setShapeGradientCenterX(this.gradientCenterX).setShapeGradientCenterY(this.gradientCenterY).setShapeGradientStartColor(this.gradientStartColor).setShapeGradientCenterColor(this.gradientCenterColor).setShapeGradientEndColor(this.gradientEndColor).into((View)this);
        this.setSGravity();
    }

    private void setSGravity() {
        switch (this.gravity) {
            case 0: {
                this.setGravity(17);
                break;
            }
            case 1: {
                this.setGravity(19);
                break;
            }
            case 2: {
                this.setGravity(21);
                break;
            }
            case 3: {
                this.setGravity(49);
                break;
            }
            case 4: {
                this.setGravity(81);
            }
        }
    }

    public SuperButton setShapeType(int type) {
        this.shapeType = type;
        return this;
    }

    public SuperButton setTextGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public SuperButton setShapeSelectorPressedColor(int color) {
        this.shapeBuilder.setShapeSelectorPressedColor(color);
        return this;
    }

    public SuperButton setShapeSelectorNormalColor(int color) {
        this.shapeBuilder.setShapeSelectorNormalColor(color);
        return this;
    }

    public SuperButton setShapeSelectorDisableColor(int color) {
        this.shapeBuilder.setShapeSelectorDisableColor(color);
        return this;
    }

    public SuperButton setShapeSolidColor(int color) {
        this.shapeBuilder.setShapeSolidColor(color);
        return this;
    }

    public SuperButton setShapeStrokeWidth(int strokeWidth) {
        this.shapeBuilder.setShapeStrokeWidth(this.dip2px(this.mContext, strokeWidth));
        return this;
    }

    public SuperButton setShapeStrokeColor(int strokeColor) {
        this.shapeBuilder.setShapeStrokeColor(strokeColor);
        return this;
    }

    public SuperButton setShapeStrokeDashWidth(float strokeDashWidth) {
        this.shapeBuilder.setShapeStrokeDashWidth(this.dip2px(this.mContext, strokeDashWidth));
        return this;
    }

    public SuperButton setShapeStrokeDashGap(float strokeDashGap) {
        this.shapeBuilder.setShapeStrokeDashGap(this.dip2px(this.mContext, strokeDashGap));
        return this;
    }

    public SuperButton setShapeCornersRadius(float radius) {
        this.shapeBuilder.setShapeCornersRadius(this.dip2px(this.mContext, radius));
        return this;
    }

    public SuperButton setShapeCornersTopLeftRadius(float radius) {
        this.shapeBuilder.setShapeCornersTopLeftRadius(this.dip2px(this.mContext, radius));
        return this;
    }

    public SuperButton setShapeCornersTopRightRadius(float radius) {
        this.shapeBuilder.setShapeCornersTopRightRadius(this.dip2px(this.mContext, radius));
        return this;
    }

    public SuperButton setShapeCornersBottomLeftRadius(float radius) {
        this.shapeBuilder.setShapeCornersBottomLeftRadius(this.dip2px(this.mContext, radius));
        return this;
    }

    public SuperButton setShapeCornersBottomRightRadius(float radius) {
        this.shapeBuilder.setShapeCornersBottomRightRadius(this.dip2px(this.mContext, radius));
        return this;
    }

    public SuperButton setShapeSizeWidth(int sizeWidth) {
        this.shapeBuilder.setShapeSizeWidth(this.dip2px(this.mContext, sizeWidth));
        return this;
    }

    public SuperButton setShapeSizeHeight(int sizeHeight) {
        this.shapeBuilder.setShapeSizeHeight(this.dip2px(this.mContext, sizeHeight));
        return this;
    }

    public SuperButton setShapeGradientAngle(int gradientAngle) {
        this.shapeBuilder.setShapeGradientAngle(gradientAngle);
        return this;
    }

    public SuperButton setShapeGradientCenterX(int gradientCenterX) {
        this.shapeBuilder.setShapeGradientCenterX(gradientCenterX);
        return this;
    }

    public SuperButton setShapeGradientCenterY(int gradientCenterY) {
        this.shapeBuilder.setShapeGradientCenterY(gradientCenterY);
        return this;
    }

    public SuperButton setShapeGradientGradientRadius(int gradientGradientRadius) {
        this.shapeBuilder.setShapeGradientGradientRadius(gradientGradientRadius);
        return this;
    }

    public SuperButton setShapeGradientStartColor(int gradientStartColor) {
        this.shapeBuilder.setShapeGradientStartColor(gradientStartColor);
        return this;
    }

    public SuperButton setShapeGradientCenterColor(int gradientCenterColor) {
        this.shapeBuilder.setShapeGradientCenterColor(gradientCenterColor);
        return this;
    }

    public SuperButton setShapeGradientEndColor(int gradientEndColor) {
        this.shapeBuilder.setShapeGradientEndColor(gradientEndColor);
        return this;
    }

    public SuperButton setShapeGradientType(int gradientType) {
        this.shapeBuilder.setShapeGradientType(gradientType);
        return this;
    }

    public SuperButton setShapeGradientUseLevel(boolean gradientUseLevel) {
        this.shapeBuilder.setShapeGradientUseLevel(gradientUseLevel);
        return this;
    }

    public SuperButton setShapeUseSelector(boolean useSelector) {
        this.shapeBuilder.setShapeUseSelector(useSelector);
        return this;
    }

    public void setUseShape() {
        this.shapeBuilder.into((View)this);
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

