/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.allen.library.R;

public class CommonTextView
extends RelativeLayout {
    private Context mContext;
    private int defaultColor = -13158601;
    private int defaultDividerLineColor = -1513240;
    private int defaultSize;
    private int defaultPadding;
    private int mBackgroundColor = -1;
    private Drawable mLeft_drawableLeft;
    private Drawable mLeft_drawableTop;
    private Drawable mLeft_drawableRight;
    private Drawable mLeft_drawableBottom;
    private Drawable mCenter_drawableLeft;
    private Drawable mCenter_drawableTop;
    private Drawable mCenter_drawableRight;
    private Drawable mCenter_drawableBottom;
    private Drawable mRight_drawableLeft;
    private Drawable mRight_drawableTop;
    private Drawable mRight_drawableRight;
    private Drawable mRight_drawableBottom;
    private Drawable mLeft_IV_drawable;
    private CharSequence mLeftTextString;
    private CharSequence mLeftTopTextString;
    private CharSequence mLeftBottomTextString;
    private CharSequence mRightTextString;
    private CharSequence mRightTopTextString;
    private CharSequence mRightBottomTextString;
    private CharSequence mCenterTextString;
    private CharSequence mCenterTopTextString;
    private CharSequence mCenterBottomTextString;
    private int mLeftTextSize;
    private int mLeftTopTextSize;
    private int mLeftBottomTextSize;
    private int mRightTextSize;
    private int mRightTopTextSize;
    private int mRightBottomTextSize;
    private int mCenterTextSize;
    private int mCenterTopTextSize;
    private int mCenterBottomTextSize;
    private int mLeftTextColor;
    private int mLeftTopTextColor;
    private int mLeftBottomTextColor;
    private int mCenterTextColor;
    private int mCenterTopTextColor;
    private int mCenterBottomTextColor;
    private int mRightTextColor;
    private int mRightTopTextColor;
    private int mRightBottomTextColor;
    private int mLeftIconDrawablePadding;
    private int mCenterIconDrawablePadding;
    private int mRightIconDrawablePadding;
    private int mLeftViewPaddingLeft;
    private int mLeftViewPaddingRight;
    private int mCenterViewPaddingLeft;
    private int mCenterViewPaddingRight;
    private int mRightViewPaddingLeft;
    private int mRightViewPaddingRight;
    private int mTopDividerLineMarginLR;
    private int mTopDividerLineMarginLeft;
    private int mTopDividerLineMarginRight;
    private int mBottomDividerLineMarginLR;
    private int mBottomDividerLineMarginLeft;
    private int mBottomDividerLineMarginRight;
    private int mBothDividerLineMarginLeft;
    private int mBothDividerLineMarginRight;
    private int mCenterSpaceHeight;
    private int mLeftImageViewMarginLeft;
    private int mDividerLineType;
    private int mDividerLineColor;
    private int mDividerLineHeight;
    private int mLeftTextViewLineSpacingExtra;
    private int mCenterTextViewLineSpacingExtra;
    private int mRightTextViewLineSpacingExtra;
    private static final int NONE = 0;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int BOTH = 3;
    private static final int DEFAULT = 2;
    private boolean useRipple;
    private boolean mSetSingleLine = true;
    private int mSetMaxEms = 10;
    private int mSetLines = 1;
    private static final int Gravity_Left_Center = 0;
    private static final int Gravity_Center = 1;
    private static final int Gravity_Right_Center = 2;
    private static final int DEFAULT_Gravity = 1;
    private int mLeftTextViewGravity;
    private int mCenterTextViewGravity;
    private int mRightTextViewGravity;
    private TextView leftTextView;
    private TextView centerTextView;
    private TextView rightTextView;
    private TextView leftTopTextView;
    private TextView centerTopTextView;
    private TextView rightTopTextView;
    private TextView leftBottomTextView;
    private TextView centerBottomTextView;
    private TextView rightBottomTextView;
    private ImageView leftImageView;
    private View topLineView;
    private View bottomLineView;
    private View centerBaseLineView;
    private boolean mLeftViewIsClickable = false;
    private boolean mCenterViewIsClickable = false;
    private boolean mRightViewIsClickable = false;
    private RelativeLayout.LayoutParams leftTVParams;
    private RelativeLayout.LayoutParams centerTVParams;
    private RelativeLayout.LayoutParams rightTVParams;
    private RelativeLayout.LayoutParams topLineParams;
    private RelativeLayout.LayoutParams bottomLineParams;
    private RelativeLayout.LayoutParams leftTopTVParams;
    private RelativeLayout.LayoutParams centerTopTVParams;
    private RelativeLayout.LayoutParams rightTopTVParams;
    private RelativeLayout.LayoutParams leftBottomTVParams;
    private RelativeLayout.LayoutParams centerBottomTVParams;
    private RelativeLayout.LayoutParams rightBottomTVParams;
    private RelativeLayout.LayoutParams centerBaseLineParams;
    private RelativeLayout.LayoutParams leftIVParams;
    private OnCommonTextViewClickListener onCommonTextViewClickListener;
    private Drawable mBackground_drawable;
    private boolean mIsCenterAlignLeft = false;
    private int mCenterViewMarginLeft;

    public CommonTextView(Context context) {
        this(context, null);
    }

    public CommonTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CommonTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.defaultSize = this.dip2px(context, 13.0f);
        this.defaultPadding = this.dip2px(context, 10.0f);
        this.mCenterSpaceHeight = this.dip2px(context, 5.0f);
        this.getAttr(attrs);
        this.init();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.CommonTextView);
        this.mLeft_drawableLeft = typedArray.getDrawable(R.styleable.CommonTextView_cLeftIconResForDrawableLeft);
        this.mLeft_drawableTop = typedArray.getDrawable(R.styleable.CommonTextView_cLeftIconResForDrawableTop);
        this.mLeft_drawableRight = typedArray.getDrawable(R.styleable.CommonTextView_cLeftIconResForDrawableRight);
        this.mLeft_drawableBottom = typedArray.getDrawable(R.styleable.CommonTextView_cLeftIconResForDrawableBottom);
        this.mCenter_drawableLeft = typedArray.getDrawable(R.styleable.CommonTextView_cCenterIconResForDrawableLeft);
        this.mCenter_drawableTop = typedArray.getDrawable(R.styleable.CommonTextView_cCenterIconResForDrawableTop);
        this.mCenter_drawableRight = typedArray.getDrawable(R.styleable.CommonTextView_cCenterIconResForDrawableRight);
        this.mCenter_drawableBottom = typedArray.getDrawable(R.styleable.CommonTextView_cCenterIconResForDrawableBottom);
        this.mRight_drawableLeft = typedArray.getDrawable(R.styleable.CommonTextView_cRightIconResForDrawableLeft);
        this.mRight_drawableTop = typedArray.getDrawable(R.styleable.CommonTextView_cRightIconResForDrawableTop);
        this.mRight_drawableRight = typedArray.getDrawable(R.styleable.CommonTextView_cRightIconResForDrawableRight);
        this.mRight_drawableBottom = typedArray.getDrawable(R.styleable.CommonTextView_cRightIconResForDrawableBottom);
        this.mLeft_IV_drawable = typedArray.getDrawable(R.styleable.CommonTextView_cLeftImageViewDrawableRes);
        this.mLeftTextString = typedArray.getString(R.styleable.CommonTextView_cLeftTextString);
        this.mLeftTopTextString = typedArray.getString(R.styleable.CommonTextView_cLeftTopTextString);
        this.mLeftBottomTextString = typedArray.getString(R.styleable.CommonTextView_cLeftBottomTextString);
        this.mCenterTextString = typedArray.getString(R.styleable.CommonTextView_cCenterTextString);
        this.mCenterTopTextString = typedArray.getString(R.styleable.CommonTextView_cCenterTopTextString);
        this.mCenterBottomTextString = typedArray.getString(R.styleable.CommonTextView_cCenterBottomTextString);
        this.mRightTextString = typedArray.getString(R.styleable.CommonTextView_cRightTextString);
        this.mRightTopTextString = typedArray.getString(R.styleable.CommonTextView_cRightTopTextString);
        this.mRightBottomTextString = typedArray.getString(R.styleable.CommonTextView_cRightBottomTextString);
        this.mLeftTextColor = typedArray.getColor(R.styleable.CommonTextView_cLeftTextColor, this.defaultColor);
        this.mLeftTopTextColor = typedArray.getColor(R.styleable.CommonTextView_cLeftTopTextColor, this.defaultColor);
        this.mLeftBottomTextColor = typedArray.getColor(R.styleable.CommonTextView_cLeftBottomTextColor, this.defaultColor);
        this.mCenterTextColor = typedArray.getColor(R.styleable.CommonTextView_cCenterTextColor, this.defaultColor);
        this.mCenterTopTextColor = typedArray.getColor(R.styleable.CommonTextView_cCenterTopTextColor, this.defaultColor);
        this.mCenterBottomTextColor = typedArray.getColor(R.styleable.CommonTextView_cCenterBottomTextColor, this.defaultColor);
        this.mRightTextColor = typedArray.getColor(R.styleable.CommonTextView_cRightTextColor, this.defaultColor);
        this.mRightTopTextColor = typedArray.getColor(R.styleable.CommonTextView_cRightTopTextColor, this.defaultColor);
        this.mRightBottomTextColor = typedArray.getColor(R.styleable.CommonTextView_cRightBottomTextColor, this.defaultColor);
        this.mLeftTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftTextSize, this.defaultSize);
        this.mLeftTopTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftTopTextSize, this.defaultSize);
        this.mLeftBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftBottomTextSize, this.defaultSize);
        this.mCenterTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterTextSize, this.defaultSize);
        this.mCenterTopTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterTopTextSize, this.defaultSize);
        this.mCenterBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterBottomTextSize, this.defaultSize);
        this.mRightTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightTextSize, this.defaultSize);
        this.mRightTopTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightTopTextSize, this.defaultSize);
        this.mRightBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightBottomTextSize, this.defaultSize);
        this.mLeftIconDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftIconDrawablePadding, this.defaultPadding);
        this.mCenterIconDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterIconDrawablePadding, this.defaultPadding);
        this.mRightIconDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightIconDrawablePadding, this.defaultPadding);
        this.mLeftViewPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftViewPaddingLeft, this.defaultPadding);
        this.mLeftViewPaddingRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftViewPaddingRight, this.defaultPadding);
        this.mCenterViewPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterViewPaddingLeft, this.defaultPadding);
        this.mCenterViewPaddingRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterViewPaddingRight, this.defaultPadding);
        this.mRightViewPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightViewPaddingLeft, this.defaultPadding);
        this.mRightViewPaddingRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightViewPaddingRight, this.defaultPadding);
        this.mBothDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBothDividerLineMarginLeft, 0);
        this.mBothDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBothDividerLineMarginRight, 0);
        this.mTopDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cTopDividerLineMarginLR, 0);
        this.mTopDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cTopDividerLineMarginLeft, 0);
        this.mTopDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cTopDividerLineMarginRight, 0);
        this.mBottomDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBottomDividerLineMarginLR, 0);
        this.mBottomDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBottomDividerLineMarginLeft, 0);
        this.mBottomDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cBottomDividerLineMarginRight, 0);
        this.mLeftImageViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftImageViewMarginLeft, this.defaultPadding);
        this.mCenterSpaceHeight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterSpaceHeight, this.mCenterSpaceHeight);
        this.mLeftTextViewLineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cLeftTextViewLineSpacingExtra, 0);
        this.mCenterTextViewLineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterTextViewLineSpacingExtra, 0);
        this.mRightTextViewLineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cRightTextViewLineSpacingExtra, 0);
        this.mDividerLineType = typedArray.getInt(R.styleable.CommonTextView_cShowDividerLineType, 2);
        this.mDividerLineColor = typedArray.getColor(R.styleable.CommonTextView_cDividerLineColor, this.defaultDividerLineColor);
        this.mDividerLineHeight = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cDividerLineHeight, this.dip2px(this.mContext, 0.5f));
        this.useRipple = typedArray.getBoolean(R.styleable.CommonTextView_cUseRipple, false);
        this.mBackgroundColor = typedArray.getColor(R.styleable.CommonTextView_cBackgroundColor, this.mBackgroundColor);
        this.mSetSingleLine = typedArray.getBoolean(R.styleable.CommonTextView_cSetSingleLine, true);
        this.mSetMaxEms = typedArray.getInt(R.styleable.CommonTextView_cSetMaxEms, this.mSetMaxEms);
        this.mSetLines = typedArray.getInt(R.styleable.CommonTextView_cSetLines, 1);
        this.mLeftTextViewGravity = typedArray.getInt(R.styleable.CommonTextView_cLeftTextViewGravity, 1);
        this.mCenterTextViewGravity = typedArray.getInt(R.styleable.CommonTextView_cCenterTextViewGravity, 1);
        this.mRightTextViewGravity = typedArray.getInt(R.styleable.CommonTextView_cRightTextViewGravity, 1);
        this.mLeftViewIsClickable = typedArray.getBoolean(R.styleable.CommonTextView_cLeftViewIsClickable, false);
        this.mCenterViewIsClickable = typedArray.getBoolean(R.styleable.CommonTextView_cCenterViewIsClickable, false);
        this.mRightViewIsClickable = typedArray.getBoolean(R.styleable.CommonTextView_cRightViewIsClickable, false);
        this.mBackground_drawable = typedArray.getDrawable(R.styleable.CommonTextView_cBackgroundDrawableRes);
        this.mIsCenterAlignLeft = typedArray.getBoolean(R.styleable.CommonTextView_cIsCenterAlignLeft, false);
        this.mCenterViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.CommonTextView_cCenterViewMarginLeft, this.dip2px(this.mContext, 200.0f));
        typedArray.recycle();
    }

    private void init() {
        this.initCommonTextView();
        this.initLineView();
        this.initCenterBaseLine();
        if (this.mLeft_IV_drawable != null) {
            this.initLeftImageView();
        }
        if (this.mLeftTextString != null || this.mLeft_drawableLeft != null || this.mLeft_drawableRight != null) {
            this.initLeftText();
        }
        if (this.mCenterTextString != null) {
            this.initCenterText();
        }
        if (this.mRightTextString != null || this.mRight_drawableLeft != null || this.mRight_drawableRight != null) {
            this.initRightText();
        }
        if (this.mLeftTopTextString != null) {
            this.initLeftTopText();
        }
        if (this.mLeftBottomTextString != null) {
            this.initLeftBottomText();
        }
        if (this.mCenterTopTextString != null) {
            this.initCenterTopText();
        }
        if (this.mCenterBottomTextString != null) {
            this.initCenterBottomText();
        }
        if (this.mRightTopTextString != null) {
            this.initRightTopText();
        }
        if (this.mRightBottomTextString != null) {
            this.initRightBottomText();
        }
    }

    private void initCommonTextView() {
        this.setBackgroundColor(this.mBackgroundColor);
        if (this.useRipple) {
            this.setBackgroundResource(R.drawable.selector_white);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CommonTextView.this.onCommonTextViewClickListener != null) {
                    CommonTextView.this.onCommonTextViewClickListener.onCommonTextViewClick();
                }
            }
        });
        if (this.mBackground_drawable != null) {
            this.setBackgroundDrawable(this.mBackground_drawable);
        }
    }

    private void initCenterBaseLine() {
        if (this.centerBaseLineView == null) {
            if (this.centerBaseLineParams == null) {
                this.centerBaseLineParams = new RelativeLayout.LayoutParams(-1, this.mCenterSpaceHeight);
                this.centerBaseLineParams.addRule(15, -1);
            }
            this.centerBaseLineView = new View(this.mContext);
            this.centerBaseLineView.setId(R.id.cCenterBaseLineId);
            this.centerBaseLineView.setLayoutParams((ViewGroup.LayoutParams)this.centerBaseLineParams);
        }
        this.addView(this.centerBaseLineView);
    }

    private void initLineView() {
        switch (this.mDividerLineType) {
            case 0: {
                break;
            }
            case 1: {
                this.setTopLineMargin();
                break;
            }
            case 2: {
                this.setBottomLineMargin();
                break;
            }
            case 3: {
                this.setTopLineMargin();
                this.setBottomLineMargin();
            }
        }
    }

    private void setTopLineMargin() {
        if (this.mTopDividerLineMarginLR != 0) {
            this.initTopLineView(this.mTopDividerLineMarginLR, this.mTopDividerLineMarginLR);
        } else if (this.mBothDividerLineMarginLeft != 0 | this.mBothDividerLineMarginRight != 0) {
            this.initTopLineView(this.mBothDividerLineMarginLeft, this.mBothDividerLineMarginRight);
        } else {
            this.initTopLineView(this.mTopDividerLineMarginLeft, this.mTopDividerLineMarginRight);
        }
    }

    private void setBottomLineMargin() {
        if (this.mBottomDividerLineMarginLR != 0) {
            this.initBottomLineView(this.mBottomDividerLineMarginLR, this.mBottomDividerLineMarginLR);
        } else if (this.mBothDividerLineMarginRight != 0 | this.mBothDividerLineMarginRight != 0) {
            this.initBottomLineView(this.mBothDividerLineMarginLeft, this.mBothDividerLineMarginRight);
        } else {
            this.initBottomLineView(this.mBottomDividerLineMarginLeft, this.mBottomDividerLineMarginRight);
        }
    }

    private void initTopLineView(int marginLeft, int marginRight) {
        if (this.topLineView == null) {
            if (this.topLineParams == null) {
                this.topLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.topLineParams.addRule(10, -1);
            this.topLineParams.setMargins(marginLeft, 0, marginRight, 0);
            this.topLineView = new View(this.mContext);
            this.topLineView.setLayoutParams((ViewGroup.LayoutParams)this.topLineParams);
            this.topLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.topLineView);
    }

    private void initBottomLineView(int marginLeft, int marginRight) {
        if (this.bottomLineView == null) {
            if (this.bottomLineParams == null) {
                this.bottomLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.bottomLineParams.addRule(12, -1);
            this.bottomLineParams.setMargins(marginLeft, 0, marginRight, 0);
            this.bottomLineView = new View(this.mContext);
            this.bottomLineView.setLayoutParams((ViewGroup.LayoutParams)this.bottomLineParams);
            this.bottomLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.bottomLineView);
    }

    private void initLeftImageView() {
        this.leftImageView = new ImageView(this.mContext);
        this.leftIVParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftIVParams.addRule(9, -1);
        this.leftIVParams.addRule(15, -1);
        this.leftIVParams.setMargins(this.mLeftImageViewMarginLeft, 0, 0, 0);
        this.leftImageView.setScaleType(ImageView.ScaleType.CENTER);
        this.leftImageView.setId(R.id.cLeftImageViewId);
        this.leftImageView.setLayoutParams((ViewGroup.LayoutParams)this.leftIVParams);
        if (this.mLeft_IV_drawable != null) {
            this.leftImageView.setImageDrawable(this.mLeft_IV_drawable);
        }
        this.addView((View)this.leftImageView);
    }

    private void initLeftText() {
        if (this.leftTextView == null) {
            if (this.leftTVParams == null) {
                this.leftTVParams = this.getParams(this.leftTVParams);
            }
            this.leftTVParams.addRule(15, -1);
            this.leftTVParams.addRule(1, R.id.cLeftImageViewId);
            this.leftTVParams.setMargins(this.mLeftViewPaddingLeft, 0, this.mLeftViewPaddingRight, 0);
            this.leftTextView = this.initText(this.leftTextView, this.leftTVParams, R.id.cLeftTextId, this.mLeftTextColor, this.mLeftTextSize);
            this.leftTextView.setText(this.mLeftTextString);
            this.leftTextView.setLineSpacing((float)this.mLeftTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.leftTextView, this.mLeftTextViewGravity);
            if (this.mLeftViewIsClickable) {
                this.leftTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CommonTextView.this.onCommonTextViewClickListener != null) {
                            CommonTextView.this.onCommonTextViewClickListener.onLeftViewClick();
                        }
                    }
                });
            }
        }
        this.setDrawable(this.leftTextView, this.mLeft_drawableLeft, this.mLeft_drawableTop, this.mLeft_drawableRight, this.mLeft_drawableBottom, this.mLeftIconDrawablePadding);
    }

    private void initLeftTopText() {
        if (this.leftTopTextView == null) {
            if (this.leftTopTVParams == null) {
                this.leftTopTVParams = this.getParams(this.leftTopTVParams);
            }
            this.leftTopTVParams.addRule(15, -1);
            this.leftTopTVParams.addRule(2, R.id.cCenterBaseLineId);
            this.leftTopTVParams.addRule(1, R.id.cLeftImageViewId);
            this.leftTopTVParams.setMargins(this.mLeftViewPaddingLeft, 0, this.mLeftViewPaddingRight, 0);
            this.leftTopTextView = this.initText(this.leftTopTextView, this.leftTopTVParams, R.id.cLeftTopTextId, this.mLeftTopTextColor, this.mLeftTopTextSize);
            this.leftTopTextView.setText(this.mLeftTopTextString);
            this.setTextViewGravity(this.leftTopTextView, this.mLeftTextViewGravity);
        }
    }

    private void initLeftBottomText() {
        if (this.leftBottomTextView == null) {
            if (this.leftBottomTVParams == null) {
                this.leftBottomTVParams = this.getParams(this.leftBottomTVParams);
            }
            this.leftBottomTVParams.addRule(15, -1);
            this.leftBottomTVParams.addRule(3, R.id.cCenterBaseLineId);
            this.leftBottomTVParams.addRule(1, R.id.cLeftImageViewId);
            this.leftBottomTVParams.setMargins(this.mLeftViewPaddingLeft, 0, this.mLeftViewPaddingRight, 0);
            this.leftBottomTextView = this.initText(this.leftBottomTextView, this.leftBottomTVParams, R.id.cLeftBottomTextId, this.mLeftBottomTextColor, this.mLeftBottomTextSize);
            this.leftBottomTextView.setText(this.mLeftBottomTextString);
            this.setTextViewGravity(this.leftBottomTextView, this.mLeftTextViewGravity);
        }
    }

    private void initCenterText() {
        if (this.centerTextView == null) {
            if (this.centerTVParams == null) {
                this.centerTVParams = this.mIsCenterAlignLeft ? new RelativeLayout.LayoutParams(-1, -2) : this.getParams(this.centerTVParams);
            }
            this.centerTVParams.addRule(15, -1);
            this.centerTVParams.addRule(13, -1);
            if (this.mIsCenterAlignLeft) {
                this.centerTextView = this.initText(this.centerTextView, this.centerTVParams, R.id.cCenterTextId, this.mCenterTextColor, this.mCenterTextSize);
                this.centerTVParams.setMargins(this.mCenterViewMarginLeft, 0, this.mCenterViewPaddingRight, 0);
                this.setTextViewGravity(this.centerTextView, 0);
            } else {
                this.centerTextView = this.initText(this.centerTextView, this.centerTVParams, R.id.cCenterTextId, this.mCenterTextColor, this.mCenterTextSize);
                this.centerTVParams.setMargins(this.mCenterViewPaddingLeft, 0, this.mCenterViewPaddingRight, 0);
                this.setTextViewGravity(this.centerTextView, this.mCenterTextViewGravity);
            }
            this.centerTextView.setText(this.mCenterTextString);
            this.centerTextView.setLineSpacing((float)this.mCenterTextViewLineSpacingExtra, 1.0f);
            if (this.mCenterViewIsClickable) {
                this.centerTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CommonTextView.this.onCommonTextViewClickListener != null) {
                            CommonTextView.this.onCommonTextViewClickListener.onCenterViewClick();
                        }
                    }
                });
            }
        }
        this.setDrawable(this.centerTextView, this.mCenter_drawableLeft, this.mCenter_drawableTop, this.mCenter_drawableRight, this.mCenter_drawableBottom, this.mCenterIconDrawablePadding);
    }

    private void initCenterTopText() {
        if (this.centerTopTextView == null) {
            if (this.centerTopTVParams == null) {
                this.centerTopTVParams = this.getParams(this.centerTopTVParams);
            }
            this.centerTopTVParams.addRule(15, -1);
            this.centerTopTVParams.addRule(13, -1);
            this.centerTopTVParams.addRule(2, R.id.cCenterBaseLineId);
            this.centerTopTVParams.setMargins(this.mCenterViewPaddingLeft, 0, this.mCenterViewPaddingRight, 0);
            this.centerTopTextView = this.initText(this.centerTopTextView, this.centerTopTVParams, R.id.cCenterTopTextId, this.mCenterTopTextColor, this.mCenterTopTextSize);
            this.centerTopTextView.setText(this.mCenterTopTextString);
            this.centerTopTextView.setLineSpacing((float)this.mCenterTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.centerTopTextView, this.mCenterTextViewGravity);
        }
    }

    private void initCenterBottomText() {
        if (this.centerBottomTextView == null) {
            if (this.centerBottomTVParams == null) {
                this.centerBottomTVParams = this.getParams(this.centerBottomTVParams);
            }
            this.centerBottomTVParams.addRule(15, -1);
            this.centerBottomTVParams.addRule(13, -1);
            this.centerBottomTVParams.addRule(3, R.id.cCenterBaseLineId);
            this.centerBottomTVParams.setMargins(this.mCenterViewPaddingLeft, 0, this.mCenterViewPaddingRight, 0);
            this.centerBottomTextView = this.initText(this.centerBottomTextView, this.centerBottomTVParams, R.id.cCenterBottomTextId, this.mCenterBottomTextColor, this.mCenterBottomTextSize);
            this.centerBottomTextView.setText(this.mCenterBottomTextString);
            this.centerBottomTextView.setLineSpacing((float)this.mCenterTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.centerBottomTextView, this.mCenterTextViewGravity);
        }
    }

    private void initRightText() {
        if (this.rightTextView == null) {
            if (this.rightTVParams == null) {
                this.rightTVParams = this.getParams(this.rightTVParams);
            }
            this.rightTVParams.addRule(15, -1);
            this.rightTVParams.addRule(11, -1);
            this.rightTVParams.addRule(0, R.id.cRightImageViewId);
            this.rightTVParams.setMargins(this.mRightViewPaddingLeft, 0, this.mRightViewPaddingRight, 0);
            this.rightTextView = this.initText(this.rightTextView, this.rightTVParams, R.id.cRightTextId, this.mRightTextColor, this.mRightTextSize);
            this.rightTextView.setText(this.mRightTextString);
            this.rightTextView.setLineSpacing((float)this.mRightTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.rightTextView, this.mRightTextViewGravity);
            if (this.mRightViewIsClickable) {
                this.rightTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (CommonTextView.this.onCommonTextViewClickListener != null) {
                            CommonTextView.this.onCommonTextViewClickListener.onRightViewClick();
                        }
                    }
                });
            }
        }
        this.setDrawable(this.rightTextView, this.mRight_drawableLeft, this.mRight_drawableTop, this.mRight_drawableRight, this.mRight_drawableBottom, this.mRightIconDrawablePadding);
    }

    private void initRightTopText() {
        if (this.rightTopTextView == null) {
            if (this.rightTopTVParams == null) {
                this.rightTopTVParams = this.getParams(this.rightTopTVParams);
            }
            this.rightTopTVParams.addRule(15, -1);
            this.rightTopTVParams.addRule(11, -1);
            this.rightTopTVParams.addRule(2, R.id.cCenterBaseLineId);
            this.rightTopTVParams.addRule(0, R.id.cRightImageViewId);
            this.rightTopTVParams.setMargins(this.mRightViewPaddingLeft, 0, this.mRightViewPaddingRight, 0);
            this.rightTopTextView = this.initText(this.rightTopTextView, this.rightTopTVParams, R.id.cRightTopTextId, this.mRightTopTextColor, this.mRightTopTextSize);
            this.rightTopTextView.setText(this.mRightTopTextString);
            this.rightTopTextView.setLineSpacing((float)this.mRightTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.rightTopTextView, this.mRightTextViewGravity);
        }
    }

    private void initRightBottomText() {
        if (this.rightBottomTextView == null) {
            if (this.rightBottomTVParams == null) {
                this.rightBottomTVParams = this.getParams(this.rightBottomTVParams);
            }
            this.rightBottomTVParams.addRule(15, -1);
            this.rightBottomTVParams.addRule(11, -1);
            this.rightBottomTVParams.addRule(3, R.id.cCenterBaseLineId);
            this.rightBottomTVParams.addRule(0, R.id.cRightImageViewId);
            this.rightBottomTVParams.setMargins(this.mRightViewPaddingLeft, 0, this.mRightViewPaddingRight, 0);
            this.rightBottomTextView = this.initText(this.rightBottomTextView, this.rightBottomTVParams, R.id.cRightBottomTextId, this.mRightBottomTextColor, this.mRightBottomTextSize);
            this.rightBottomTextView.setText(this.mRightBottomTextString);
            this.rightBottomTextView.setLineSpacing((float)this.mRightTextViewLineSpacingExtra, 1.0f);
            this.setTextViewGravity(this.rightBottomTextView, this.mRightTextViewGravity);
        }
    }

    public RelativeLayout.LayoutParams getParams(RelativeLayout.LayoutParams params) {
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    public TextView initText(TextView textView, RelativeLayout.LayoutParams layoutParams, int id2, int textColor, int textSize) {
        if (textView == null) {
            textView = new TextView(this.mContext);
            textView.setId(id2);
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setTextColor(textColor);
            textView.setTextSize(0, (float)textSize);
            textView.setLines(this.mSetLines);
            textView.setSingleLine(this.mSetSingleLine);
            textView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mSetMaxEms)});
            this.addView((View)textView);
        }
        return textView;
    }

    private void setTextViewGravity(TextView textView, int gravity_type) {
        switch (gravity_type) {
            case 0: {
                textView.setGravity(19);
                break;
            }
            case 1: {
                textView.setGravity(17);
                break;
            }
            case 2: {
                textView.setGravity(21);
            }
        }
    }

    public void setDrawable(TextView textView, Drawable drawableLeft, Drawable drawableTop, Drawable drawableRight, Drawable drawableBottom, int drawablePadding) {
        textView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        textView.setCompoundDrawablePadding(drawablePadding);
    }

    public CommonTextView setLeftTextString(CharSequence string) {
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setText(string);
        return this;
    }

    public CommonTextView setLeftTopTextString(CharSequence string) {
        if (this.leftTopTextView == null) {
            this.initLeftTopText();
        }
        this.leftTopTextView.setText(string);
        return this;
    }

    public CommonTextView setLeftBottomTextString(CharSequence string) {
        if (this.leftBottomTextView == null) {
            this.initLeftBottomText();
        }
        this.leftBottomTextView.setText(string);
        return this;
    }

    public CommonTextView setLeftTextSize(float size) {
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setTextSize(size);
        return this;
    }

    public CommonTextView setLeftTextColor(int color) {
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setTextColor(color);
        return this;
    }

    public CommonTextView setCenterTextString(CharSequence string) {
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setText(string);
        return this;
    }

    public CommonTextView setCenterTopTextString(CharSequence string) {
        if (this.centerTopTextView == null) {
            this.initCenterTopText();
        }
        this.centerTopTextView.setText(string);
        return this;
    }

    public CommonTextView setCenterBottomTextString(CharSequence string) {
        if (this.centerBottomTextView == null) {
            this.initCenterBottomText();
        }
        this.centerBottomTextView.setText(string);
        return this;
    }

    public CommonTextView setCenterTextSize(float size) {
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setTextSize(size);
        return this;
    }

    public CommonTextView setCenterTextColor(int color) {
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setTextColor(color);
        return this;
    }

    public CommonTextView setRightTextString(CharSequence string) {
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setText(string);
        return this;
    }

    public CommonTextView setRightTopTextString(CharSequence string) {
        if (this.rightTopTextView == null) {
            this.initRightTopText();
        }
        this.rightTopTextView.setText(string);
        return this;
    }

    public CommonTextView setRightBottomTextString(CharSequence string) {
        if (this.rightBottomTextView == null) {
            this.initRightBottomText();
        }
        this.rightBottomTextView.setText(string);
        return this;
    }

    public CommonTextView setRightTextSize(float size) {
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setTextSize(size);
        return this;
    }

    public CommonTextView setRightTextColor(int color) {
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setTextColor(color);
        return this;
    }

    public CommonTextView setLeftDrawableLeft(Drawable drawableLeft) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, drawableLeft.getMinimumWidth(), drawableLeft.getMinimumHeight());
        }
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setCompoundDrawables(drawableLeft, null, null, null);
        return this;
    }

    public CommonTextView setLeftDrawableTop(Drawable drawableTop) {
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        }
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setCompoundDrawables(null, drawableTop, null, null);
        return this;
    }

    public CommonTextView setLeftDrawableRight(Drawable drawableRight) {
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, drawableRight.getMinimumWidth(), drawableRight.getMinimumHeight());
        }
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setCompoundDrawables(null, null, drawableRight, null);
        return this;
    }

    public CommonTextView setLeftDrawableBottom(Drawable drawableBottom) {
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, drawableBottom.getMinimumWidth(), drawableBottom.getMinimumHeight());
        }
        if (this.leftTextView == null) {
            this.initLeftText();
        }
        this.leftTextView.setCompoundDrawables(null, null, null, drawableBottom);
        return this;
    }

    public CommonTextView setCenterDrawableLeft(Drawable drawableLeft) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, drawableLeft.getMinimumWidth(), drawableLeft.getMinimumHeight());
        }
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setCompoundDrawables(drawableLeft, null, null, null);
        return this;
    }

    public CommonTextView setCenterDrawableTop(Drawable drawableTop) {
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        }
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setCompoundDrawables(null, drawableTop, null, null);
        return this;
    }

    public CommonTextView setCenterDrawableRight(Drawable drawableRight) {
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, drawableRight.getMinimumWidth(), drawableRight.getMinimumHeight());
        }
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setCompoundDrawables(null, null, drawableRight, null);
        return this;
    }

    public CommonTextView setCenterDrawableBottom(Drawable drawableBottom) {
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, drawableBottom.getMinimumWidth(), drawableBottom.getMinimumHeight());
        }
        if (this.centerTextView == null) {
            this.initCenterText();
        }
        this.centerTextView.setCompoundDrawables(null, null, null, drawableBottom);
        return this;
    }

    public CommonTextView setRightDrawableLeft(Drawable drawableLeft) {
        if (drawableLeft != null) {
            drawableLeft.setBounds(0, 0, drawableLeft.getMinimumWidth(), drawableLeft.getMinimumHeight());
        }
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setCompoundDrawables(drawableLeft, null, null, null);
        return this;
    }

    public CommonTextView setRightDrawableTop(Drawable drawableTop) {
        if (drawableTop != null) {
            drawableTop.setBounds(0, 0, drawableTop.getMinimumWidth(), drawableTop.getMinimumHeight());
        }
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setCompoundDrawables(null, drawableTop, null, null);
        return this;
    }

    public CommonTextView setRightDrawableRight(Drawable drawableRight) {
        if (drawableRight != null) {
            drawableRight.setBounds(0, 0, drawableRight.getMinimumWidth(), drawableRight.getMinimumHeight());
        }
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setCompoundDrawables(null, null, drawableRight, null);
        return this;
    }

    public CommonTextView setRightDrawableBottom(Drawable drawableBottom) {
        if (drawableBottom != null) {
            drawableBottom.setBounds(0, 0, drawableBottom.getMinimumWidth(), drawableBottom.getMinimumHeight());
        }
        if (this.rightTextView == null) {
            this.initRightText();
        }
        this.rightTextView.setCompoundDrawables(null, null, null, drawableBottom);
        return this;
    }

    public ImageView getLeftImageView() {
        if (this.leftImageView == null) {
            this.initLeftImageView();
        }
        return this.leftImageView;
    }

    public CharSequence getLeftTextString() {
        return this.leftTextView != null ? this.leftTextView.getText() : "";
    }

    public CharSequence getLeftTopTextString() {
        return this.leftTopTextView != null ? this.leftTopTextView.getText() : "";
    }

    public CharSequence getLeftBottomTextString() {
        return this.leftBottomTextView != null ? this.leftBottomTextView.getText() : "";
    }

    public CharSequence getCenterTextString() {
        return this.centerTextView != null ? this.centerTextView.getText() : "";
    }

    public CharSequence getCenterTopTextString() {
        return this.centerTopTextView != null ? this.centerTopTextView.getText() : "";
    }

    public CharSequence getCenterBottomTextString() {
        return this.centerBottomTextView != null ? this.centerBottomTextView.getText() : "";
    }

    public CharSequence getRightTextString() {
        return this.rightTextView != null ? this.rightTextView.getText() : "";
    }

    public CharSequence getRightTopTextString() {
        return this.rightTopTextView != null ? this.rightTopTextView.getText() : "";
    }

    public CharSequence getRightBottomTextString() {
        return this.rightBottomTextView != null ? this.rightBottomTextView.getText() : "";
    }

    public CommonTextView setOnCommonTextViewClickListener(OnCommonTextViewClickListener listener) {
        this.onCommonTextViewClickListener = listener;
        return this;
    }

    public CommonTextView setLeftViewIsClickable(boolean isClickable) {
        if (isClickable && this.leftTextView != null) {
            this.leftTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonTextView.this.onCommonTextViewClickListener != null) {
                        CommonTextView.this.onCommonTextViewClickListener.onLeftViewClick();
                    }
                }
            });
        }
        return this;
    }

    public CommonTextView setCenterViewIsClickable(boolean isClickable) {
        if (isClickable && this.centerTextView != null) {
            this.centerTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonTextView.this.onCommonTextViewClickListener != null) {
                        CommonTextView.this.onCommonTextViewClickListener.onCenterViewClick();
                    }
                }
            });
        }
        return this;
    }

    public CommonTextView setRightViewIsClickable(boolean isClickable) {
        if (isClickable && this.rightTextView != null) {
            this.rightTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonTextView.this.onCommonTextViewClickListener != null) {
                        CommonTextView.this.onCommonTextViewClickListener.onRightViewClick();
                    }
                }
            });
        }
        return this;
    }

    public int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * scale + 0.5f);
    }

    public static class OnCommonTextViewClickListener {
        public void onCommonTextViewClick() {
        }

        public void onLeftViewClick() {
        }

        public void onCenterViewClick() {
        }

        public void onRightViewClick() {
        }
    }
}

