/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Switch;
import android.widget.TextView;
import com.allen.library.BaseTextView;
import com.allen.library.R;

public class SuperTextView
extends RelativeLayout {
    private Context mContext;
    private BaseTextView leftView;
    private BaseTextView centerView;
    private BaseTextView rightView;
    private RelativeLayout.LayoutParams leftBaseViewParams;
    private RelativeLayout.LayoutParams centerBaseViewParams;
    private RelativeLayout.LayoutParams rightBaseViewParams;
    private ImageView leftIconIV;
    private ImageView rightIconIV;
    private RelativeLayout.LayoutParams leftImgParams;
    private RelativeLayout.LayoutParams rightImgParams;
    private int leftIconWidth;
    private int leftIconHeight;
    private int rightIconWidth;
    private int rightIconHeight;
    private int leftIconMarginLeft;
    private int rightIconMarginRight;
    private Drawable leftIconRes;
    private Drawable rightIconRes;
    private int defaultColor = -13158601;
    private int defaultSize = 15;
    private int defaultMaxEms = 15;
    private String mLeftTextString;
    private String mLeftTopTextString;
    private String mLeftBottomTextString;
    private String mRightTextString;
    private String mRightTopTextString;
    private String mRightBottomTextString;
    private String mCenterTextString;
    private String mCenterTopTextString;
    private String mCenterBottomTextString;
    private int mLeftTextColor;
    private int mLeftTopTextColor;
    private int mLeftBottomTextColor;
    private int mCenterTextColor;
    private int mCenterTopTextColor;
    private int mCenterBottomTextColor;
    private int mRightTextColor;
    private int mRightTopTextColor;
    private int mRightBottomTextColor;
    private int mLeftTextSize;
    private int mLeftTopTextSize;
    private int mLeftBottomTextSize;
    private int mRightTextSize;
    private int mRightTopTextSize;
    private int mRightBottomTextSize;
    private int mCenterTextSize;
    private int mCenterTopTextSize;
    private int mCenterBottomTextSize;
    private int mLeftTopLines;
    private int mLeftLines;
    private int mLeftBottomLines;
    private int mCenterTopLines;
    private int mCenterLines;
    private int mCenterBottomLines;
    private int mRightTopLines;
    private int mRightLines;
    private int mRightBottomLines;
    private int mLeftTopMaxEms;
    private int mLeftMaxEms;
    private int mLeftBottomMaxEms;
    private int mCenterTopMaxEms;
    private int mCenterMaxEms;
    private int mCenterBottomMaxEms;
    private int mRightTopMaxEms;
    private int mRightMaxEms;
    private int mRightBottomMaxEms;
    private boolean mLeftTopTextBold;
    private boolean mLeftTextBold;
    private boolean mLeftBottomTextBold;
    private boolean mCenterTopTextBold;
    private boolean mCenterTextBold;
    private boolean mCenterBottomTextBold;
    private boolean mRightTopTextBold;
    private boolean mRightTextBold;
    private boolean mRightBottomTextBold;
    private Drawable mLeftTextBackground;
    private Drawable mCenterTextBackground;
    private Drawable mRightTextBackground;
    private Drawable mLeftTvDrawableLeft;
    private Drawable mLeftTvDrawableRight;
    private Drawable mCenterTvDrawableLeft;
    private Drawable mCenterTvDrawableRight;
    private Drawable mRightTvDrawableLeft;
    private Drawable mRightTvDrawableRight;
    private int mRightTvDrawableRightWidth;
    private int mRightTvDrawableRightHeight;
    private int mTextViewDrawablePadding;
    private static final int gravity_Left_Center = 0;
    private static final int gravity_Center = 1;
    private static final int gravity_Right_Center = 2;
    private static final int default_Gravity = 1;
    private int mLeftGravity;
    private int mCenterGravity;
    private int mRightGravity;
    private int mLeftViewWidth;
    private View topDividerLineView;
    private View bottomDividerLineView;
    private RelativeLayout.LayoutParams topDividerLineParams;
    private RelativeLayout.LayoutParams bottomDividerLineParams;
    private int mTopDividerLineMarginLR;
    private int mTopDividerLineMarginLeft;
    private int mTopDividerLineMarginRight;
    private int mBottomDividerLineMarginLR;
    private int mBottomDividerLineMarginLeft;
    private int mBottomDividerLineMarginRight;
    private int mDividerLineType;
    private int mDividerLineColor;
    private int mDividerLineHeight;
    private int mDefaultDividerLineColor = -1513240;
    private static final int NONE = 0;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int BOTH = 3;
    private static final int default_Divider = 2;
    private int default_Margin = 10;
    private int mLeftViewMarginLeft;
    private int mLeftViewMarginRight;
    private int mCenterViewMarginLeft;
    private int mCenterViewMarginRight;
    private int mRightViewMarginLeft;
    private int mRightViewMarginRight;
    private boolean useRipple;
    private Drawable mBackground_drawable;
    private OnSuperTextViewClickListener superTextViewClickListener;
    private OnLeftTopTvClickListener leftTopTvClickListener;
    private OnLeftTvClickListener leftTvClickListener;
    private OnLeftBottomTvClickListener leftBottomTvClickListener;
    private OnCenterTopTvClickListener centerTopTvClickListener;
    private OnCenterTvClickListener centerTvClickListener;
    private OnCenterBottomTvClickListener centerBottomTvClickListener;
    private OnRightTopTvClickListener rightTopTvClickListener;
    private OnRightTvClickListener rightTvClickListener;
    private OnRightBottomTvClickListener rightBottomTvClickListener;
    private OnSwitchCheckedChangeListener switchCheckedChangeListener;
    private OnCheckBoxCheckedChangeListener checkBoxCheckedChangeListener;
    private OnLeftImageViewClickListener leftImageViewClickListener;
    private OnRightImageViewClickListener rightImageViewClickListener;
    private static final int TYPE_CHECKBOX = 0;
    private static final int TYPE_SWITCH = 1;
    private static int mRightViewType;
    private CheckBox rightCheckBox;
    private RelativeLayout.LayoutParams rightCheckBoxParams;
    private Drawable rightCheckBoxBg;
    private int rightCheckBoxMarginRight;
    private boolean isChecked;
    private int centerSpaceHeight;
    private Switch mSwitch;
    private RelativeLayout.LayoutParams mSwitchParams;
    private int rightSwitchMarginRight;
    private boolean switchIsChecked = true;
    private String mTextOff;
    private String mTextOn;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private int mThumbTextPadding;
    private Drawable mThumbResource;
    private Drawable mTrackResource;
    private int defaultShapeColor = -1;
    private int selectorPressedColor;
    private int selectorNormalColor;
    private int solidColor;
    private float cornersRadius;
    private float cornersTopLeftRadius;
    private float cornersTopRightRadius;
    private float cornersBottomLeftRadius;
    private float cornersBottomRightRadius;
    private int strokeWidth;
    private int strokeColor;
    private float strokeDashWidth;
    private float strokeDashGap;
    private boolean useShape;
    private GradientDrawable gradientDrawable;

    public SuperTextView(Context context) {
        this(context, null);
    }

    public SuperTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.defaultSize = this.sp2px(context, this.defaultSize);
        this.default_Margin = this.dip2px(context, this.default_Margin);
        this.getAttr(attrs);
        this.initView();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.SuperTextView);
        this.mLeftTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTextString);
        this.mLeftTopTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTopTextString);
        this.mLeftBottomTextString = typedArray.getString(R.styleable.SuperTextView_sLeftBottomTextString);
        this.mCenterTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTextString);
        this.mCenterTopTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTopTextString);
        this.mCenterBottomTextString = typedArray.getString(R.styleable.SuperTextView_sCenterBottomTextString);
        this.mRightTextString = typedArray.getString(R.styleable.SuperTextView_sRightTextString);
        this.mRightTopTextString = typedArray.getString(R.styleable.SuperTextView_sRightTopTextString);
        this.mRightBottomTextString = typedArray.getString(R.styleable.SuperTextView_sRightBottomTextString);
        this.mLeftTextColor = typedArray.getColor(R.styleable.SuperTextView_sLeftTextColor, this.defaultColor);
        this.mLeftTopTextColor = typedArray.getColor(R.styleable.SuperTextView_sLeftTopTextColor, this.defaultColor);
        this.mLeftBottomTextColor = typedArray.getColor(R.styleable.SuperTextView_sLeftBottomTextColor, this.defaultColor);
        this.mCenterTextColor = typedArray.getColor(R.styleable.SuperTextView_sCenterTextColor, this.defaultColor);
        this.mCenterTopTextColor = typedArray.getColor(R.styleable.SuperTextView_sCenterTopTextColor, this.defaultColor);
        this.mCenterBottomTextColor = typedArray.getColor(R.styleable.SuperTextView_sCenterBottomTextColor, this.defaultColor);
        this.mRightTextColor = typedArray.getColor(R.styleable.SuperTextView_sRightTextColor, this.defaultColor);
        this.mRightTopTextColor = typedArray.getColor(R.styleable.SuperTextView_sRightTopTextColor, this.defaultColor);
        this.mRightBottomTextColor = typedArray.getColor(R.styleable.SuperTextView_sRightBottomTextColor, this.defaultColor);
        this.mLeftTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTextSize, this.defaultSize);
        this.mLeftTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTopTextSize, this.defaultSize);
        this.mLeftBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextSize, this.defaultSize);
        this.mCenterTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTextSize, this.defaultSize);
        this.mCenterTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTopTextSize, this.defaultSize);
        this.mCenterBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterBottomTextSize, this.defaultSize);
        this.mRightTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTextSize, this.defaultSize);
        this.mRightTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTopTextSize, this.defaultSize);
        this.mRightBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightBottomTextSize, this.defaultSize);
        this.mLeftTopLines = typedArray.getInt(R.styleable.SuperTextView_sLeftTopLines, 1);
        this.mLeftLines = typedArray.getInt(R.styleable.SuperTextView_sLeftLines, 1);
        this.mLeftBottomLines = typedArray.getInt(R.styleable.SuperTextView_sLeftBottomLines, 1);
        this.mCenterTopLines = typedArray.getInt(R.styleable.SuperTextView_sCenterTopLines, 1);
        this.mCenterLines = typedArray.getInt(R.styleable.SuperTextView_sCenterLines, 1);
        this.mCenterBottomLines = typedArray.getInt(R.styleable.SuperTextView_sCenterBottomLines, 1);
        this.mRightTopLines = typedArray.getInt(R.styleable.SuperTextView_sRightTopLines, 1);
        this.mRightLines = typedArray.getInt(R.styleable.SuperTextView_sRightLines, 1);
        this.mRightBottomLines = typedArray.getInt(R.styleable.SuperTextView_sRightBottomLines, 1);
        this.mLeftTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftTopMaxEms, this.defaultMaxEms);
        this.mLeftMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftMaxEms, this.defaultMaxEms);
        this.mLeftBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftBottomMaxEms, this.defaultMaxEms);
        this.mCenterTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterTopMaxEms, this.defaultMaxEms);
        this.mCenterMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterMaxEms, this.defaultMaxEms);
        this.mCenterBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterBottomMaxEms, this.defaultMaxEms);
        this.mRightTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightTopMaxEms, this.defaultMaxEms);
        this.mRightMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightMaxEms, this.defaultMaxEms);
        this.mRightBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightBottomMaxEms, this.defaultMaxEms);
        this.mLeftGravity = typedArray.getInt(R.styleable.SuperTextView_sLeftViewGravity, 1);
        this.mCenterGravity = typedArray.getInt(R.styleable.SuperTextView_sCenterViewGravity, 1);
        this.mRightGravity = typedArray.getInt(R.styleable.SuperTextView_sRightViewGravity, 1);
        this.mLeftTvDrawableLeft = typedArray.getDrawable(R.styleable.SuperTextView_sLeftTvDrawableLeft);
        this.mLeftTvDrawableRight = typedArray.getDrawable(R.styleable.SuperTextView_sLeftTvDrawableRight);
        this.mCenterTvDrawableLeft = typedArray.getDrawable(R.styleable.SuperTextView_sCenterTvDrawableLeft);
        this.mCenterTvDrawableRight = typedArray.getDrawable(R.styleable.SuperTextView_sCenterTvDrawableRight);
        this.mRightTvDrawableLeft = typedArray.getDrawable(R.styleable.SuperTextView_sRightTvDrawableLeft);
        this.mRightTvDrawableRight = typedArray.getDrawable(R.styleable.SuperTextView_sRightTvDrawableRight);
        this.mTextViewDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTextViewDrawablePadding, this.default_Margin);
        this.mRightTvDrawableRightWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTvDrawableRightWidth, -1);
        this.mRightTvDrawableRightHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTvDrawableRightHeight, -1);
        this.mLeftViewWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewWidth, 0);
        this.mTopDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginLR, 0);
        this.mTopDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginLeft, 0);
        this.mTopDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginRight, 0);
        this.mBottomDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginLR, 0);
        this.mBottomDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginLeft, 0);
        this.mBottomDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginRight, 0);
        this.mDividerLineType = typedArray.getInt(R.styleable.SuperTextView_sDividerLineType, 2);
        this.mDividerLineColor = typedArray.getColor(R.styleable.SuperTextView_sDividerLineColor, this.mDefaultDividerLineColor);
        this.mDividerLineHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sDividerLineHeight, this.dip2px(this.mContext, 0.5f));
        this.mLeftViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewMarginLeft, this.default_Margin);
        this.mLeftViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewMarginRight, this.default_Margin);
        this.mCenterViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterViewMarginLeft, 0);
        this.mCenterViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterViewMarginRight, 0);
        this.mRightViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightViewMarginLeft, this.default_Margin);
        this.mRightViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightViewMarginRight, this.default_Margin);
        this.leftIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconWidth, 0);
        this.leftIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconHeight, 0);
        this.rightIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconWidth, 0);
        this.rightIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconHeight, 0);
        this.leftIconMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconMarginLeft, this.default_Margin);
        this.rightIconMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconMarginRight, this.default_Margin);
        this.leftIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sLeftIconRes);
        this.rightIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sRightIconRes);
        this.mLeftTopTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sLeftTopTextIsBold, false);
        this.mLeftTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sLeftTextIsBold, false);
        this.mLeftBottomTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sLeftBottomTextIsBold, false);
        this.mCenterTopTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sCenterTopTextIsBold, false);
        this.mCenterTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sCenterTextIsBold, false);
        this.mCenterBottomTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sCenterBottomTextIsBold, false);
        this.mRightTopTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sRightTopTextIsBold, false);
        this.mRightTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sRightTextIsBold, false);
        this.mRightBottomTextBold = typedArray.getBoolean(R.styleable.SuperTextView_sRightBottomTextIsBold, false);
        this.mLeftTextBackground = typedArray.getDrawable(R.styleable.SuperTextView_sLeftTextBackground);
        this.mCenterTextBackground = typedArray.getDrawable(R.styleable.SuperTextView_sCenterTextBackground);
        this.mRightTextBackground = typedArray.getDrawable(R.styleable.SuperTextView_sRightTextBackground);
        this.useRipple = typedArray.getBoolean(R.styleable.SuperTextView_sUseRipple, true);
        this.mBackground_drawable = typedArray.getDrawable(R.styleable.SuperTextView_sBackgroundDrawableRes);
        mRightViewType = typedArray.getInt(R.styleable.SuperTextView_sRightViewType, -1);
        this.isChecked = typedArray.getBoolean(R.styleable.SuperTextView_sIsChecked, false);
        this.rightCheckBoxMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightCheckBoxMarginRight, this.default_Margin);
        this.rightCheckBoxBg = typedArray.getDrawable(R.styleable.SuperTextView_sRightCheckBoxRes);
        this.rightSwitchMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightSwitchMarginRight, this.default_Margin);
        this.switchIsChecked = typedArray.getBoolean(R.styleable.SuperTextView_sSwitchIsChecked, false);
        this.mTextOff = typedArray.getString(R.styleable.SuperTextView_sTextOff);
        this.mTextOn = typedArray.getString(R.styleable.SuperTextView_sTextOn);
        this.mSwitchMinWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sSwitchMinWidth, 0);
        this.mSwitchPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sSwitchPadding, 0);
        this.mThumbTextPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sThumbTextPadding, 0);
        this.mThumbResource = typedArray.getDrawable(R.styleable.SuperTextView_sThumbResource);
        this.mTrackResource = typedArray.getDrawable(R.styleable.SuperTextView_sTrackResource);
        this.centerSpaceHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterSpaceHeight, this.dip2px(this.mContext, 5.0f));
        this.selectorPressedColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSelectorPressedColor, this.defaultShapeColor);
        this.selectorNormalColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSelectorNormalColor, this.defaultShapeColor);
        this.solidColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSolidColor, this.defaultShapeColor);
        this.cornersRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersRadius, 0);
        this.cornersTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersTopLeftRadius, 0);
        this.cornersTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersTopRightRadius, 0);
        this.cornersBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersBottomLeftRadius, 0);
        this.cornersBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersBottomRightRadius, 0);
        this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeWidth, 0);
        this.strokeDashWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeDashWidth, 0);
        this.strokeDashGap = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeDashGap, 0);
        this.strokeColor = typedArray.getColor(R.styleable.SuperTextView_sShapeStrokeColor, this.defaultShapeColor);
        this.useShape = typedArray.getBoolean(R.styleable.SuperTextView_sUseShape, false);
        typedArray.recycle();
    }

    private RelativeLayout.LayoutParams getParams(RelativeLayout.LayoutParams params) {
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    private void initView() {
        this.initSuperTextView();
        this.initLeftIcon();
        switch (mRightViewType) {
            case 0: {
                this.initRightCheckBox();
                break;
            }
            case 1: {
                this.initRightSwitch();
            }
        }
        this.initRightIcon();
        this.initLeftTextView();
        this.initCenterTextView();
        this.initRightTextView();
        this.initDividerLineView();
    }

    private void initSuperTextView() {
        if (this.useRipple) {
            this.setBackgroundResource(R.drawable.selector_white);
            this.setClickable(true);
        }
        if (this.mBackground_drawable != null) {
            this.setBackgroundDrawable(this.mBackground_drawable);
        }
        if (this.useShape) {
            if (Build.VERSION.SDK_INT < 16) {
                this.setBackgroundDrawable((Drawable)this.getSelector());
            } else {
                this.setBackground((Drawable)this.getSelector());
            }
        }
    }

    private void initLeftIcon() {
        if (this.leftIconIV == null) {
            this.leftIconIV = new ImageView(this.mContext);
        }
        this.leftImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftImgParams.addRule(9, -1);
        this.leftImgParams.addRule(15, -1);
        if (this.leftIconHeight != 0 && this.leftIconWidth != 0) {
            this.leftImgParams.width = this.leftIconWidth;
            this.leftImgParams.height = this.leftIconHeight;
        }
        this.leftIconIV.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.leftIconIV.setId(R.id.sLeftImgId);
        this.leftIconIV.setLayoutParams((ViewGroup.LayoutParams)this.leftImgParams);
        if (this.leftIconRes != null) {
            this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
            this.leftIconIV.setImageDrawable(this.leftIconRes);
        }
        this.addView((View)this.leftIconIV);
    }

    private void initRightIcon() {
        if (this.rightIconIV == null) {
            this.rightIconIV = new ImageView(this.mContext);
        }
        this.rightImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightImgParams.addRule(15, -1);
        switch (mRightViewType) {
            case 0: {
                this.rightImgParams.addRule(0, R.id.sRightCheckBoxId);
                break;
            }
            case 1: {
                this.rightImgParams.addRule(0, R.id.sRightSwitchId);
                break;
            }
            default: {
                this.rightImgParams.addRule(11, -1);
            }
        }
        if (this.rightIconHeight != 0 && this.rightIconWidth != 0) {
            this.rightImgParams.width = this.rightIconWidth;
            this.rightImgParams.height = this.rightIconHeight;
        }
        this.rightIconIV.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.rightIconIV.setId(R.id.sRightImgId);
        this.rightIconIV.setLayoutParams((ViewGroup.LayoutParams)this.rightImgParams);
        if (this.rightIconRes != null) {
            this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
            this.rightIconIV.setImageDrawable(this.rightIconRes);
        }
        this.addView((View)this.rightIconIV);
    }

    private void initLeftTextView() {
        if (this.leftView == null) {
            this.leftView = this.initBaseView(R.id.sLeftViewId);
        }
        this.leftBaseViewParams = this.getParams(this.leftBaseViewParams);
        this.leftBaseViewParams.addRule(1, R.id.sLeftImgId);
        this.leftBaseViewParams.addRule(15, -1);
        if (this.mLeftViewWidth != 0) {
            this.leftBaseViewParams.width = this.dip2px(this.mContext, this.mLeftViewWidth);
        }
        this.leftBaseViewParams.setMargins(this.mLeftViewMarginLeft, 0, this.mLeftViewMarginRight, 0);
        this.leftView.setLayoutParams((ViewGroup.LayoutParams)this.leftBaseViewParams);
        this.leftView.setCenterSpaceHeight(this.centerSpaceHeight);
        this.setDefaultColor(this.leftView, this.mLeftTopTextColor, this.mLeftTextColor, this.mLeftBottomTextColor);
        this.setDefaultSize(this.leftView, this.mLeftTopTextSize, this.mLeftTextSize, this.mLeftBottomTextSize);
        this.setDefaultLines(this.leftView, this.mLeftTopLines, this.mLeftLines, this.mLeftBottomLines);
        this.setDefaultMaxEms(this.leftView, this.mLeftTopMaxEms, this.mLeftMaxEms, this.mLeftBottomMaxEms);
        this.setDefaultTextIsBold(this.leftView, this.mLeftTopTextBold, this.mLeftTextBold, this.mLeftBottomTextBold);
        this.setDefaultGravity(this.leftView, this.mLeftGravity);
        this.setDefaultDrawable(this.leftView.getCenterTextView(), this.mLeftTvDrawableLeft, this.mLeftTvDrawableRight, this.mTextViewDrawablePadding);
        this.setDefaultBackground(this.leftView.getCenterTextView(), this.mLeftTextBackground);
        this.setDefaultString(this.leftView, this.mLeftTopTextString, this.mLeftTextString, this.mLeftBottomTextString);
        this.addView((View)this.leftView);
    }

    private void initCenterTextView() {
        if (this.centerView == null) {
            this.centerView = this.initBaseView(R.id.sCenterViewId);
        }
        this.centerBaseViewParams = this.getParams(this.centerBaseViewParams);
        this.centerBaseViewParams.addRule(13, -1);
        this.centerBaseViewParams.addRule(15, -1);
        if (this.mCenterGravity != 1) {
            this.centerBaseViewParams.addRule(1, R.id.sLeftViewId);
            this.centerBaseViewParams.addRule(0, R.id.sRightViewId);
        }
        this.centerBaseViewParams.setMargins(this.mCenterViewMarginLeft, 0, this.mCenterViewMarginRight, 0);
        this.centerView.setLayoutParams((ViewGroup.LayoutParams)this.centerBaseViewParams);
        this.centerView.setCenterSpaceHeight(this.centerSpaceHeight);
        this.setDefaultColor(this.centerView, this.mCenterTopTextColor, this.mCenterTextColor, this.mCenterBottomTextColor);
        this.setDefaultSize(this.centerView, this.mCenterTopTextSize, this.mCenterTextSize, this.mCenterBottomTextSize);
        this.setDefaultLines(this.centerView, this.mCenterTopLines, this.mCenterLines, this.mCenterBottomLines);
        this.setDefaultMaxEms(this.centerView, this.mCenterTopMaxEms, this.mCenterMaxEms, this.mCenterBottomMaxEms);
        this.setDefaultTextIsBold(this.centerView, this.mCenterTopTextBold, this.mCenterTextBold, this.mCenterBottomTextBold);
        this.setDefaultGravity(this.centerView, this.mCenterGravity);
        this.setDefaultDrawable(this.centerView.getCenterTextView(), this.mCenterTvDrawableLeft, this.mCenterTvDrawableRight, this.mTextViewDrawablePadding);
        this.setDefaultBackground(this.centerView.getCenterTextView(), this.mCenterTextBackground);
        this.setDefaultString(this.centerView, this.mCenterTopTextString, this.mCenterTextString, this.mCenterBottomTextString);
        this.addView((View)this.centerView);
    }

    private void initRightTextView() {
        if (this.rightView == null) {
            this.rightView = this.initBaseView(R.id.sRightViewId);
        }
        this.rightBaseViewParams = this.getParams(this.rightBaseViewParams);
        this.rightBaseViewParams.addRule(15, -1);
        this.rightBaseViewParams.addRule(0, R.id.sRightImgId);
        this.rightBaseViewParams.setMargins(this.mRightViewMarginLeft, 0, this.mRightViewMarginRight, 0);
        this.rightView.setLayoutParams((ViewGroup.LayoutParams)this.rightBaseViewParams);
        this.rightView.setCenterSpaceHeight(this.centerSpaceHeight);
        this.setDefaultColor(this.rightView, this.mRightTopTextColor, this.mRightTextColor, this.mRightBottomTextColor);
        this.setDefaultSize(this.rightView, this.mRightTopTextSize, this.mRightTextSize, this.mRightBottomTextSize);
        this.setDefaultLines(this.rightView, this.mRightTopLines, this.mRightLines, this.mRightBottomLines);
        this.setDefaultMaxEms(this.rightView, this.mRightTopMaxEms, this.mRightMaxEms, this.mRightBottomMaxEms);
        this.setDefaultTextIsBold(this.rightView, this.mRightTopTextBold, this.mRightTextBold, this.mRightBottomTextBold);
        this.setDefaultGravity(this.rightView, this.mRightGravity);
        this.setDefaultRightTvDrawable(this.rightView.getCenterTextView(), this.mRightTvDrawableLeft, this.mRightTvDrawableRight, this.mTextViewDrawablePadding);
        this.setDefaultBackground(this.rightView.getCenterTextView(), this.mRightTextBackground);
        this.setDefaultString(this.rightView, this.mRightTopTextString, this.mRightTextString, this.mRightBottomTextString);
        this.addView((View)this.rightView);
    }

    private void initRightCheckBox() {
        if (this.rightCheckBox == null) {
            this.rightCheckBox = new CheckBox(this.mContext);
        }
        this.rightCheckBoxParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightCheckBoxParams.addRule(11, -1);
        this.rightCheckBoxParams.addRule(15, -1);
        this.rightCheckBoxParams.setMargins(0, 0, this.rightCheckBoxMarginRight, 0);
        this.rightCheckBox.setId(R.id.sRightCheckBoxId);
        this.rightCheckBox.setLayoutParams((ViewGroup.LayoutParams)this.rightCheckBoxParams);
        if (this.rightCheckBoxBg != null) {
            this.rightCheckBox.setGravity(13);
            this.rightCheckBox.setButtonDrawable(this.rightCheckBoxBg);
        }
        this.rightCheckBox.setChecked(this.isChecked);
        this.rightCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (SuperTextView.this.checkBoxCheckedChangeListener != null) {
                    SuperTextView.this.checkBoxCheckedChangeListener.onCheckedChanged(buttonView, isChecked);
                }
            }
        });
        this.addView((View)this.rightCheckBox);
    }

    private void initRightSwitch() {
        if (this.mSwitch == null) {
            this.mSwitch = new Switch(this.mContext);
        }
        this.mSwitchParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mSwitchParams.addRule(11, -1);
        this.mSwitchParams.addRule(15, -1);
        this.mSwitchParams.setMargins(0, 0, this.rightSwitchMarginRight, 0);
        this.mSwitch.setId(R.id.sRightSwitchId);
        this.mSwitch.setLayoutParams((ViewGroup.LayoutParams)this.mSwitchParams);
        this.mSwitch.setChecked(this.switchIsChecked);
        if (!TextUtils.isEmpty((CharSequence)this.mTextOff)) {
            this.mSwitch.setTextOff((CharSequence)this.mTextOff);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTextOn)) {
            this.mSwitch.setTextOn((CharSequence)this.mTextOn);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (this.mSwitchMinWidth != 0) {
                this.mSwitch.setSwitchMinWidth(this.mSwitchMinWidth);
            }
            if (this.mSwitchPadding != 0) {
                this.mSwitch.setSwitchPadding(this.mSwitchPadding);
            }
            if (this.mThumbResource != null) {
                this.mSwitch.setThumbDrawable(this.mThumbResource);
            }
            if (this.mThumbResource != null) {
                this.mSwitch.setTrackDrawable(this.mTrackResource);
            }
            if (this.mThumbTextPadding != 0) {
                this.mSwitch.setThumbTextPadding(this.mThumbTextPadding);
            }
        }
        this.mSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (SuperTextView.this.switchCheckedChangeListener != null) {
                    SuperTextView.this.switchCheckedChangeListener.onCheckedChanged(buttonView, isChecked);
                }
            }
        });
        this.addView((View)this.mSwitch);
    }

    private BaseTextView initBaseView(int id2) {
        BaseTextView baseTextView = new BaseTextView(this.mContext);
        baseTextView.setId(id2);
        return baseTextView;
    }

    private void setDefaultString(BaseTextView baseTextView, String topTextString, String leftTextString, String bottomTextString) {
        if (baseTextView != null) {
            baseTextView.setTopTextString(topTextString);
            baseTextView.setCenterTextString(leftTextString);
            baseTextView.setBottomTextString(bottomTextString);
        }
    }

    private void setDefaultColor(BaseTextView baseTextView, int topTextColor, int textColor, int bottomTextColor) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setTextColor(topTextColor);
            baseTextView.getCenterTextView().setTextColor(textColor);
            baseTextView.getBottomTextView().setTextColor(bottomTextColor);
        }
    }

    private void setDefaultSize(BaseTextView baseTextView, int topTextSize, int leftTextSize, int bottomTextSize) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setTextSize(0, (float)topTextSize);
            baseTextView.getCenterTextView().setTextSize(0, (float)leftTextSize);
            baseTextView.getBottomTextView().setTextSize(0, (float)bottomTextSize);
        }
    }

    private void setDefaultMaxEms(BaseTextView baseTextView, int topMaxEms, int centerMaxEms, int bottomMaxEms) {
        if (baseTextView != null) {
            baseTextView.setMaxEms(topMaxEms, centerMaxEms, bottomMaxEms);
        }
    }

    private void setDefaultLines(BaseTextView baseTextView, int leftTopLines, int leftLines, int bottomLines) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setLines(leftTopLines);
            baseTextView.getCenterTextView().setLines(leftLines);
            baseTextView.getBottomTextView().setLines(bottomLines);
        }
    }

    private void setDefaultGravity(BaseTextView baseTextView, int gravity) {
        if (baseTextView != null) {
            this.setGravity(baseTextView, gravity);
        }
    }

    private void setGravity(BaseTextView baseTextView, int gravity) {
        switch (gravity) {
            case 0: {
                baseTextView.setGravity(19);
                break;
            }
            case 1: {
                baseTextView.setGravity(17);
                break;
            }
            case 2: {
                baseTextView.setGravity(21);
            }
        }
    }

    public void setDefaultDrawable(TextView textView, Drawable drawableLeft, Drawable drawableRight, int drawablePadding) {
        if (drawableLeft != null || drawableRight != null) {
            textView.setVisibility(0);
        }
        textView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, null, drawableRight, null);
        textView.setCompoundDrawablePadding(drawablePadding);
    }

    public void setDefaultRightTvDrawable(TextView textView, Drawable drawableLeft, Drawable drawableRight, int drawablePadding) {
        if (drawableLeft != null || drawableRight != null) {
            textView.setVisibility(0);
        }
        if (drawableRight != null && this.mRightTvDrawableRightWidth != -1 && this.mRightTvDrawableRightHeight != -1) {
            drawableRight.setBounds(0, 0, this.mRightTvDrawableRightWidth, this.mRightTvDrawableRightHeight);
            textView.setCompoundDrawables(drawableLeft, null, drawableRight, null);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, null, drawableRight, null);
        }
        textView.setCompoundDrawablePadding(drawablePadding);
    }

    private void setDefaultBackground(TextView textView, Drawable background) {
        if (background != null) {
            textView.setVisibility(0);
            if (Build.VERSION.SDK_INT < 16) {
                textView.setBackgroundDrawable(background);
            } else {
                textView.setBackground(background);
            }
        }
    }

    private void initDividerLineView() {
        if (!this.useShape) {
            switch (this.mDividerLineType) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setTopDividerLineView();
                    break;
                }
                case 2: {
                    this.setTBottomDividerLineView();
                    break;
                }
                case 3: {
                    this.setTopDividerLineView();
                    this.setTBottomDividerLineView();
                }
            }
        }
    }

    private void setTopDividerLineView() {
        if (this.mTopDividerLineMarginLR != 0) {
            this.initTopDividerLineView(this.mTopDividerLineMarginLR, this.mTopDividerLineMarginLR);
        } else {
            this.initTopDividerLineView(this.mTopDividerLineMarginLeft, this.mTopDividerLineMarginRight);
        }
    }

    private void setTBottomDividerLineView() {
        if (this.mBottomDividerLineMarginLR != 0) {
            this.initBottomDividerLineView(this.mBottomDividerLineMarginLR, this.mBottomDividerLineMarginLR);
        } else {
            this.initBottomDividerLineView(this.mBottomDividerLineMarginLeft, this.mBottomDividerLineMarginRight);
        }
    }

    private void initTopDividerLineView(int marginLeft, int marginRight) {
        if (this.topDividerLineView == null) {
            if (this.topDividerLineParams == null) {
                this.topDividerLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.topDividerLineParams.addRule(10, -1);
            this.topDividerLineParams.setMargins(marginLeft, 0, marginRight, 0);
            this.topDividerLineView = new View(this.mContext);
            this.topDividerLineView.setLayoutParams((ViewGroup.LayoutParams)this.topDividerLineParams);
            this.topDividerLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.topDividerLineView);
    }

    private void initBottomDividerLineView(int marginLeft, int marginRight) {
        if (this.bottomDividerLineView == null) {
            if (this.bottomDividerLineParams == null) {
                this.bottomDividerLineParams = new RelativeLayout.LayoutParams(-1, this.mDividerLineHeight);
            }
            this.bottomDividerLineParams.addRule(12, -1);
            this.bottomDividerLineParams.setMargins(marginLeft, 0, marginRight, 0);
            this.bottomDividerLineView = new View(this.mContext);
            this.bottomDividerLineView.setLayoutParams((ViewGroup.LayoutParams)this.bottomDividerLineParams);
            this.bottomDividerLineView.setBackgroundColor(this.mDividerLineColor);
        }
        this.addView(this.bottomDividerLineView);
    }

    private void setDefaultLeftViewClickListener(BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.leftTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.leftTopTvClickListener.onClickListener();
                    }
                });
            }
            if (this.leftTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.leftTvClickListener.onClickListener();
                    }
                });
            }
            if (this.leftBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.leftBottomTvClickListener.onClickListener();
                    }
                });
            }
        }
    }

    private void setDefaultCenterViewClickListener(BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.centerTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.centerTopTvClickListener.onClickListener();
                    }
                });
            }
            if (this.centerTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.centerTvClickListener.onClickListener();
                    }
                });
            }
            if (this.centerBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.centerBottomTvClickListener.onClickListener();
                    }
                });
            }
        }
    }

    private void setDefaultRightViewClickListener(BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.rightTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.rightTopTvClickListener.onClickListener();
                    }
                });
            }
            if (this.rightTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.rightTvClickListener.onClickListener();
                    }
                });
            }
            if (this.rightBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.rightBottomTvClickListener.onClickListener();
                    }
                });
            }
        }
    }

    private void setDefaultTextIsBold(BaseTextView baseTextView, boolean topTextBold, boolean centerTextBold, boolean bottomTextBold) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().getPaint().setFakeBoldText(topTextBold);
            baseTextView.getCenterTextView().getPaint().setFakeBoldText(centerTextBold);
            baseTextView.getBottomTextView().getPaint().setFakeBoldText(bottomTextBold);
        }
    }

    public SuperTextView setLeftTopString(CharSequence string) {
        if (this.leftView != null) {
            this.leftView.setTopTextString(string);
        }
        return this;
    }

    public SuperTextView setLeftString(CharSequence string) {
        if (this.leftView != null) {
            this.leftView.setCenterTextString(string);
        }
        return this;
    }

    public SuperTextView setLeftBottomString(CharSequence string) {
        if (this.leftView != null) {
            this.leftView.setBottomTextString(string);
        }
        return this;
    }

    public SuperTextView setCenterTopString(CharSequence string) {
        if (this.centerView != null) {
            this.centerView.setTopTextString(string);
        }
        return this;
    }

    public SuperTextView setCenterString(CharSequence string) {
        if (this.centerView != null) {
            this.centerView.setCenterTextString(string);
        }
        return this;
    }

    public SuperTextView setCenterBottomString(CharSequence string) {
        if (this.centerView != null) {
            this.centerView.setBottomTextString(string);
        }
        return this;
    }

    public SuperTextView setRightTopString(CharSequence string) {
        if (this.rightView != null) {
            this.rightView.setTopTextString(string);
        }
        return this;
    }

    public SuperTextView setRightString(CharSequence string) {
        if (this.rightView != null) {
            this.rightView.setCenterTextString(string);
        }
        return this;
    }

    public SuperTextView setRightBottomString(CharSequence string) {
        if (this.rightView != null) {
            this.rightView.setBottomTextString(string);
        }
        return this;
    }

    public SuperTextView setLeftTopTextColor(int color) {
        if (this.leftView != null) {
            this.leftView.getTopTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setLeftTextColor(int color) {
        if (this.leftView != null) {
            this.leftView.getCenterTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setLeftBottomTextColor(int color) {
        if (this.leftView != null) {
            this.leftView.getBottomTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setCenterTopTextColor(int color) {
        if (this.centerView != null) {
            this.centerView.getTopTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setCenterTextColor(int color) {
        if (this.centerView != null) {
            this.centerView.getCenterTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setCenterBottomTextColor(int color) {
        if (this.centerView != null) {
            this.centerView.getBottomTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setRightTopTextColor(int color) {
        if (this.rightView != null) {
            this.rightView.getTopTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setRightTextColor(int color) {
        if (this.rightView != null) {
            this.rightView.getCenterTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setRightBottomTextColor(int color) {
        if (this.rightView != null) {
            this.rightView.getBottomTextView().setTextColor(color);
        }
        return this;
    }

    public String getLeftTopString() {
        return this.leftView != null ? this.leftView.getTopTextView().getText().toString().trim() : "";
    }

    public String getLeftString() {
        return this.leftView != null ? this.leftView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getLeftBottomString() {
        return this.leftView != null ? this.leftView.getBottomTextView().getText().toString().trim() : "";
    }

    public String getCenterTopString() {
        return this.centerView != null ? this.centerView.getTopTextView().getText().toString().trim() : "";
    }

    public String getCenterString() {
        return this.centerView != null ? this.centerView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getCenterBottomString() {
        return this.centerView != null ? this.centerView.getBottomTextView().getText().toString().trim() : "";
    }

    public String getRightTopString() {
        return this.rightView != null ? this.rightView.getTopTextView().getText().toString().trim() : "";
    }

    public String getRightString() {
        return this.rightView != null ? this.rightView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getRightBottomString() {
        return this.rightView != null ? this.rightView.getBottomTextView().getText().toString().trim() : "";
    }

    public ImageView getLeftIconIV() {
        this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
        return this.leftIconIV;
    }

    public ImageView getRightIconIV() {
        this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
        return this.rightIconIV;
    }

    public SuperTextView setCbChecked(boolean checked) {
        this.isChecked = checked;
        if (this.rightCheckBox != null) {
            this.rightCheckBox.setChecked(checked);
        }
        return this;
    }

    public SuperTextView setCbBackground(Drawable drawable2) {
        this.rightCheckBoxBg = drawable2;
        if (this.rightCheckBox != null) {
            this.rightCheckBox.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public boolean getCbisChecked() {
        boolean isChecked = false;
        if (this.rightCheckBox != null) {
            isChecked = this.rightCheckBox.isChecked();
        }
        return isChecked;
    }

    public SuperTextView setSwitchIsChecked(boolean checked) {
        this.switchIsChecked = checked;
        if (this.mSwitch != null) {
            this.mSwitch.setChecked(checked);
        }
        return this;
    }

    public boolean getSwitchIsChecked() {
        boolean isChecked = false;
        if (this.mSwitch != null) {
            isChecked = this.mSwitch.isChecked();
        }
        return isChecked;
    }

    public SuperTextView setLeftTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.leftView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding);
        return this;
    }

    public SuperTextView setLeftTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.leftView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding);
        return this;
    }

    public SuperTextView setCenterTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.centerView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding);
        return this;
    }

    public SuperTextView setCenterTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.centerView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding);
        return this;
    }

    public SuperTextView setRightTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.rightView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding);
        return this;
    }

    public SuperTextView setRightTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.rightView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding);
        this.setDefaultRightTvDrawable(this.rightView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding);
        return this;
    }

    public SuperTextView setLeftIcon(Drawable leftIcon) {
        if (this.leftIconIV != null) {
            this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
            this.leftIconIV.setImageDrawable(leftIcon);
        }
        return this;
    }

    public SuperTextView setLeftIcon(int resId) {
        if (this.leftIconIV != null) {
            this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
            this.leftIconIV.setImageResource(resId);
        }
        return this;
    }

    public SuperTextView setRightIcon(Drawable rightIcon) {
        if (this.rightIconIV != null) {
            this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
            this.rightIconIV.setImageDrawable(rightIcon);
        }
        return this;
    }

    public SuperTextView setRightIcon(int resId) {
        if (this.rightIconIV != null) {
            this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
            this.rightIconIV.setImageResource(resId);
        }
        return this;
    }

    public SuperTextView setSBackground(Drawable drawable2) {
        if (drawable2 != null) {
            this.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public SuperTextView setOnSuperTextViewClickListener(OnSuperTextViewClickListener onSuperTextViewClickListener) {
        this.superTextViewClickListener = onSuperTextViewClickListener;
        if (this.superTextViewClickListener != null) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.superTextViewClickListener.onClickListener(SuperTextView.this);
                }
            });
        }
        return this;
    }

    public SuperTextView setLeftTopTvClickListener(OnLeftTopTvClickListener leftTopTvClickListener) {
        this.leftTopTvClickListener = leftTopTvClickListener;
        this.setDefaultLeftViewClickListener(this.leftView);
        return this;
    }

    public SuperTextView setLeftTvClickListener(OnLeftTvClickListener leftTvClickListener) {
        this.leftTvClickListener = leftTvClickListener;
        this.setDefaultLeftViewClickListener(this.leftView);
        return this;
    }

    public SuperTextView setLeftBottomTvClickListener(OnLeftBottomTvClickListener leftBottomTvClickListener) {
        this.leftBottomTvClickListener = leftBottomTvClickListener;
        this.setDefaultLeftViewClickListener(this.leftView);
        return this;
    }

    public SuperTextView setCenterTopTvClickListener(OnCenterTopTvClickListener centerTopTvClickListener) {
        this.centerTopTvClickListener = centerTopTvClickListener;
        this.setDefaultCenterViewClickListener(this.centerView);
        return this;
    }

    public SuperTextView setCenterTvClickListener(OnCenterTvClickListener centerTvClickListener) {
        this.centerTvClickListener = centerTvClickListener;
        this.setDefaultCenterViewClickListener(this.centerView);
        return this;
    }

    public SuperTextView setCenterBottomTvClickListener(OnCenterBottomTvClickListener centerBottomTvClickListener) {
        this.centerBottomTvClickListener = centerBottomTvClickListener;
        this.setDefaultCenterViewClickListener(this.centerView);
        return this;
    }

    public SuperTextView setRightTopTvClickListener(OnRightTopTvClickListener rightTopTvClickListener) {
        this.rightTopTvClickListener = rightTopTvClickListener;
        this.setDefaultRightViewClickListener(this.rightView);
        return this;
    }

    public SuperTextView setRightTvClickListener(OnRightTvClickListener rightTvClickListener) {
        this.rightTvClickListener = rightTvClickListener;
        this.setDefaultRightViewClickListener(this.rightView);
        return this;
    }

    public SuperTextView setRightBottomTvClickListener(OnRightBottomTvClickListener rightBottomTvClickListener) {
        this.rightBottomTvClickListener = rightBottomTvClickListener;
        this.setDefaultRightViewClickListener(this.rightView);
        return this;
    }

    public SuperTextView setLeftImageViewClickListener(OnLeftImageViewClickListener listener) {
        this.leftImageViewClickListener = listener;
        if (this.leftIconIV != null) {
            this.leftIconIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.leftImageViewClickListener.onClickListener(SuperTextView.this.leftIconIV);
                }
            });
        }
        return this;
    }

    public SuperTextView setRightImageViewClickListener(OnRightImageViewClickListener listener) {
        this.rightImageViewClickListener = listener;
        if (this.rightIconIV != null) {
            this.rightIconIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.rightImageViewClickListener.onClickListener(SuperTextView.this.rightIconIV);
                }
            });
        }
        return this;
    }

    public SuperTextView setSwitchCheckedChangeListener(OnSwitchCheckedChangeListener switchCheckedChangeListener) {
        this.switchCheckedChangeListener = switchCheckedChangeListener;
        return this;
    }

    public SuperTextView setCheckBoxCheckedChangeListener(OnCheckBoxCheckedChangeListener checkBoxCheckedChangeListener) {
        this.checkBoxCheckedChangeListener = checkBoxCheckedChangeListener;
        return this;
    }

    public StateListDrawable getSelector() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919, 16842910}, (Drawable)this.getDrawable(16842919));
        stateListDrawable.addState(new int[0], (Drawable)this.getDrawable(16842910));
        return stateListDrawable;
    }

    public GradientDrawable getDrawable(int state) {
        this.gradientDrawable = new GradientDrawable();
        this.gradientDrawable.setShape(0);
        switch (state) {
            case 16842919: {
                this.gradientDrawable.setColor(this.selectorPressedColor);
                break;
            }
            case 16842910: {
                this.gradientDrawable.setColor(this.selectorNormalColor);
                break;
            }
            default: {
                this.gradientDrawable.setColor(this.solidColor);
            }
        }
        this.setBorder();
        this.setRadius();
        return this.gradientDrawable;
    }

    private void setBorder() {
        this.gradientDrawable.setStroke(this.strokeWidth, this.strokeColor, this.strokeDashWidth, this.strokeDashGap);
    }

    private void setRadius() {
        if (this.cornersRadius != 0.0f) {
            this.gradientDrawable.setCornerRadius(this.cornersRadius);
        } else {
            this.gradientDrawable.setCornerRadii(new float[]{this.cornersTopLeftRadius, this.cornersTopLeftRadius, this.cornersTopRightRadius, this.cornersTopRightRadius, this.cornersBottomRightRadius, this.cornersBottomRightRadius, this.cornersBottomLeftRadius, this.cornersBottomLeftRadius});
        }
    }

    public SuperTextView setShapeSelectorPressedColor(int color) {
        this.selectorPressedColor = color;
        return this;
    }

    public SuperTextView setShapeSelectorNormalColor(int color) {
        this.selectorNormalColor = color;
        return this;
    }

    public SuperTextView setShapeSolidColor(int color) {
        this.solidColor = color;
        return this;
    }

    public SuperTextView setShapeStrokeWidth(int strokeWidth) {
        this.strokeWidth = this.dip2px(this.mContext, strokeWidth);
        return this;
    }

    public SuperTextView setShapeStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    public SuperTextView setShapeSrokeDashWidth(float strokeDashWidth) {
        this.strokeDashWidth = this.dip2px(this.mContext, strokeDashWidth);
        return this;
    }

    public SuperTextView setShapeStrokeDashGap(float strokeDashGap) {
        this.strokeDashGap = this.dip2px(this.mContext, strokeDashGap);
        return this;
    }

    public SuperTextView setShapeCornersRadius(float radius) {
        this.cornersRadius = this.dip2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersTopLeftRadius(float radius) {
        this.cornersTopLeftRadius = this.dip2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersTopRightRadius(float radius) {
        this.cornersTopRightRadius = this.dip2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersBottomLeftRadius(float radius) {
        this.cornersBottomLeftRadius = this.dip2px(this.mContext, radius);
        return this;
    }

    public SuperTextView setShapeCornersBottomRightRadius(float radius) {
        this.cornersBottomRightRadius = this.dip2px(this.mContext, radius);
        return this;
    }

    public SuperTextView useShape() {
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)this.getSelector());
        } else {
            this.setBackground((Drawable)this.getSelector());
        }
        return this;
    }

    private int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * scale + 0.5f);
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static interface OnCheckBoxCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }

    public static interface OnSwitchCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }

    public static interface OnRightImageViewClickListener {
        public void onClickListener(ImageView var1);
    }

    public static interface OnLeftImageViewClickListener {
        public void onClickListener(ImageView var1);
    }

    public static interface OnRightBottomTvClickListener {
        public void onClickListener();
    }

    public static interface OnRightTvClickListener {
        public void onClickListener();
    }

    public static interface OnRightTopTvClickListener {
        public void onClickListener();
    }

    public static interface OnCenterBottomTvClickListener {
        public void onClickListener();
    }

    public static interface OnCenterTvClickListener {
        public void onClickListener();
    }

    public static interface OnCenterTopTvClickListener {
        public void onClickListener();
    }

    public static interface OnLeftBottomTvClickListener {
        public void onClickListener();
    }

    public static interface OnLeftTvClickListener {
        public void onClickListener();
    }

    public static interface OnLeftTopTvClickListener {
        public void onClickListener();
    }

    public static interface OnSuperTextViewClickListener {
        public void onClickListener(SuperTextView var1);
    }
}

