/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

public class BaseTextView
extends LinearLayout {
    private Context mContext;
    private TextView topTextView;
    private TextView centerTextView;
    private TextView bottomTextView;
    private LinearLayout.LayoutParams topTVParams;
    private LinearLayout.LayoutParams centerTVParams;
    private LinearLayout.LayoutParams bottomTVParams;

    public BaseTextView(Context context) {
        this(context, null);
    }

    public BaseTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.initTopView();
        this.initCenterView();
        this.initBottomView();
    }

    private void initTopView() {
        if (this.topTVParams == null) {
            this.topTVParams = this.getParams(this.topTVParams);
        }
        if (this.topTextView == null) {
            this.topTextView = this.initTextView(this.topTVParams, this.topTextView);
        }
    }

    private void initCenterView() {
        if (this.centerTVParams == null) {
            this.centerTVParams = this.getParams(this.centerTVParams);
        }
        if (this.centerTextView == null) {
            this.centerTextView = this.initTextView(this.centerTVParams, this.centerTextView);
        }
    }

    private void initBottomView() {
        if (this.bottomTVParams == null) {
            this.bottomTVParams = this.getParams(this.bottomTVParams);
        }
        if (this.bottomTextView == null) {
            this.bottomTextView = this.initTextView(this.bottomTVParams, this.bottomTextView);
        }
    }

    private TextView initTextView(LinearLayout.LayoutParams params, TextView textView) {
        textView = this.getTextView(textView, params);
        textView.setGravity(17);
        this.addView((View)textView);
        return textView;
    }

    public TextView getTextView(TextView textView, LinearLayout.LayoutParams layoutParams) {
        if (textView == null) {
            textView = new TextView(this.mContext);
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setVisibility(8);
        }
        return textView;
    }

    public LinearLayout.LayoutParams getParams(LinearLayout.LayoutParams params) {
        if (params == null) {
            params = new LinearLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    private void setTextString(TextView textView, String textString) {
        textView.setText((CharSequence)textString);
        if (!TextUtils.isEmpty((CharSequence)textString)) {
            textView.setVisibility(0);
        }
    }

    public void setTopTextString(String s) {
        this.setTextString(this.topTextView, s);
    }

    public void setCenterTextString(String s) {
        this.setTextString(this.centerTextView, s);
    }

    public void setBottomTextString(String s) {
        this.setTextString(this.bottomTextView, s);
    }

    public TextView getTopTextView() {
        return this.topTextView;
    }

    public TextView getCenterTextView() {
        return this.centerTextView;
    }

    public TextView getBottomTextView() {
        return this.bottomTextView;
    }

    public void setMaxEms(int topMaxEms, int centerMaxEms, int bottomMaxEms) {
        this.topTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.centerTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.bottomTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.topTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(topMaxEms)});
        this.centerTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(centerMaxEms)});
        this.bottomTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(bottomMaxEms)});
    }

    public void setCenterSpaceHeight(int centerSpaceHeight) {
        this.topTVParams.setMargins(0, 0, 0, centerSpaceHeight / 2);
        this.centerTVParams.setMargins(0, centerSpaceHeight / 2, 0, centerSpaceHeight / 2);
        this.bottomTVParams.setMargins(0, centerSpaceHeight / 2, 0, 0);
    }
}

