/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.Button;
import com.allen.library.R;

public class SuperButton
extends Button {
    private Context mContext;
    private int defaultColor = 0x20000000;
    private int defaultSelectorColor = 0x20000000;
    private int solidColor;
    private int selectorPressedColor;
    private int selectorDisableColor;
    private int selectorNormalColor;
    private float cornersRadius;
    private float cornersTopLeftRadius;
    private float cornersTopRightRadius;
    private float cornersBottomLeftRadius;
    private float cornersBottomRightRadius;
    private float strokeWidth;
    private int strokeColor;
    private float strokeDashWidth;
    private float strokeDashGap;
    private int sizeWidth;
    private int sizeHeight;
    private int gradientOrientation;
    private int gradientAngle;
    private int gradientCenterX;
    private int gradientCenterY;
    private int gradientGradientRadius;
    private int gradientStartColor;
    private int gradientCenterColor;
    private int gradientEndColor;
    private int gradientType;
    private static final int linear = 0;
    private static final int radial = 1;
    private static final int sweep = 2;
    private boolean gradientUseLevel;
    private boolean useSelector;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    public static final int TOP_BOTTOM = 0;
    public static final int TR_BL = 1;
    public static final int RIGHT_LEFT = 2;
    public static final int BR_TL = 3;
    public static final int BOTTOM_TOP = 4;
    public static final int BL_TR = 5;
    public static final int LEFT_RIGHT = 6;
    public static final int TL_BR = 7;
    private int shapeType;
    private int gravity;
    private GradientDrawable gradientDrawable;

    public SuperButton(Context context) {
        this(context, null);
    }

    public SuperButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getAttr(attrs);
        this.init();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.SuperButton);
        this.gravity = typedArray.getInt(R.styleable.SuperButton_sGravity, 0);
        this.shapeType = typedArray.getInt(R.styleable.SuperButton_sShapeType, 0);
        this.solidColor = typedArray.getColor(R.styleable.SuperButton_sSolidColor, this.defaultColor);
        this.selectorPressedColor = typedArray.getColor(R.styleable.SuperButton_sSelectorPressedColor, this.defaultSelectorColor);
        this.selectorDisableColor = typedArray.getColor(R.styleable.SuperButton_sSelectorDisableColor, this.defaultSelectorColor);
        this.selectorNormalColor = typedArray.getColor(R.styleable.SuperButton_sSelectorNormalColor, this.defaultSelectorColor);
        this.cornersRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersRadius, 0);
        this.cornersTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersTopLeftRadius, 0);
        this.cornersTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersTopRightRadius, 0);
        this.cornersBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersBottomLeftRadius, 0);
        this.cornersBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sCornersBottomRightRadius, 0);
        this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sStrokeWidth, 0);
        this.strokeDashWidth = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sStrokeDashWidth, 0);
        this.strokeDashGap = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sStrokeDashGap, 0);
        this.strokeColor = typedArray.getColor(R.styleable.SuperButton_sStrokeColor, this.defaultColor);
        this.sizeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sSizeWidth, 0);
        this.sizeHeight = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sSizeHeight, this.dip2px(this.mContext, 48.0f));
        this.gradientOrientation = typedArray.getInt(R.styleable.SuperButton_sGradientOrientation, -1);
        this.gradientAngle = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientAngle, 0);
        this.gradientCenterX = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientCenterX, 0);
        this.gradientCenterY = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientCenterY, 0);
        this.gradientGradientRadius = typedArray.getDimensionPixelSize(R.styleable.SuperButton_sGradientGradientRadius, 0);
        this.gradientStartColor = typedArray.getColor(R.styleable.SuperButton_sGradientStartColor, -1);
        this.gradientCenterColor = typedArray.getColor(R.styleable.SuperButton_sGradientCenterColor, -1);
        this.gradientEndColor = typedArray.getColor(R.styleable.SuperButton_sGradientEndColor, -1);
        this.gradientType = typedArray.getInt(R.styleable.SuperButton_sGradientType, 0);
        this.gradientUseLevel = typedArray.getBoolean(R.styleable.SuperButton_sGradientUseLevel, false);
        this.useSelector = typedArray.getBoolean(R.styleable.SuperButton_sUseSelector, false);
        typedArray.recycle();
    }

    void init() {
        this.setClickable(true);
        if (Build.VERSION.SDK_INT < 16) {
            this.setBackgroundDrawable((Drawable)(this.useSelector ? this.getSelector() : this.getDrawable(0)));
        } else {
            this.setBackground((Drawable)(this.useSelector ? this.getSelector() : this.getDrawable(0)));
        }
        this.setSGravity();
    }

    public StateListDrawable getSelector() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919, 16842910}, (Drawable)this.getDrawable(16842919));
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)this.getDrawable(-16842910));
        stateListDrawable.addState(new int[0], (Drawable)this.getDrawable(16842910));
        return stateListDrawable;
    }

    public GradientDrawable getDrawable(int state) {
        this.gradientDrawable = new GradientDrawable();
        this.setShape();
        this.setOrientation();
        this.setSize();
        this.setBorder();
        this.setRadius();
        this.setSelectorColor(state);
        return this.gradientDrawable;
    }

    private void setSGravity() {
        switch (this.gravity) {
            case 0: {
                this.setGravity(17);
                break;
            }
            case 1: {
                this.setGravity(19);
                break;
            }
            case 2: {
                this.setGravity(21);
                break;
            }
            case 3: {
                this.setGravity(49);
                break;
            }
            case 4: {
                this.setGravity(81);
            }
        }
    }

    private void setSelectorColor(int state) {
        if (this.gradientOrientation == -1) {
            switch (state) {
                case 16842919: {
                    this.gradientDrawable.setColor(this.selectorPressedColor);
                    break;
                }
                case -16842910: {
                    this.gradientDrawable.setColor(this.selectorDisableColor);
                    break;
                }
                case 16842910: {
                    this.gradientDrawable.setColor(this.selectorNormalColor);
                }
            }
        }
    }

    private void setOrientation() {
        if (this.gradientOrientation != -1) {
            if (Build.VERSION.SDK_INT >= 16) {
                this.gradientDrawable.setOrientation(this.getOrientation(this.gradientOrientation));
                if (this.gradientCenterColor == -1) {
                    this.gradientDrawable.setColors(new int[]{this.gradientStartColor, this.gradientEndColor});
                } else {
                    this.gradientDrawable.setColors(new int[]{this.gradientStartColor, this.gradientCenterColor, this.gradientEndColor});
                }
                switch (this.gradientType) {
                    case 0: {
                        this.gradientDrawable.setGradientType(0);
                        break;
                    }
                    case 1: {
                        this.gradientDrawable.setGradientType(1);
                        this.gradientDrawable.setGradientRadius((float)this.gradientGradientRadius);
                        break;
                    }
                    case 2: {
                        this.gradientDrawable.setGradientType(2);
                    }
                }
                this.gradientDrawable.setUseLevel(this.gradientUseLevel);
                if (this.gradientCenterX != 0 && this.gradientCenterY != 0) {
                    this.gradientDrawable.setGradientCenter((float)this.gradientCenterX, (float)this.gradientCenterY);
                }
            }
        } else {
            this.gradientDrawable.setColor(this.solidColor);
        }
    }

    private GradientDrawable.Orientation getOrientation(int gradientOrientation) {
        GradientDrawable.Orientation orientation = null;
        switch (gradientOrientation) {
            case 0: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 1: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 2: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 3: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 4: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 5: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 6: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 7: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    private void setShape() {
        switch (this.shapeType) {
            case 0: {
                this.gradientDrawable.setShape(0);
                break;
            }
            case 1: {
                this.gradientDrawable.setShape(1);
                break;
            }
            case 2: {
                this.gradientDrawable.setShape(2);
                break;
            }
            case 3: {
                this.gradientDrawable.setShape(3);
            }
        }
    }

    private void setSize() {
        if (this.shapeType == 0) {
            this.gradientDrawable.setSize(this.sizeWidth, this.sizeHeight);
        }
    }

    private void setBorder() {
        this.gradientDrawable.setStroke(this.dip2px(this.mContext, this.strokeWidth), this.strokeColor, this.strokeDashWidth, this.strokeDashGap);
    }

    private void setRadius() {
        if (this.shapeType == 0) {
            if (this.cornersRadius != 0.0f) {
                this.gradientDrawable.setCornerRadius((float)this.dip2px(this.mContext, this.cornersRadius));
            } else {
                this.gradientDrawable.setCornerRadii(new float[]{this.cornersTopLeftRadius, this.cornersTopLeftRadius, this.cornersTopRightRadius, this.cornersTopRightRadius, this.cornersBottomRightRadius, this.cornersBottomRightRadius, this.cornersBottomLeftRadius, this.cornersBottomLeftRadius});
            }
        }
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

