/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.allen.library.R;

public class SuperTextView
extends RelativeLayout {
    private Context mContext;
    private int defaultBgColor = -1;
    private int defaultLineColor = -1513240;
    private int defaultLinePadding = 0;
    private ImageView leftIconIV;
    private ImageView rightIconIV;
    private CheckBox rightCheckBox;
    private Drawable rightCheckBoxBg;
    private TextView leftTV;
    private TextView centerTV;
    private TextView rightTV;
    private TextView leftTopTV;
    private TextView leftBottomTV;
    private TextView leftBottomTV2;
    private Drawable leftIconRes;
    private Drawable rightIconRes;
    private String leftTextString;
    private String centerTextString;
    private String rightTextString;
    private String leftTopTextString;
    private String leftBottomTextString;
    private String leftBottomTextString2;
    private int defaultPadding = 0;
    private int centerSpaceHeight;
    private int bothLineWidth;
    private int topLineWidth;
    private int bottomLineWidth;
    private int lineColor = -1513240;
    private int topLineMargin;
    private int bottomLineMargin;
    private int bothLineMargin;
    private int leftIconMarginLeft;
    private int leftTVMarginLeft;
    private int leftIconWidth;
    private int leftIconHeight;
    private int rightIconWidth;
    private int rightIconHeight;
    private int leftTopMarginLeft;
    private int leftBottomMarginLeft;
    private int leftBottomMarginLeft2;
    private int rightTVMarginRight;
    private int rightIconMarginRight;
    private int rightCheckBoxMarginRight;
    private boolean showCheckBox;
    private boolean isChecked;
    private int defaultSize = 0;
    private int leftTVSize;
    private int leftTopTVSize;
    private int leftBottomTVSize;
    private int leftBottomTVSize2;
    private int rightTVSize;
    private int centerTVSize;
    private int defaultColor = -13158601;
    private int backgroundColor;
    private int leftTVColor;
    private int leftTopTVColor;
    private int leftBottomTVColor;
    private int leftBottomTVColor2;
    private int rightTVColor;
    private int centerTVColor;
    private boolean isSingLines = true;
    private int maxLines = 1;
    private int maxEms = 10;
    private static final int NONE = 0;
    private static final int TOP = 1;
    private static final int BOTTOM = 2;
    private static final int BOTH = 3;
    private static final int DEFAULT = 2;
    public static final int leftTextViewId = 0;
    public static final int leftTopTextViewId = 1;
    public static final int leftBottomTextViewId = 2;
    public static final int leftBottomTextViewId2 = 3;
    public static final int rightTextViewId = 4;
    public static final int centerTextViewId = 5;
    public static final int leftImageViewId = 6;
    public static final int rightImageViewId = 7;
    private boolean useRipple;
    private int lineType;
    private RelativeLayout.LayoutParams centerBaseLineParams;
    private RelativeLayout.LayoutParams topLineParams;
    private RelativeLayout.LayoutParams bottomLineParams;
    private RelativeLayout.LayoutParams leftImgParams;
    private RelativeLayout.LayoutParams leftTextParams;
    private RelativeLayout.LayoutParams centerTextParams;
    private RelativeLayout.LayoutParams leftTopTextParams;
    private RelativeLayout.LayoutParams leftBottomParams;
    private RelativeLayout.LayoutParams leftBottomParams2;
    private RelativeLayout.LayoutParams rightTextParams;
    private RelativeLayout.LayoutParams rightImgParams;
    private RelativeLayout.LayoutParams rightCheckBoxParams;
    private OnSuperTextViewClickListener onSuperTextViewClickListener;
    private Drawable rightTextStringRightIconRes;
    private int rightTextStringRightIconPadding;

    public SuperTextView(Context context) {
        super(context);
    }

    public SuperTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.defaultPadding = this.dip2px(context, 16.0f);
        this.defaultSize = this.sp2px(context, 14.0f);
        this.centerSpaceHeight = this.dip2px(context, 10.0f);
        this.getAttr(attrs);
        this.initLayout();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.SuperTextView);
        this.leftIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sLeftIconRes);
        this.rightIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sRightIconRes);
        this.rightCheckBoxBg = typedArray.getDrawable(R.styleable.SuperTextView_sRightCheckBoxRes);
        this.leftTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTextString);
        this.centerTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTextString);
        this.rightTextString = typedArray.getString(R.styleable.SuperTextView_sRightTextString);
        this.rightTextStringRightIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sRightTextStringRightIconRes);
        this.rightTextStringRightIconPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTextStringRightIconResPadding, this.dip2px(this.mContext, 5.0f));
        this.leftTopTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTopTextString);
        this.leftBottomTextString = typedArray.getString(R.styleable.SuperTextView_sLeftBottomTextString);
        this.leftBottomTextString2 = typedArray.getString(R.styleable.SuperTextView_sLeftBottomTextString2);
        this.showCheckBox = typedArray.getBoolean(R.styleable.SuperTextView_sRightCheckBoxShow, false);
        this.isChecked = typedArray.getBoolean(R.styleable.SuperTextView_sIsChecked, false);
        this.useRipple = typedArray.getBoolean(R.styleable.SuperTextView_sUseRipple, false);
        this.lineType = typedArray.getInt(R.styleable.SuperTextView_sLineShow, 2);
        this.centerSpaceHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterSpaceHeight, this.centerSpaceHeight);
        this.bothLineWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBothLineWidth, this.dip2px(this.mContext, 0.5f));
        this.topLineWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopLineWidth, this.dip2px(this.mContext, 0.5f));
        this.bottomLineWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomLineWidth, this.dip2px(this.mContext, 0.5f));
        this.lineColor = typedArray.getColor(R.styleable.SuperTextView_sLineColor, this.lineColor);
        this.topLineMargin = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopLineMargin, this.defaultLinePadding);
        this.bottomLineMargin = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomLineMargin, this.defaultLinePadding);
        this.bothLineMargin = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBothLineMargin, this.defaultLinePadding);
        this.leftIconMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconMarginLeft, this.defaultPadding);
        this.leftTVMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTextMarginLeft, this.defaultPadding);
        this.leftTopMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTopTextMarginLeft, this.defaultPadding);
        this.leftBottomMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextMarginLeft, this.defaultPadding);
        this.leftBottomMarginLeft2 = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextMarginLeft2, this.defaultPadding);
        this.rightTVMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTextMarginRight, this.defaultPadding);
        this.rightIconMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconMarginRight, this.defaultPadding);
        this.rightCheckBoxMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightCheckBoxMarginRight, this.defaultPadding);
        this.backgroundColor = typedArray.getColor(R.styleable.SuperTextView_sBackgroundColor, this.defaultBgColor);
        this.leftTVColor = typedArray.getColor(R.styleable.SuperTextView_sLeftTextColor, this.defaultColor);
        this.leftTopTVColor = typedArray.getColor(R.styleable.SuperTextView_sLeftTopTextColor, this.defaultColor);
        this.leftBottomTVColor = typedArray.getColor(R.styleable.SuperTextView_sLeftBottomTextColor, this.defaultColor);
        this.leftBottomTVColor2 = typedArray.getColor(R.styleable.SuperTextView_sLeftBottomTextColor2, this.defaultColor);
        this.rightTVColor = typedArray.getColor(R.styleable.SuperTextView_sRightTextColor, this.defaultColor);
        this.centerTVColor = typedArray.getColor(R.styleable.SuperTextView_sCenterTextColor, this.defaultColor);
        this.leftTVSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTextSize, this.defaultSize);
        this.leftTopTVSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTopTextSize, this.defaultSize);
        this.leftBottomTVSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextSize, this.defaultSize);
        this.leftBottomTVSize2 = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextSize2, this.defaultSize);
        this.rightTVSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTextSize, this.defaultSize);
        this.centerTVSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTextSize, this.defaultSize);
        this.isSingLines = typedArray.getBoolean(R.styleable.SuperTextView_sIsSingLines, this.isSingLines);
        this.maxLines = typedArray.getInt(R.styleable.SuperTextView_sMaxLines, this.maxLines);
        this.maxEms = typedArray.getInt(R.styleable.SuperTextView_sMaxEms, this.maxEms);
        this.leftIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconWidth, 0);
        this.leftIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconHeight, 0);
        this.rightIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconWidth, 0);
        this.rightIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconHeight, 0);
        typedArray.recycle();
    }

    private void initLayout() {
        this.initSuperTextView();
        this.initCenterBaseLine();
        if (this.leftIconRes != null) {
            this.initLeftIcon();
        }
        if (this.leftTopTextString != null) {
            this.initLeftTopText();
        }
        if (this.leftBottomTextString != null) {
            this.initLeftBottomText();
        }
        if (this.leftBottomTextString2 != null) {
            this.initLeftBottomText2();
        }
        if (this.leftTextString != null) {
            this.initLeftText();
        }
        if (this.centerTextString != null) {
            this.initCenterText();
        }
        if (this.rightIconRes != null) {
            this.initRightIcon();
        }
        if (this.rightTextString != null || this.rightTextStringRightIconRes != null) {
            this.initRightText();
        }
        if (this.showCheckBox) {
            this.initRightCheckBox();
        }
        switch (this.lineType) {
            case 0: {
                break;
            }
            case 1: {
                this.initTopLine(this.topLineMargin, this.topLineWidth);
                break;
            }
            case 2: {
                this.initBottomLine(this.bottomLineMargin, this.bottomLineWidth);
                break;
            }
            case 3: {
                this.initTopLine(this.bothLineMargin, this.bothLineWidth);
                this.initBottomLine(this.bothLineMargin, this.bothLineWidth);
            }
        }
    }

    private void initTopLine(int lineMargin, int lineWidth) {
        View topLine = new View(this.mContext);
        this.topLineParams = new RelativeLayout.LayoutParams(-1, lineWidth);
        this.topLineParams.addRule(10, -1);
        this.topLineParams.setMargins(lineMargin, 0, lineMargin, 0);
        topLine.setLayoutParams((ViewGroup.LayoutParams)this.topLineParams);
        topLine.setBackgroundColor(this.lineColor);
        this.addView(topLine);
    }

    private void initBottomLine(int lineMargin, int lineWidth) {
        View bottomLine = new View(this.mContext);
        this.bottomLineParams = new RelativeLayout.LayoutParams(-1, lineWidth);
        this.bottomLineParams.addRule(12, -1);
        this.bottomLineParams.setMargins(lineMargin, 0, lineMargin, 0);
        bottomLine.setLayoutParams((ViewGroup.LayoutParams)this.bottomLineParams);
        bottomLine.setBackgroundColor(this.lineColor);
        this.addView(bottomLine);
    }

    private void initSuperTextView() {
        this.setBackgroundColor(this.backgroundColor);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SuperTextView.this.onSuperTextViewClickListener != null) {
                    SuperTextView.this.onSuperTextViewClickListener.onSuperTextViewClick();
                }
            }
        });
        if (this.useRipple) {
            this.setBackgroundResource(R.drawable.selector_white);
        }
    }

    private void initCenterBaseLine() {
        View view = new View(this.mContext);
        this.centerBaseLineParams = new RelativeLayout.LayoutParams(-1, this.centerSpaceHeight);
        this.centerBaseLineParams.addRule(15, -1);
        view.setId(R.id.sCenterBaseLineId);
        view.setLayoutParams((ViewGroup.LayoutParams)this.centerBaseLineParams);
        this.addView(view);
    }

    private void initLeftIcon() {
        this.leftIconIV = new ImageView(this.mContext);
        this.leftImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftImgParams.addRule(9, -1);
        this.leftImgParams.addRule(15, -1);
        if (this.leftIconHeight != 0 && this.leftIconWidth != 0) {
            this.leftImgParams.width = this.leftIconWidth;
            this.leftImgParams.height = this.leftIconHeight;
        }
        this.setMargin(this.leftImgParams, this.leftIconMarginLeft, 0, 0, 0);
        this.leftIconIV.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.leftIconIV.setId(R.id.sLeftIconId);
        this.leftIconIV.setLayoutParams((ViewGroup.LayoutParams)this.leftImgParams);
        if (this.leftIconRes != null) {
            this.leftIconIV.setImageDrawable(this.leftIconRes);
        }
        this.addView((View)this.leftIconIV);
    }

    private void initLeftText() {
        this.leftTV = new TextView(this.mContext);
        this.leftTextParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftTextParams.addRule(15, -1);
        this.leftTextParams.addRule(1, R.id.sLeftIconId);
        this.setMargin(this.leftTextParams, this.leftTVMarginLeft, 0, this.dip2px(this.mContext, 10.0f), 0);
        this.leftTV.setId(R.id.sLeftTextId);
        this.leftTV.setLayoutParams((ViewGroup.LayoutParams)this.leftTextParams);
        this.leftTV.setText((CharSequence)this.leftTextString);
        this.setTextViewParams(this.leftTV, this.isSingLines, this.maxLines, this.maxEms);
        this.setTextColor(this.leftTV, this.leftTVColor);
        this.setTextSize(this.leftTV, this.leftTVSize);
        this.addView((View)this.leftTV);
    }

    private void setTextViewParams(TextView textView, boolean isSingLines, int maxLines, int maxEms) {
        textView.setSingleLine(isSingLines);
        textView.setMaxLines(maxLines);
        textView.setMaxEms(maxEms);
        textView.setEllipsize(TextUtils.TruncateAt.END);
    }

    private void initLeftTopText() {
        this.leftTopTV = new TextView(this.mContext);
        this.leftTopTextParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftTopTextParams.addRule(2, R.id.sCenterBaseLineId);
        this.leftTopTextParams.addRule(1, R.id.sLeftIconId);
        this.setMargin(this.leftTopTextParams, this.leftTopMarginLeft, 0, 0, 0);
        this.leftTopTV.setId(R.id.sLeftTopTextId);
        this.leftTopTV.setLayoutParams((ViewGroup.LayoutParams)this.leftTopTextParams);
        this.leftTopTV.setText((CharSequence)this.leftTopTextString);
        this.setTextColor(this.leftTopTV, this.leftTopTVColor);
        this.setTextSize(this.leftTopTV, this.leftTopTVSize);
        this.leftTopTV.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SuperTextView.this.onSuperTextViewClickListener != null) {
                    SuperTextView.this.onSuperTextViewClickListener.onLeftTopClick();
                }
            }
        });
        this.setTextViewParams(this.leftTopTV, this.isSingLines, this.maxLines, this.maxEms);
        this.addView((View)this.leftTopTV);
    }

    private void initLeftBottomText() {
        this.leftBottomTV = new TextView(this.mContext);
        this.leftBottomParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftBottomParams.addRule(3, R.id.sCenterBaseLineId);
        this.leftBottomParams.addRule(1, R.id.sLeftIconId);
        this.setMargin(this.leftBottomParams, this.leftBottomMarginLeft, 0, 0, 0);
        this.leftBottomTV.setId(R.id.sLeftBottomTextId);
        this.leftBottomTV.setLayoutParams((ViewGroup.LayoutParams)this.leftBottomParams);
        this.leftBottomTV.setText((CharSequence)this.leftBottomTextString);
        this.setTextColor(this.leftBottomTV, this.leftBottomTVColor);
        this.setTextSize(this.leftBottomTV, this.leftBottomTVSize);
        this.leftBottomTV.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SuperTextView.this.onSuperTextViewClickListener != null) {
                    SuperTextView.this.onSuperTextViewClickListener.onLeftBottomClick();
                }
            }
        });
        this.setTextViewParams(this.leftBottomTV, this.isSingLines, this.maxLines, this.maxEms);
        this.addView((View)this.leftBottomTV);
    }

    private void initLeftBottomText2() {
        this.leftBottomTV2 = new TextView(this.mContext);
        this.leftBottomParams2 = new RelativeLayout.LayoutParams(-2, -2);
        this.leftBottomParams2.addRule(3, R.id.sCenterBaseLineId);
        this.leftBottomParams2.addRule(1, R.id.sLeftBottomTextId);
        this.setMargin(this.leftBottomParams2, this.leftBottomMarginLeft2, 0, 0, 0);
        this.leftBottomTV2.setId(R.id.sLeftBottomTextId2);
        this.leftBottomTV2.setLayoutParams((ViewGroup.LayoutParams)this.leftBottomParams2);
        this.leftBottomTV2.setText((CharSequence)this.leftBottomTextString2);
        this.setTextColor(this.leftBottomTV2, this.leftBottomTVColor2);
        this.setTextSize(this.leftBottomTV2, this.leftBottomTVSize2);
        this.leftBottomTV2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SuperTextView.this.onSuperTextViewClickListener != null) {
                    SuperTextView.this.onSuperTextViewClickListener.onLeftBottomClick2();
                }
            }
        });
        this.setTextViewParams(this.leftBottomTV2, this.isSingLines, this.maxLines, this.maxEms);
        this.addView((View)this.leftBottomTV2);
    }

    private void initCenterText() {
        this.centerTV = new TextView(this.mContext);
        this.centerTextParams = new RelativeLayout.LayoutParams(-2, -2);
        this.centerTextParams.addRule(13, -1);
        this.centerTV.setId(R.id.sCenterTextId);
        this.centerTV.setLayoutParams((ViewGroup.LayoutParams)this.centerTextParams);
        this.centerTV.setText((CharSequence)this.centerTextString);
        this.setTextColor(this.centerTV, this.centerTVColor);
        this.setTextSize(this.centerTV, this.centerTVSize);
        this.setTextViewParams(this.centerTV, this.isSingLines, this.maxLines, this.maxEms);
        this.addView((View)this.centerTV);
    }

    private void initRightText() {
        this.rightTV = new TextView(this.mContext);
        this.rightTextParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightTextParams.addRule(15, -1);
        this.rightTextParams.addRule(11, -1);
        this.rightTextParams.addRule(1, R.id.sLeftTextId);
        this.rightTextParams.addRule(0, R.id.sRightIconId);
        this.setMargin(this.rightTextParams, 0, 0, this.rightTVMarginRight, 0);
        this.rightTV.setId(R.id.sRightTextId);
        this.rightTV.setLayoutParams((ViewGroup.LayoutParams)this.rightTextParams);
        this.rightTV.setText((CharSequence)this.rightTextString);
        this.setTextColor(this.rightTV, this.rightTVColor);
        this.setTextSize(this.rightTV, this.rightTVSize);
        SuperTextView.setTextViewRightDrawble(this.rightTV, this.rightTextStringRightIconRes, this.rightTextStringRightIconPadding);
        this.rightTV.setGravity(5);
        this.setTextViewParams(this.rightTV, this.isSingLines, this.maxLines, this.maxEms);
        this.addView((View)this.rightTV);
    }

    private void initRightIcon() {
        this.rightIconIV = new ImageView(this.mContext);
        this.rightImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightImgParams.addRule(11, -1);
        this.rightImgParams.addRule(15, -1);
        if (this.rightIconHeight != 0 && this.rightIconWidth != 0) {
            this.rightImgParams.width = this.rightIconWidth;
            this.rightImgParams.height = this.rightIconHeight;
        }
        this.setMargin(this.rightImgParams, 0, 0, this.rightIconMarginRight, 0);
        this.rightIconIV.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.rightIconIV.setId(R.id.sRightIconId);
        this.rightIconIV.setLayoutParams((ViewGroup.LayoutParams)this.rightImgParams);
        if (this.rightIconRes != null) {
            this.rightIconIV.setImageDrawable(this.rightIconRes);
        }
        this.addView((View)this.rightIconIV);
    }

    private void initRightCheckBox() {
        this.rightCheckBox = new CheckBox(this.mContext);
        this.rightCheckBoxParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightCheckBoxParams.addRule(11, -1);
        this.rightCheckBoxParams.addRule(15, -1);
        this.setMargin(this.rightCheckBoxParams, 0, 0, this.rightCheckBoxMarginRight, 0);
        this.rightCheckBox.setLayoutParams((ViewGroup.LayoutParams)this.rightCheckBoxParams);
        if (this.rightCheckBoxBg != null) {
            this.rightCheckBox.setGravity(13);
            this.rightCheckBox.setButtonDrawable(this.rightCheckBoxBg);
        }
        this.rightCheckBox.setChecked(this.isChecked);
        this.addView((View)this.rightCheckBox);
    }

    private void setMargin(RelativeLayout.LayoutParams params, int left, int top, int right, int bottom) {
        params.setMargins(left, top, right, bottom);
    }

    private void setPadding(View view, int left, int top, int right, int bottom) {
        view.setPadding(left, top, right, bottom);
    }

    private void setTextSize(TextView textView, int size) {
        textView.setTextSize(0, (float)size);
    }

    private void setTextColor(TextView textView, int color) {
        textView.setTextColor(color);
    }

    public SuperTextView setLeftIcon(Drawable leftIcon) {
        this.leftIconRes = leftIcon;
        if (this.leftIconIV == null) {
            this.initLeftIcon();
        } else {
            this.leftIconIV.setImageDrawable(leftIcon);
        }
        return this;
    }

    public SuperTextView setRightIcon(Drawable rightIcon) {
        this.rightIconRes = rightIcon;
        if (this.rightIconIV == null) {
            this.initRightIcon();
        } else {
            this.rightIconIV.setImageDrawable(rightIcon);
        }
        return this;
    }

    public SuperTextView setLeftString(String leftString) {
        this.leftTextString = leftString;
        if (this.leftTV == null) {
            this.initLeftText();
        } else {
            this.leftTV.setText((CharSequence)leftString);
        }
        return this;
    }

    public SuperTextView setLeftTopString(String leftTopString) {
        this.leftTopTextString = leftTopString;
        if (this.leftTopTV == null) {
            this.initLeftTopText();
        } else {
            this.leftTopTV.setText((CharSequence)leftTopString);
        }
        return this;
    }

    public SuperTextView setLeftBottomString(String leftBottomString) {
        this.leftBottomTextString = leftBottomString;
        if (this.leftBottomTV == null) {
            this.initLeftBottomText();
        } else {
            this.leftBottomTV.setText((CharSequence)leftBottomString);
        }
        return this;
    }

    public SuperTextView setLeftBottomString2(String leftBottomString2) {
        this.leftBottomTextString2 = leftBottomString2;
        if (this.leftBottomTV2 == null) {
            this.initLeftBottomText2();
        } else {
            this.leftBottomTV2.setText((CharSequence)leftBottomString2);
        }
        return this;
    }

    public SuperTextView setRightString(String rightString) {
        this.rightTextString = rightString;
        if (this.rightTV == null) {
            this.initRightText();
        } else {
            this.rightTV.setText((CharSequence)rightString);
        }
        return this;
    }

    public SuperTextView setRightString(String rightString, Drawable drawable2, int drawablePadding) {
        this.rightTextString = rightString;
        this.rightTextStringRightIconRes = drawable2;
        this.rightTextStringRightIconPadding = drawablePadding;
        if (this.rightTV == null) {
            this.initRightText();
        } else {
            this.rightTV.setText((CharSequence)rightString);
        }
        return this;
    }

    public SuperTextView setCenterString(String centerString) {
        this.centerTextString = centerString;
        if (this.centerTV == null) {
            this.initCenterText();
        } else {
            this.centerTV.setText((CharSequence)centerString);
        }
        return this;
    }

    public SuperTextView setCbChecked(boolean checked) {
        this.isChecked = checked;
        if (this.rightCheckBox == null) {
            this.initRightCheckBox();
        } else {
            this.rightCheckBox.setChecked(checked);
        }
        return this;
    }

    public SuperTextView setCbBackground(Drawable drawable2) {
        this.rightCheckBoxBg = drawable2;
        if (this.rightCheckBox == null) {
            this.initRightCheckBox();
        } else {
            this.rightCheckBox.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public boolean getCbisChecked() {
        boolean isChecked = false;
        if (this.rightCheckBox != null) {
            isChecked = this.rightCheckBox.isChecked();
        }
        return isChecked;
    }

    public SuperTextView setLeftTVColor(int textColor) {
        this.leftTVColor = textColor;
        if (this.leftTV == null) {
            this.initLeftText();
        } else {
            this.leftTV.setTextColor(textColor);
        }
        return this;
    }

    public SuperTextView setRightTVColor(int textColor) {
        this.rightTVColor = textColor;
        if (this.rightTV == null) {
            this.initRightText();
        } else {
            this.rightTV.setTextColor(textColor);
        }
        return this;
    }

    public SuperTextView setLeftTopTVColor(int textColor) {
        this.leftTopTVColor = textColor;
        if (this.leftTopTV == null) {
            this.initLeftTopText();
        } else {
            this.leftTopTV.setTextColor(textColor);
        }
        return this;
    }

    public SuperTextView setLeftBottomTVColor(int textColor) {
        this.leftBottomTVColor = textColor;
        if (this.leftBottomTV == null) {
            this.initLeftBottomText();
        } else {
            this.leftBottomTV.setTextColor(textColor);
        }
        return this;
    }

    public SuperTextView setLeftBottomTVColor2(int textColor) {
        this.leftBottomTVColor2 = textColor;
        if (this.leftBottomTV2 == null) {
            this.initLeftBottomText2();
        } else {
            this.leftBottomTV2.setTextColor(textColor);
        }
        return this;
    }

    public SuperTextView setOnSuperTextViewClickListener(OnSuperTextViewClickListener listener) {
        this.onSuperTextViewClickListener = listener;
        return this;
    }

    public int getViewId(int viewName) {
        int viewId = 0;
        switch (viewName) {
            case 0: {
                if (this.leftTV == null) {
                    this.initLeftText();
                }
                viewId = R.id.sLeftTextId;
                break;
            }
            case 1: {
                if (this.leftTopTV == null) {
                    this.initLeftTopText();
                }
                viewId = R.id.sLeftTopTextId;
                break;
            }
            case 2: {
                if (this.leftBottomTV == null) {
                    this.initLeftBottomText();
                }
                viewId = R.id.sLeftBottomTextId;
                break;
            }
            case 3: {
                if (this.leftBottomTV2 == null) {
                    this.initLeftBottomText2();
                }
                viewId = R.id.sLeftBottomTextId2;
                break;
            }
            case 5: {
                if (this.centerTV == null) {
                    this.initCenterText();
                }
                viewId = R.id.sCenterTextId;
                break;
            }
            case 4: {
                if (this.rightTV == null) {
                    this.initRightText();
                }
                viewId = R.id.sRightTextId;
                break;
            }
            case 6: {
                if (this.leftIconIV == null) {
                    this.initLeftIcon();
                }
                viewId = R.id.sLeftIconId;
                break;
            }
            case 7: {
                if (this.rightIconIV == null) {
                    this.initRightIcon();
                }
                viewId = R.id.sRightIconId;
            }
        }
        return viewId;
    }

    public View getView(int viewName) {
        ImageView view = null;
        switch (viewName) {
            case 6: {
                if (this.leftIconIV == null) {
                    this.initLeftIcon();
                }
                view = this.leftIconIV;
                break;
            }
            case 7: {
                if (this.rightIconIV == null) {
                    this.initRightIcon();
                }
                view = this.rightIconIV;
            }
        }
        return view;
    }

    public int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * scale + 0.5f);
    }

    public static void setTextViewRightDrawble(TextView textView, Drawable drawable2, int drawablePadding) {
        if (drawable2 != null && textView != null) {
            drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
            textView.setCompoundDrawables(null, null, drawable2, null);
            textView.setCompoundDrawablePadding(drawablePadding);
        }
    }

    public static class OnSuperTextViewClickListener {
        public void onSuperTextViewClick() {
        }

        public void onLeftTopClick() {
        }

        public void onLeftBottomClick() {
        }

        public void onLeftBottomClick2() {
        }
    }
}

