/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.loader;

import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.loader.content.CursorLoader;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.utils.MediaStoreCompat;

public class AlbumMediaLoader
extends CursorLoader {
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String[] PROJECTION = new String[]{"_id", "_display_name", "mime_type", "_size", "duration"};
    private static final String SELECTION_ALL = "(media_type=? OR media_type=?) AND _size>0";
    private static final String[] SELECTION_ALL_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};
    private static final String SELECTION_ALL_FOR_SINGLE_MEDIA_TYPE = "media_type=? AND _size>0";
    private static final String SELECTION_ALBUM = "(media_type=? OR media_type=?) AND  bucket_id=? AND _size>0";
    private static final String SELECTION_ALBUM_FOR_SINGLE_MEDIA_TYPE = "media_type=? AND  bucket_id=? AND _size>0";
    private static final String SELECTION_ALL_FOR_GIF = "media_type=? AND mime_type=? AND _size>0";
    private static final String SELECTION_ALBUM_FOR_GIF = "media_type=? AND  bucket_id=? AND mime_type=? AND _size>0";
    private static final String ORDER_BY = "datetaken DESC";
    private final boolean mEnableCapture;

    private AlbumMediaLoader(Context context, String selection, String[] selectionArgs, boolean capture) {
        super(context, QUERY_URI, PROJECTION, selection, selectionArgs, ORDER_BY);
        this.mEnableCapture = capture;
    }

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    private static String[] getSelectionAlbumArgs(String albumId) {
        return new String[]{String.valueOf(1), String.valueOf(3), albumId};
    }

    private static String[] getSelectionAlbumArgsForSingleMediaType(int mediaType, String albumId) {
        return new String[]{String.valueOf(mediaType), albumId};
    }

    private static String[] getSelectionArgsForGifType(int mediaType) {
        return new String[]{String.valueOf(mediaType), "image/gif"};
    }

    private static String[] getSelectionAlbumArgsForGifType(int mediaType, String albumId) {
        return new String[]{String.valueOf(mediaType), albumId, "image/gif"};
    }

    public static CursorLoader newInstance(Context context, Album album, boolean capture) {
        boolean enableCapture;
        String[] selectionArgs;
        String selection;
        if (album.isAll()) {
            if (SelectionSpec.getInstance().onlyShowGif()) {
                selection = SELECTION_ALL_FOR_GIF;
                selectionArgs = AlbumMediaLoader.getSelectionArgsForGifType(1);
            } else if (SelectionSpec.getInstance().onlyShowImages()) {
                selection = SELECTION_ALL_FOR_SINGLE_MEDIA_TYPE;
                selectionArgs = AlbumMediaLoader.getSelectionArgsForSingleMediaType(1);
            } else if (SelectionSpec.getInstance().onlyShowVideos()) {
                selection = SELECTION_ALL_FOR_SINGLE_MEDIA_TYPE;
                selectionArgs = AlbumMediaLoader.getSelectionArgsForSingleMediaType(3);
            } else {
                selection = SELECTION_ALL;
                selectionArgs = SELECTION_ALL_ARGS;
            }
            enableCapture = capture;
        } else {
            if (SelectionSpec.getInstance().onlyShowGif()) {
                selection = SELECTION_ALBUM_FOR_GIF;
                selectionArgs = AlbumMediaLoader.getSelectionAlbumArgsForGifType(1, album.getId());
            } else if (SelectionSpec.getInstance().onlyShowImages()) {
                selection = SELECTION_ALBUM_FOR_SINGLE_MEDIA_TYPE;
                selectionArgs = AlbumMediaLoader.getSelectionAlbumArgsForSingleMediaType(1, album.getId());
            } else if (SelectionSpec.getInstance().onlyShowVideos()) {
                selection = SELECTION_ALBUM_FOR_SINGLE_MEDIA_TYPE;
                selectionArgs = AlbumMediaLoader.getSelectionAlbumArgsForSingleMediaType(3, album.getId());
            } else {
                selection = SELECTION_ALBUM;
                selectionArgs = AlbumMediaLoader.getSelectionAlbumArgs(album.getId());
            }
            enableCapture = false;
        }
        return new AlbumMediaLoader(context, selection, selectionArgs, enableCapture);
    }

    public Cursor loadInBackground() {
        Cursor result = super.loadInBackground();
        if (!this.mEnableCapture || !MediaStoreCompat.hasCameraFeature(this.getContext())) {
            return result;
        }
        MatrixCursor dummy = new MatrixCursor(PROJECTION);
        dummy.addRow(new Object[]{-1L, "Capture", "", 0, 0});
        return new MergeCursor(new Cursor[]{dummy, result});
    }

    public void onContentChanged() {
    }
}

