/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.engine.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.zhihu.matisse.engine.ImageEngine;

public class GlideEngine
implements ImageEngine {
    @Override
    public void loadThumbnail(Context context, int resize, Drawable placeholder, ImageView imageView, Uri uri) {
        Glide.with((Context)context).asBitmap().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resize, resize)).placeholder(placeholder)).centerCrop()).into(imageView);
    }

    @Override
    public void loadGifThumbnail(Context context, int resize, Drawable placeholder, ImageView imageView, Uri uri) {
        Glide.with((Context)context).asBitmap().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resize, resize)).placeholder(placeholder)).centerCrop()).into(imageView);
    }

    @Override
    public void loadImage(Context context, int resizeX, int resizeY, ImageView imageView, Uri uri) {
        Glide.with((Context)context).load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resizeX, resizeY)).priority(Priority.HIGH)).fitCenter()).into(imageView);
    }

    @Override
    public void loadLargeImage(Context context, int resizeX, int resizeY, final SubsamplingScaleImageView imageView, Uri uri) {
        Glide.with((Context)context).asBitmap().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resizeX, resizeY)).priority(Priority.HIGH)).fitCenter()).into((Target)new CustomViewTarget<View, Bitmap>((View)imageView){

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
            }

            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition transition) {
                imageView.setImage(ImageSource.cachedBitmap((Bitmap)resource));
            }

            protected void onResourceCleared(@Nullable Drawable placeholder) {
            }
        });
    }

    @Override
    public void loadGifImage(Context context, int resizeX, int resizeY, ImageView imageView, Uri uri) {
        Glide.with((Context)context).asGif().load(uri).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resizeX, resizeY)).priority(Priority.HIGH)).fitCenter()).into(imageView);
    }

    @Override
    public boolean supportAnimatedGif() {
        return true;
    }
}

