/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.ui;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.model.AlbumCollection;
import com.zhihu.matisse.internal.model.SelectedItemCollection;
import com.zhihu.matisse.internal.ui.AlbumPreviewActivity;
import com.zhihu.matisse.internal.ui.MediaSelectionFragment;
import com.zhihu.matisse.internal.ui.SelectedPreviewActivity;
import com.zhihu.matisse.internal.ui.adapter.AlbumMediaAdapter;
import com.zhihu.matisse.internal.ui.adapter.AlbumsAdapter;
import com.zhihu.matisse.internal.ui.widget.AlbumsSpinner;
import com.zhihu.matisse.internal.ui.widget.CheckRadioView;
import com.zhihu.matisse.internal.ui.widget.IncapableDialog;
import com.zhihu.matisse.internal.utils.MediaStoreCompat;
import com.zhihu.matisse.internal.utils.PathUtils;
import com.zhihu.matisse.internal.utils.PhotoMetadataUtils;
import com.zhihu.matisse.internal.utils.SingleMediaScanner;
import java.util.ArrayList;

public class MatisseActivity
extends AppCompatActivity
implements AlbumCollection.AlbumCallbacks,
AdapterView.OnItemSelectedListener,
MediaSelectionFragment.SelectionProvider,
View.OnClickListener,
AlbumMediaAdapter.CheckStateListener,
AlbumMediaAdapter.OnMediaClickListener,
AlbumMediaAdapter.OnPhotoCapture {
    public static final String EXTRA_RESULT_SELECTION = "extra_result_selection";
    public static final String EXTRA_RESULT_SELECTION_PATH = "extra_result_selection_path";
    public static final String EXTRA_RESULT_ORIGINAL_ENABLE = "extra_result_original_enable";
    public static final String CHECK_STATE = "checkState";
    static final int REQUEST_CODE_CAPTURE = 24;
    private final AlbumCollection mAlbumCollection = new AlbumCollection();
    private MediaStoreCompat mMediaStoreCompat;
    private SelectedItemCollection mSelectedCollection = new SelectedItemCollection((Context)this);
    private SelectionSpec mSpec;
    private AlbumsSpinner mAlbumsSpinner;
    private AlbumsAdapter mAlbumsAdapter;
    private TextView mButtonPreview;
    private TextView mButtonApply;
    private View mContainer;
    private View mEmptyView;
    private LinearLayout mOriginalLayout;
    private CheckRadioView mOriginal;
    private boolean mOriginalEnable;
    private final ActivityResultLauncher<Intent> previewLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (ActivityResultCallback)new ActivityResultCallback<ActivityResult>(){

        public void onActivityResult(ActivityResult activityResult) {
            if (activityResult.getResultCode() != -1) {
                return;
            }
            Intent data = activityResult.getData();
            if (data == null) {
                return;
            }
            Bundle resultBundle = data.getBundleExtra("extra_result_bundle");
            if (resultBundle == null) {
                return;
            }
            ArrayList selected = resultBundle.getParcelableArrayList("state_selection");
            MatisseActivity.this.mOriginalEnable = data.getBooleanExtra(MatisseActivity.EXTRA_RESULT_ORIGINAL_ENABLE, false);
            int collectionType = resultBundle.getInt("state_collection_type", 0);
            if (data.getBooleanExtra("extra_result_apply", false)) {
                Intent result = new Intent();
                ArrayList<Uri> selectedUris = new ArrayList<Uri>();
                ArrayList<String> selectedPaths = new ArrayList<String>();
                if (selected != null) {
                    for (Item item : selected) {
                        selectedUris.add(item.getContentUri());
                        selectedPaths.add(PathUtils.getPath((Context)MatisseActivity.this, item.getContentUri()));
                    }
                }
                result.putParcelableArrayListExtra(MatisseActivity.EXTRA_RESULT_SELECTION, selectedUris);
                result.putStringArrayListExtra(MatisseActivity.EXTRA_RESULT_SELECTION_PATH, selectedPaths);
                result.putExtra(MatisseActivity.EXTRA_RESULT_ORIGINAL_ENABLE, MatisseActivity.this.mOriginalEnable);
                MatisseActivity.this.setResult(-1, result);
                MatisseActivity.this.finish();
            } else {
                MatisseActivity.this.mSelectedCollection.overwrite(selected, collectionType);
                Fragment mediaSelectionFragment = MatisseActivity.this.getSupportFragmentManager().findFragmentByTag(MediaSelectionFragment.class.getSimpleName());
                if (mediaSelectionFragment instanceof MediaSelectionFragment) {
                    ((MediaSelectionFragment)mediaSelectionFragment).refreshMediaGrid();
                }
                MatisseActivity.this.updateBottomToolbar();
            }
        }
    });

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Drawable navigationIcon;
        this.mSpec = SelectionSpec.getInstance();
        this.setTheme(this.mSpec.themeId);
        super.onCreate(savedInstanceState);
        if (!this.mSpec.hasInited) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.setContentView(R.layout.activity_matisse);
        if (this.mSpec.needOrientationRestriction()) {
            this.setRequestedOrientation(this.mSpec.orientation);
        }
        if (this.mSpec.capture) {
            this.mMediaStoreCompat = new MediaStoreCompat(this);
            if (this.mSpec.captureStrategy == null) {
                throw new RuntimeException("Don't forget to set CaptureStrategy.");
            }
            this.mMediaStoreCompat.setCaptureStrategy(this.mSpec.captureStrategy);
        }
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        if ((navigationIcon = toolbar.getNavigationIcon()) != null) {
            TypedArray ta = this.getTheme().obtainStyledAttributes(new int[]{R.attr.album_element_color});
            int color2 = ta.getColor(0, 0);
            ta.recycle();
            if (Build.VERSION.SDK_INT >= 29) {
                navigationIcon.setColorFilter((ColorFilter)new BlendModeColorFilter(color2, BlendMode.SRC_IN));
            } else {
                navigationIcon.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            }
        }
        this.mButtonPreview = (TextView)this.findViewById(R.id.button_preview);
        this.mButtonApply = (TextView)this.findViewById(R.id.button_apply);
        this.mButtonPreview.setOnClickListener((View.OnClickListener)this);
        this.mButtonApply.setOnClickListener((View.OnClickListener)this);
        this.mContainer = this.findViewById(R.id.container);
        this.mEmptyView = this.findViewById(R.id.empty_view);
        this.mOriginalLayout = (LinearLayout)this.findViewById(R.id.originalLayout);
        this.mOriginal = (CheckRadioView)this.findViewById(R.id.original);
        this.mOriginalLayout.setOnClickListener((View.OnClickListener)this);
        this.mSelectedCollection.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mOriginalEnable = savedInstanceState.getBoolean(CHECK_STATE);
        }
        this.updateBottomToolbar();
        this.mAlbumsAdapter = new AlbumsAdapter((Context)this, null, false);
        this.mAlbumsSpinner = new AlbumsSpinner((Context)this);
        this.mAlbumsSpinner.setOnItemSelectedListener(this);
        this.mAlbumsSpinner.setSelectedTextView((TextView)this.findViewById(R.id.selected_album));
        this.mAlbumsSpinner.setPopupAnchorView(this.findViewById(R.id.toolbar));
        this.mAlbumsSpinner.setAdapter(this.mAlbumsAdapter);
        this.mAlbumCollection.onCreate((FragmentActivity)this, this);
        this.mAlbumCollection.onRestoreInstanceState(savedInstanceState);
        this.mAlbumCollection.loadAlbums();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mSelectedCollection.onSaveInstanceState(outState);
        this.mAlbumCollection.onSaveInstanceState(outState);
        outState.putBoolean(CHECK_STATE, this.mOriginalEnable);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mAlbumCollection.onDestroy();
        this.mSpec.onCheckedListener = null;
        this.mSpec.onSelectedListener = null;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        this.setResult(0);
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 24) {
            Uri contentUri = this.mMediaStoreCompat.getCurrentPhotoUri();
            String path = this.mMediaStoreCompat.getCurrentPhotoPath();
            ArrayList<Uri> selected = new ArrayList<Uri>();
            selected.add(contentUri);
            ArrayList<String> selectedPath = new ArrayList<String>();
            selectedPath.add(path);
            Intent result = new Intent();
            result.putParcelableArrayListExtra(EXTRA_RESULT_SELECTION, selected);
            result.putStringArrayListExtra(EXTRA_RESULT_SELECTION_PATH, selectedPath);
            this.setResult(-1, result);
            if (Build.VERSION.SDK_INT < 21) {
                this.revokeUriPermission(contentUri, 3);
            }
            new SingleMediaScanner(this.getApplicationContext(), path, new SingleMediaScanner.ScanListener(){

                @Override
                public void onScanFinish() {
                    Log.i((String)"SingleMediaScanner", (String)"scan finish!");
                }
            });
            this.finish();
        }
    }

    private void updateBottomToolbar() {
        int selectedCount = this.mSelectedCollection.count();
        if (selectedCount == 0) {
            this.mButtonPreview.setEnabled(false);
            this.mButtonApply.setEnabled(false);
            this.mButtonApply.setText((CharSequence)this.getString(R.string.button_apply_default));
        } else if (selectedCount == 1 && this.mSpec.singleSelectionModeEnabled()) {
            this.mButtonPreview.setEnabled(true);
            this.mButtonApply.setText(R.string.button_apply_default);
            this.mButtonApply.setEnabled(true);
        } else {
            this.mButtonPreview.setEnabled(true);
            this.mButtonApply.setEnabled(true);
            this.mButtonApply.setText((CharSequence)this.getString(R.string.button_apply, new Object[]{selectedCount}));
        }
        if (this.mSpec.originalable) {
            this.mOriginalLayout.setVisibility(0);
            this.updateOriginalState();
        } else {
            this.mOriginalLayout.setVisibility(4);
        }
    }

    private void updateOriginalState() {
        this.mOriginal.setChecked(this.mOriginalEnable);
        if (this.countOverMaxSize() > 0 && this.mOriginalEnable) {
            IncapableDialog incapableDialog = IncapableDialog.newInstance("", this.getString(R.string.error_over_original_size, new Object[]{this.mSpec.originalMaxSize}));
            incapableDialog.show(this.getSupportFragmentManager(), IncapableDialog.class.getName());
            this.mOriginal.setChecked(false);
            this.mOriginalEnable = false;
        }
    }

    private int countOverMaxSize() {
        int count = 0;
        int selectedCount = this.mSelectedCollection.count();
        for (int i = 0; i < selectedCount; ++i) {
            float size;
            Item item = this.mSelectedCollection.asList().get(i);
            if (!item.isImage() || !((size = PhotoMetadataUtils.getSizeInMB(item.size)) > (float)this.mSpec.originalMaxSize)) continue;
            ++count;
        }
        return count;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.button_preview) {
            Intent intent = new Intent((Context)this, SelectedPreviewActivity.class);
            intent.putExtra("extra_default_bundle", this.mSelectedCollection.getDataWithBundle());
            intent.putExtra(EXTRA_RESULT_ORIGINAL_ENABLE, this.mOriginalEnable);
            this.previewLauncher.launch((Object)intent);
        } else if (v.getId() == R.id.button_apply) {
            Intent result = new Intent();
            ArrayList selectedUris = (ArrayList)this.mSelectedCollection.asListOfUri();
            result.putParcelableArrayListExtra(EXTRA_RESULT_SELECTION, selectedUris);
            ArrayList selectedPaths = (ArrayList)this.mSelectedCollection.asListOfString();
            result.putStringArrayListExtra(EXTRA_RESULT_SELECTION_PATH, selectedPaths);
            result.putExtra(EXTRA_RESULT_ORIGINAL_ENABLE, this.mOriginalEnable);
            this.setResult(-1, result);
            this.finish();
        } else if (v.getId() == R.id.originalLayout) {
            int count = this.countOverMaxSize();
            if (count > 0) {
                IncapableDialog incapableDialog = IncapableDialog.newInstance("", this.getString(R.string.error_over_original_count, new Object[]{count, this.mSpec.originalMaxSize}));
                incapableDialog.show(this.getSupportFragmentManager(), IncapableDialog.class.getName());
                return;
            }
            this.mOriginalEnable = !this.mOriginalEnable;
            this.mOriginal.setChecked(this.mOriginalEnable);
            if (this.mSpec.onCheckedListener != null) {
                this.mSpec.onCheckedListener.onCheck(this.mOriginalEnable);
            }
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        this.mAlbumCollection.setStateCurrentSelection(position);
        this.mAlbumsAdapter.getCursor().moveToPosition(position);
        Album album = Album.valueOf(this.mAlbumsAdapter.getCursor());
        if (album.isAll() && SelectionSpec.getInstance().capture) {
            album.addCaptureCount();
        }
        this.onAlbumSelected(album);
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    public void onAlbumLoad(final Cursor cursor) {
        this.mAlbumsAdapter.swapCursor(cursor);
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                cursor.moveToPosition(MatisseActivity.this.mAlbumCollection.getCurrentSelection());
                MatisseActivity.this.mAlbumsSpinner.setSelection((Context)MatisseActivity.this, MatisseActivity.this.mAlbumCollection.getCurrentSelection());
                Album album = Album.valueOf(cursor);
                if (album.isAll() && SelectionSpec.getInstance().capture) {
                    album.addCaptureCount();
                }
                MatisseActivity.this.onAlbumSelected(album);
            }
        });
    }

    @Override
    public void onAlbumReset() {
        this.mAlbumsAdapter.swapCursor(null);
    }

    private void onAlbumSelected(Album album) {
        if (album.isAll() && album.isEmpty()) {
            this.mContainer.setVisibility(8);
            this.mEmptyView.setVisibility(0);
        } else {
            this.mContainer.setVisibility(0);
            this.mEmptyView.setVisibility(8);
            MediaSelectionFragment fragment = MediaSelectionFragment.newInstance(album);
            this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)fragment, MediaSelectionFragment.class.getSimpleName()).commitAllowingStateLoss();
        }
    }

    @Override
    public void onUpdate() {
        this.updateBottomToolbar();
        if (this.mSpec.onSelectedListener != null) {
            this.mSpec.onSelectedListener.onSelected(this.mSelectedCollection.asListOfUri(), this.mSelectedCollection.asListOfString());
        }
    }

    @Override
    public void onMediaClick(Album album, Item item, int adapterPosition) {
        Intent intent = new Intent((Context)this, AlbumPreviewActivity.class);
        intent.putExtra("extra_album", (Parcelable)album);
        intent.putExtra("extra_item", (Parcelable)item);
        intent.putExtra("extra_default_bundle", this.mSelectedCollection.getDataWithBundle());
        intent.putExtra(EXTRA_RESULT_ORIGINAL_ENABLE, this.mOriginalEnable);
        this.previewLauncher.launch((Object)intent);
    }

    @Override
    public SelectedItemCollection provideSelectedItemCollection() {
        return this.mSelectedCollection;
    }

    @Override
    public void capture() {
        if (this.mMediaStoreCompat != null) {
            this.mMediaStoreCompat.dispatchCaptureIntent(this, 24);
        }
    }
}

