/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.adapter;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.zhihu.matisse.R;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.IncapableCause;
import com.zhihu.matisse.internal.entity.Item;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.internal.model.SelectedItemCollection;
import com.zhihu.matisse.internal.ui.adapter.RecyclerViewCursorAdapter;
import com.zhihu.matisse.internal.ui.widget.CheckView;
import com.zhihu.matisse.internal.ui.widget.MediaGrid;

public class AlbumMediaAdapter
extends RecyclerViewCursorAdapter<RecyclerView.ViewHolder>
implements MediaGrid.OnMediaGridClickListener {
    private static final int VIEW_TYPE_CAPTURE = 1;
    private static final int VIEW_TYPE_MEDIA = 2;
    private final SelectedItemCollection mSelectedCollection;
    private final Drawable mPlaceholder;
    private SelectionSpec mSelectionSpec = SelectionSpec.getInstance();
    private CheckStateListener mCheckStateListener;
    private OnMediaClickListener mOnMediaClickListener;
    private RecyclerView mRecyclerView;
    private int mImageResize;

    public AlbumMediaAdapter(Context context, SelectedItemCollection selectedCollection, RecyclerView recyclerView) {
        super(null);
        this.mSelectedCollection = selectedCollection;
        TypedArray ta = context.getTheme().obtainStyledAttributes(new int[]{R.attr.item_placeholder});
        this.mPlaceholder = ta.getDrawable(0);
        ta.recycle();
        this.mRecyclerView = recyclerView;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.photo_capture_item, parent, false);
            CaptureViewHolder holder = new CaptureViewHolder(v);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (v.getContext() instanceof OnPhotoCapture) {
                        ((OnPhotoCapture)v.getContext()).capture();
                    }
                }
            });
            return holder;
        }
        if (viewType == 2) {
            View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.media_grid_item, parent, false);
            return new MediaViewHolder(v);
        }
        return null;
    }

    @Override
    protected void onBindViewHolder(RecyclerView.ViewHolder holder, Cursor cursor) {
        if (holder instanceof CaptureViewHolder) {
            CaptureViewHolder captureViewHolder = (CaptureViewHolder)holder;
            Drawable[] drawables = captureViewHolder.mHint.getCompoundDrawables();
            TypedArray ta = holder.itemView.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.capture_textColor});
            int color2 = ta.getColor(0, 0);
            ta.recycle();
            for (int i = 0; i < drawables.length; ++i) {
                Drawable.ConstantState state;
                Drawable drawable2 = drawables[i];
                if (drawable2 == null || (state = drawable2.getConstantState()) == null) continue;
                Drawable newDrawable = state.newDrawable().mutate();
                newDrawable.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
                newDrawable.setBounds(drawable2.getBounds());
                drawables[i] = newDrawable;
            }
            captureViewHolder.mHint.setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);
        } else if (holder instanceof MediaViewHolder) {
            MediaViewHolder mediaViewHolder = (MediaViewHolder)holder;
            Item item = Item.valueOf(cursor);
            mediaViewHolder.mMediaGrid.preBindMedia(new MediaGrid.PreBindInfo(this.getImageResize(mediaViewHolder.mMediaGrid.getContext()), this.mPlaceholder, this.mSelectionSpec.countable, holder));
            mediaViewHolder.mMediaGrid.bindMedia(item);
            mediaViewHolder.mMediaGrid.setOnMediaGridClickListener(this);
            this.setCheckStatus(item, mediaViewHolder.mMediaGrid);
        }
    }

    private void setCheckStatus(Item item, MediaGrid mediaGrid) {
        if (this.mSelectionSpec.countable) {
            int checkedNum = this.mSelectedCollection.checkedNumOf(item);
            if (checkedNum > 0) {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setCheckedNum(checkedNum);
            } else if (this.mSelectedCollection.maxSelectableReached()) {
                mediaGrid.setCheckEnabled(false);
                mediaGrid.setCheckedNum(Integer.MIN_VALUE);
            } else {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setCheckedNum(checkedNum);
            }
        } else {
            boolean selected = this.mSelectedCollection.isSelected(item);
            if (selected) {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setChecked(true);
            } else if (this.mSelectedCollection.maxSelectableReached()) {
                mediaGrid.setCheckEnabled(false);
                mediaGrid.setChecked(false);
            } else {
                mediaGrid.setCheckEnabled(true);
                mediaGrid.setChecked(false);
            }
        }
    }

    @Override
    public void onThumbnailClicked(ImageView thumbnail, Item item, RecyclerView.ViewHolder holder) {
        if (this.mOnMediaClickListener != null) {
            this.mOnMediaClickListener.onMediaClick(null, item, holder.getAdapterPosition());
        }
    }

    @Override
    public void onCheckViewClicked(CheckView checkView, Item item, RecyclerView.ViewHolder holder) {
        if (this.mSelectionSpec.countable) {
            int checkedNum = this.mSelectedCollection.checkedNumOf(item);
            if (checkedNum == Integer.MIN_VALUE) {
                if (this.assertAddSelection(holder.itemView.getContext(), item)) {
                    this.mSelectedCollection.add(item);
                    this.notifyCheckStateChanged();
                }
            } else {
                this.mSelectedCollection.remove(item);
                this.notifyCheckStateChanged();
            }
        } else if (this.mSelectedCollection.isSelected(item)) {
            this.mSelectedCollection.remove(item);
            this.notifyCheckStateChanged();
        } else if (this.assertAddSelection(holder.itemView.getContext(), item)) {
            this.mSelectedCollection.add(item);
            this.notifyCheckStateChanged();
        }
    }

    private void notifyCheckStateChanged() {
        this.notifyDataSetChanged();
        if (this.mCheckStateListener != null) {
            this.mCheckStateListener.onUpdate();
        }
    }

    @Override
    public int getItemViewType(int position, Cursor cursor) {
        return Item.valueOf(cursor).isCapture() ? 1 : 2;
    }

    private boolean assertAddSelection(Context context, Item item) {
        IncapableCause cause = this.mSelectedCollection.isAcceptable(item);
        IncapableCause.handleCause(context, cause);
        return cause == null;
    }

    public void registerCheckStateListener(CheckStateListener listener) {
        this.mCheckStateListener = listener;
    }

    public void unregisterCheckStateListener() {
        this.mCheckStateListener = null;
    }

    public void registerOnMediaClickListener(OnMediaClickListener listener) {
        this.mOnMediaClickListener = listener;
    }

    public void unregisterOnMediaClickListener() {
        this.mOnMediaClickListener = null;
    }

    public void refreshSelection() {
        GridLayoutManager layoutManager = (GridLayoutManager)this.mRecyclerView.getLayoutManager();
        int first = layoutManager.findFirstVisibleItemPosition();
        int last = layoutManager.findLastVisibleItemPosition();
        if (first == -1 || last == -1) {
            return;
        }
        Cursor cursor = this.getCursor();
        for (int i = first; i <= last; ++i) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.findViewHolderForAdapterPosition(first);
            if (!(holder instanceof MediaViewHolder) || !cursor.moveToPosition(i)) continue;
            this.setCheckStatus(Item.valueOf(cursor), ((MediaViewHolder)holder).mMediaGrid);
        }
    }

    private int getImageResize(Context context) {
        if (this.mImageResize == 0) {
            RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
            int spanCount = ((GridLayoutManager)lm).getSpanCount();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            int availableWidth = screenWidth - context.getResources().getDimensionPixelSize(R.dimen.media_grid_spacing) * (spanCount - 1);
            this.mImageResize = availableWidth / spanCount;
            this.mImageResize = (int)((float)this.mImageResize * this.mSelectionSpec.thumbnailScale);
        }
        return this.mImageResize;
    }

    private static class CaptureViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mHint;

        CaptureViewHolder(View itemView) {
            super(itemView);
            this.mHint = (TextView)itemView.findViewById(R.id.hint);
        }
    }

    private static class MediaViewHolder
    extends RecyclerView.ViewHolder {
        private MediaGrid mMediaGrid;

        MediaViewHolder(View itemView) {
            super(itemView);
            this.mMediaGrid = (MediaGrid)itemView;
        }
    }

    public static interface OnPhotoCapture {
        public void capture();
    }

    public static interface OnMediaClickListener {
        public void onMediaClick(Album var1, Item var2, int var3);
    }

    public static interface CheckStateListener {
        public void onUpdate();
    }
}

