/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.v4.content.res.ResourcesCompat;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import com.zhihu.matisse.R;

public class CheckView
extends View {
    public static final int UNCHECKED = Integer.MIN_VALUE;
    private static final float STROKE_WIDTH = 3.0f;
    private static final float SHADOW_WIDTH = 6.0f;
    private static final int SIZE = 48;
    private static final float STROKE_RADIUS = 11.5f;
    private static final float BG_RADIUS = 11.0f;
    private static final int CONTENT_SIZE = 16;
    private boolean mCountable;
    private boolean mChecked;
    private int mCheckedNum;
    private Paint mStrokePaint;
    private Paint mBackgroundPaint;
    private TextPaint mTextPaint;
    private Paint mShadowPaint;
    private Drawable mCheckDrawable;
    private float mDensity;
    private Rect mCheckRect;
    private boolean mEnabled = true;

    public CheckView(Context context) {
        super(context);
        this.init(context);
    }

    public CheckView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CheckView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int sizeSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(48.0f * this.mDensity)), (int)0x40000000);
        super.onMeasure(sizeSpec, sizeSpec);
    }

    private void init(Context context) {
        this.mDensity = context.getResources().getDisplayMetrics().density;
        this.mStrokePaint = new Paint();
        this.mStrokePaint.setAntiAlias(true);
        this.mStrokePaint.setStyle(Paint.Style.STROKE);
        this.mStrokePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        this.mStrokePaint.setStrokeWidth(3.0f * this.mDensity);
        TypedArray ta = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.item_checkCircle_borderColor});
        int defaultColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.zhihu_item_checkCircle_borderColor, (Resources.Theme)this.getContext().getTheme());
        int color2 = ta.getColor(0, defaultColor);
        ta.recycle();
        this.mStrokePaint.setColor(color2);
        this.mCheckDrawable = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.ic_check_white_18dp, (Resources.Theme)context.getTheme());
    }

    public void setChecked(boolean checked) {
        if (this.mCountable) {
            throw new IllegalStateException("CheckView is countable, call setCheckedNum() instead.");
        }
        this.mChecked = checked;
        this.invalidate();
    }

    public void setCountable(boolean countable) {
        this.mCountable = countable;
    }

    public void setCheckedNum(int checkedNum) {
        if (!this.mCountable) {
            throw new IllegalStateException("CheckView is not countable, call setChecked() instead.");
        }
        if (checkedNum != Integer.MIN_VALUE && checkedNum <= 0) {
            throw new IllegalArgumentException("checked num can't be negative.");
        }
        this.mCheckedNum = checkedNum;
        this.invalidate();
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled != enabled) {
            this.mEnabled = enabled;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.initShadowPaint();
        canvas.drawCircle(48.0f * this.mDensity / 2.0f, 48.0f * this.mDensity / 2.0f, 19.0f * this.mDensity, this.mShadowPaint);
        canvas.drawCircle(48.0f * this.mDensity / 2.0f, 48.0f * this.mDensity / 2.0f, 11.5f * this.mDensity, this.mStrokePaint);
        if (this.mCountable) {
            if (this.mCheckedNum != Integer.MIN_VALUE) {
                this.initBackgroundPaint();
                canvas.drawCircle(48.0f * this.mDensity / 2.0f, 48.0f * this.mDensity / 2.0f, 11.0f * this.mDensity, this.mBackgroundPaint);
                this.initTextPaint();
                String text = String.valueOf(this.mCheckedNum);
                int baseX = (int)((float)canvas.getWidth() - this.mTextPaint.measureText(text)) / 2;
                int baseY = (int)((float)canvas.getHeight() - this.mTextPaint.descent() - this.mTextPaint.ascent()) / 2;
                canvas.drawText(text, (float)baseX, (float)baseY, (Paint)this.mTextPaint);
            }
        } else if (this.mChecked) {
            this.initBackgroundPaint();
            canvas.drawCircle(48.0f * this.mDensity / 2.0f, 48.0f * this.mDensity / 2.0f, 11.0f * this.mDensity, this.mBackgroundPaint);
            this.mCheckDrawable.setBounds(this.getCheckRect());
            this.mCheckDrawable.draw(canvas);
        }
        this.setAlpha(this.mEnabled ? 1.0f : 0.5f);
    }

    private void initShadowPaint() {
        if (this.mShadowPaint == null) {
            this.mShadowPaint = new Paint();
            this.mShadowPaint.setAntiAlias(true);
            float outerRadius = 13.0f;
            float innerRadius = outerRadius - 3.0f;
            float gradientRadius = outerRadius + 6.0f;
            float stop0 = (innerRadius - 6.0f) / gradientRadius;
            float stop1 = innerRadius / gradientRadius;
            float stop2 = outerRadius / gradientRadius;
            float stop3 = 1.0f;
            this.mShadowPaint.setShader((Shader)new RadialGradient(48.0f * this.mDensity / 2.0f, 48.0f * this.mDensity / 2.0f, gradientRadius * this.mDensity, new int[]{Color.parseColor((String)"#00000000"), Color.parseColor((String)"#0D000000"), Color.parseColor((String)"#0D000000"), Color.parseColor((String)"#00000000")}, new float[]{stop0, stop1, stop2, stop3}, Shader.TileMode.CLAMP));
        }
    }

    private void initBackgroundPaint() {
        if (this.mBackgroundPaint == null) {
            this.mBackgroundPaint = new Paint();
            this.mBackgroundPaint.setAntiAlias(true);
            this.mBackgroundPaint.setStyle(Paint.Style.FILL);
            TypedArray ta = this.getContext().getTheme().obtainStyledAttributes(new int[]{R.attr.item_checkCircle_backgroundColor});
            int defaultColor = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.zhihu_item_checkCircle_backgroundColor, (Resources.Theme)this.getContext().getTheme());
            int color2 = ta.getColor(0, defaultColor);
            ta.recycle();
            this.mBackgroundPaint.setColor(color2);
        }
    }

    private void initTextPaint() {
        if (this.mTextPaint == null) {
            this.mTextPaint = new TextPaint();
            this.mTextPaint.setAntiAlias(true);
            this.mTextPaint.setColor(-1);
            this.mTextPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
            this.mTextPaint.setTextSize(12.0f * this.mDensity);
        }
    }

    private Rect getCheckRect() {
        if (this.mCheckRect == null) {
            int rectPadding = (int)(48.0f * this.mDensity / 2.0f - 16.0f * this.mDensity / 2.0f);
            this.mCheckRect = new Rect(rectPadding, rectPadding, (int)(48.0f * this.mDensity - (float)rectPadding), (int)(48.0f * this.mDensity - (float)rectPadding));
        }
        return this.mCheckRect;
    }
}

