/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.model;

import android.content.Context;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.loader.AlbumMediaLoader;
import java.lang.ref.WeakReference;

public class AlbumMediaCollection
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final int LOADER_ID = 2;
    private static final String ARGS_ALBUM = "args_album";
    private static final String ARGS_ENABLE_CAPTURE = "args_enable_capture";
    private WeakReference<Context> mContext;
    private LoaderManager mLoaderManager;
    private AlbumMediaCallbacks mCallbacks;

    public Loader<Cursor> onCreateLoader(int id, Bundle args) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return null;
        }
        Album album = (Album)args.getParcelable(ARGS_ALBUM);
        if (album == null) {
            return null;
        }
        return AlbumMediaLoader.newInstance(context, album, album.isAll() && args.getBoolean(ARGS_ENABLE_CAPTURE, false));
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        this.mCallbacks.onAlbumMediaLoad(data);
    }

    public void onLoaderReset(Loader<Cursor> loader) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        this.mCallbacks.onAlbumMediaReset();
    }

    public void onCreate(@NonNull FragmentActivity context, @NonNull AlbumMediaCallbacks callbacks) {
        this.mContext = new WeakReference<FragmentActivity>(context);
        this.mLoaderManager = context.getSupportLoaderManager();
        this.mCallbacks = callbacks;
    }

    public void onDestroy() {
        if (this.mLoaderManager != null) {
            this.mLoaderManager.destroyLoader(2);
        }
        this.mCallbacks = null;
    }

    public void load(@Nullable Album target) {
        this.load(target, false);
    }

    public void load(@Nullable Album target, boolean enableCapture) {
        Bundle args = new Bundle();
        args.putParcelable(ARGS_ALBUM, (Parcelable)target);
        args.putBoolean(ARGS_ENABLE_CAPTURE, enableCapture);
        this.mLoaderManager.initLoader(2, args, (LoaderManager.LoaderCallbacks)this);
    }

    public static interface AlbumMediaCallbacks {
        public void onAlbumMediaLoad(Cursor var1);

        public void onAlbumMediaReset();
    }
}

