/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.ui.adapter;

import android.database.Cursor;
import android.support.v7.widget.RecyclerView;

public abstract class RecyclerViewCursorAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private Cursor mCursor;
    private int mRowIDColumn;

    RecyclerViewCursorAdapter(Cursor c) {
        this.setHasStableIds(true);
        this.swapCursor(c);
    }

    protected abstract void onBindViewHolder(VH var1, Cursor var2);

    public void onBindViewHolder(VH holder, int position) {
        if (!this.isDataValid(this.mCursor)) {
            throw new IllegalStateException("Cannot bind view holder when cursor is in invalid state.");
        }
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("Could not move cursor to position " + position + " when trying to bind view holder");
        }
        this.onBindViewHolder(holder, this.mCursor);
    }

    public int getItemViewType(int position) {
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("Could not move cursor to position " + position + " when trying to get item view type.");
        }
        return this.getItemViewType(position, this.mCursor);
    }

    protected abstract int getItemViewType(int var1, Cursor var2);

    public int getItemCount() {
        if (this.isDataValid(this.mCursor)) {
            return this.mCursor.getCount();
        }
        return 0;
    }

    public long getItemId(int position) {
        if (!this.isDataValid(this.mCursor)) {
            throw new IllegalStateException("Cannot lookup item id when cursor is in invalid state.");
        }
        if (!this.mCursor.moveToPosition(position)) {
            throw new IllegalStateException("Could not move cursor to position " + position + " when trying to get an item id");
        }
        return this.mCursor.getLong(this.mRowIDColumn);
    }

    public void swapCursor(Cursor newCursor) {
        if (newCursor == this.mCursor) {
            return;
        }
        if (newCursor != null) {
            this.mCursor = newCursor;
            this.mRowIDColumn = this.mCursor.getColumnIndexOrThrow("_id");
            this.notifyDataSetChanged();
        } else {
            this.notifyItemRangeRemoved(0, this.getItemCount());
            this.mCursor = null;
            this.mRowIDColumn = -1;
        }
    }

    public Cursor getCursor() {
        return this.mCursor;
    }

    private boolean isDataValid(Cursor cursor) {
        return cursor != null && !cursor.isClosed();
    }
}

