/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.service.cache.CacheService;
import com.luues.openoffice.utils.DeleteFileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${cache.clean:false}'.equals('true')")
public class ShedulerClean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShedulerClean.class);
    @Autowired
    private CacheService cacheService;
    @Autowired
    private ConfigConstants configConstants;

    @Scheduled(cron="0 0 3 * * ?")
    public void clean() {
        LOGGER.info("Cache clean start");
        this.cacheService.cleanCache();
        DeleteFileUtil.deleteDirectory(this.configConstants.getFileDir());
        LOGGER.info("Cache clean end");
    }
}

