/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.google.common.collect.Lists;
import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.FileType;
import com.luues.openoffice.service.cache.CacheService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FileUtils {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CacheService cacheService;
    @Autowired
    private ConfigConstants configConstants;

    public Map<String, String> listConvertedFiles() {
        return this.cacheService.getPDFCache();
    }

    public String getConvertedFile(String key) {
        return this.cacheService.getPDFCache(key);
    }

    public Integer getConvertedPdfImage(String key) {
        return this.cacheService.getPdfImageCache(key);
    }

    public FileType typeFromUrl(String url) {
        String nonPramStr = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        return this.typeFromFileName(fileName);
    }

    private FileType typeFromFileName(String fileName) {
        String[] simText = this.configConstants.getSimText();
        String[] media = this.configConstants.getMedia();
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (this.listPictureTypes().contains(fileType.toLowerCase())) {
            return FileType.picture;
        }
        if (this.listArchiveTypes().contains(fileType.toLowerCase())) {
            return FileType.compress;
        }
        if (this.listOfficeTypes().contains(fileType.toLowerCase())) {
            return FileType.office;
        }
        if (Arrays.asList(simText).contains(fileType.toLowerCase())) {
            return FileType.simText;
        }
        if (Arrays.asList(media).contains(fileType.toLowerCase())) {
            return FileType.media;
        }
        if ("pdf".equalsIgnoreCase(fileType)) {
            return FileType.pdf;
        }
        return FileType.other;
    }

    public String getFileNameFromURL(String url) {
        String noQueryUrl = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = noQueryUrl.substring(noQueryUrl.lastIndexOf("/") + 1);
        return fileName;
    }

    public String getSuffixFromFileName(String fileName) {
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        return suffix;
    }

    public String getFileNameFromPath(String path) {
        return path.substring(path.lastIndexOf(File.separator) + 1);
    }

    public List<String> listPictureTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("jpg");
        list.add("jpeg");
        list.add("png");
        list.add("gif");
        list.add("bmp");
        list.add("ico");
        list.add("RAW");
        return list;
    }

    public List<String> listArchiveTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("rar");
        list.add("zip");
        list.add("jar");
        list.add("7-zip");
        list.add("tar");
        list.add("gzip");
        list.add("7z");
        return list;
    }

    public List<String> listOfficeTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("docx");
        list.add("doc");
        list.add("xls");
        list.add("xlsx");
        list.add("ppt");
        list.add("pptx");
        return list;
    }

    public String getRelativePath(String absolutePath) {
        return absolutePath.substring(this.configConstants.getFileDir().length());
    }

    public void addConvertedFile(String fileName, String value) {
        this.cacheService.putPDFCache(fileName, value);
    }

    public void addConvertedPdfImage(String pdfFilePath, int num) {
        this.cacheService.putPdfImageCache(pdfFilePath, num);
    }

    public List getRedisImgUrls(String fileKey) {
        return this.cacheService.getImgCache(fileKey);
    }

    public void setRedisImgUrls(String fileKey, List imgs) {
        this.cacheService.putImgCache(fileKey, imgs);
    }

    public String getEncode() {
        String enc = Charset.forName("UTF-8").name();
        this.log.info("\u6587\u4ef6\u7f16\u7801\u683c\u5f0f\u4e3a:{}", (Object)enc);
        return enc;
    }

    public String getFileEncodeUTFGBK(String path) {
        String enc = Charset.forName("GBK").name();
        File file = new File(path);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] b = new byte[3];
            ((InputStream)in).read(b);
            ((InputStream)in).close();
            if (b[0] == -17 && b[1] == -69 && b[2] == -65) {
                enc = Charset.forName("UTF-8").name();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.log.info("\u6587\u4ef6\u7f16\u7801\u683c\u5f0f\u4e3a:{}", (Object)enc);
        return enc;
    }

    public void doActionConvertedFile(String outFilePath) {
        Throwable throwable;
        Throwable throwable2;
        StringBuffer sb = new StringBuffer();
        String charset = this.configConstants.getConvertedFileCharset();
        try {
            throwable2 = null;
            try (FileInputStream inputStream = new FileInputStream(outFilePath);){
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, charset));){
                    String line;
                    while (null != (line = reader.readLine())) {
                        if (line.contains("charset=gb2312")) {
                            line = line.replace("charset=gb2312", "charset=utf-8");
                        }
                        sb.append(line);
                    }
                    sb.append("<script src=\"js/jquery-3.0.0.min.js\" type=\"text/javascript\"></script>");
                    sb.append("<script src=\"js/excel.header.js\" type=\"text/javascript\"></script>");
                    sb.append("<link rel=\"stylesheet\" href=\"http://cdn.static.runoob.com/libs/bootstrap/3.3.7/css/bootstrap.min.css\">");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable reader) {
                throwable2 = reader;
                throw reader;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            throwable2 = null;
            try (FileOutputStream fos = new FileOutputStream(outFilePath);){
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"));){
                    writer.write(sb.toString());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String suffixFromUrl(String url) {
        String nonPramStr = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        return this.suffixFromFileName(fileName);
    }

    private String suffixFromFileName(String fileName) {
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        return fileType;
    }

    public String getUrlParameterReg(String url, String name) {
        String[] arrSplit;
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String strUrlParam = this.truncateUrlPage(url);
        if (strUrlParam == null) {
            return "";
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if (arrSplitEqual[0].equals("")) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return (String)mapRequest.get(name);
    }

    private String truncateUrlPage(String strURL) {
        String strAllParam = null;
        strURL = strURL.trim();
        String[] arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1 && arrSplit[1] != null) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }

    public FileAttribute getFileAttribute(String url) {
        String suffix;
        FileType type;
        String fileName;
        String decodedUrl = null;
        try {
            decodedUrl = URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("url\u89e3\u7801\u5931\u8d25");
        }
        String fullFileName = this.getUrlParameterReg(decodedUrl, "fullfilename");
        if (!StringUtils.isEmpty((Object)fullFileName)) {
            fileName = fullFileName;
            type = this.typeFromFileName(fileName);
            suffix = this.suffixFromFileName(fileName);
        } else {
            fileName = this.getFileNameFromURL(decodedUrl);
            type = this.typeFromUrl(url);
            suffix = this.suffixFromUrl(url);
        }
        return new FileAttribute(type, suffix, fileName, url, decodedUrl);
    }
}

