/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.utils.FileCharsetDetector;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.FtpUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DownloadUtils {
    private final Logger LOGGER = LoggerFactory.getLogger(DownloadUtils.class);
    @Autowired
    private ConfigConstants configConstants;
    @Autowired
    private FileUtils fileUtils;
    @Autowired
    private FtpUtils ftpUtils;
    private final String URL_PARAM_FTP_USERNAME = "ftp.username";
    private final String URL_PARAM_FTP_PASSWORD = "ftp.password";
    private final String URL_PARAM_FTP_CONTROL_ENCODING = "ftp.control.encoding";

    public ReturnResponse<String> downLoad(FileAttribute fileAttribute, String fileName) {
        String urlAddress = fileAttribute.getDecodedUrl();
        String type = fileAttribute.getSuffix();
        ReturnResponse<String> response = new ReturnResponse<String>(0, "\u4e0b\u8f7d\u6210\u529f!!!", "");
        URL url = null;
        try {
            urlAddress = this.replacePlusMark(urlAddress);
            urlAddress = this.encodeUrlParam(urlAddress);
            urlAddress = urlAddress.replaceAll("\\+", "%20");
            url = new URL(urlAddress);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        UUID uuid = UUID.randomUUID();
        fileName = null == fileName ? uuid + "." + type : fileName.replace(fileName.substring(fileName.lastIndexOf(".") + 1), type);
        String realPath = this.configConstants.getFileDir() + fileName;
        if (new File(realPath).exists()) {
            response.setContent(realPath);
            response.setMsg(fileName);
            if ("txt".equals(type)) {
                try {
                    DownloadUtils.convertTextPlainFileCharsetToUtf8(realPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return response;
        }
        File dirFile = new File(this.configConstants.getFileDir());
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        try {
            if ("ftp".equals(url.getProtocol())) {
                String ftpUsername = this.fileUtils.getUrlParameterReg(fileAttribute.getUrl(), "ftp.username");
                String ftpPassword = this.fileUtils.getUrlParameterReg(fileAttribute.getUrl(), "ftp.password");
                String ftpControlEncoding = this.fileUtils.getUrlParameterReg(fileAttribute.getUrl(), "ftp.control.encoding");
                this.ftpUtils.download(fileAttribute.getUrl(), realPath, ftpUsername, ftpPassword, ftpControlEncoding);
            } else {
                int read;
                URLConnection connection = url.openConnection();
                InputStream in = connection.getInputStream();
                FileOutputStream os = new FileOutputStream(realPath);
                byte[] buffer = new byte[4096];
                while ((read = in.read(buffer)) > 0) {
                    os.write(buffer, 0, read);
                }
                os.close();
                in.close();
            }
            response.setContent(realPath);
            response.setMsg(fileName);
            if ("txt".equals(type)) {
                DownloadUtils.convertTextPlainFileCharsetToUtf8(realPath);
            }
            return response;
        }
        catch (IOException e) {
            this.LOGGER.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
            response.setCode(1);
            response.setContent(null);
            if (e instanceof FileNotFoundException) {
                response.setMsg("\u6587\u4ef6\u4e0d\u5b58\u5728!!!");
            } else {
                response.setMsg(e.getMessage());
            }
            return response;
        }
    }

    private String replacePlusMark(String urlAddress) {
        if (urlAddress.contains("?")) {
            String nonParamStr = urlAddress.substring(0, urlAddress.indexOf("?") + 1);
            String paramStr = urlAddress.substring(nonParamStr.length());
            return nonParamStr + paramStr.replace(" ", "+");
        }
        return urlAddress;
    }

    private String encodeUrlParam(String urlAddress) {
        String newUrl = "";
        try {
            String path = "";
            String param = "";
            if (urlAddress.contains("?")) {
                path = urlAddress.substring(0, urlAddress.indexOf("?"));
                param = urlAddress.substring(urlAddress.indexOf("?"));
            } else {
                path = urlAddress;
            }
            String lastPath = path.substring(path.lastIndexOf("/") + 1);
            String leftPath = path.substring(0, path.lastIndexOf("/") + 1);
            String encodeLastPath = URLEncoder.encode(lastPath, "UTF-8");
            newUrl = newUrl + leftPath + encodeLastPath;
            if (urlAddress.contains("?")) {
                newUrl = newUrl + param;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return newUrl;
    }

    private String dealWithMS2013(String type) {
        String newType = null;
        switch (type) {
            case "docx": {
                newType = "doc";
                break;
            }
            case "xlsx": {
                newType = "doc";
                break;
            }
            case "pptx": {
                newType = "ppt";
                break;
            }
            default: {
                newType = type;
            }
        }
        return newType;
    }

    private static void convertTextPlainFileCharsetToUtf8(String filePath) throws IOException {
        File sourceFile = new File(filePath);
        if (sourceFile.exists() && sourceFile.isFile() && sourceFile.canRead()) {
            String encoding = null;
            try {
                FileCharsetDetector.Observer observer = FileCharsetDetector.guessFileEncoding(sourceFile);
                encoding = observer.isFound() ? observer.getEncoding() : null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (encoding != null && !"UTF-8".equals(encoding)) {
                int read;
                File tmpUtf8File = new File(filePath + ".utf8");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmpUtf8File), "UTF-8");
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), encoding));
                char[] buf = new char[1024];
                while ((read = reader.read(buf)) > 0) {
                    ((Writer)writer).write(buf, 0, read);
                }
                ((Reader)reader).close();
                ((Writer)writer).close();
                sourceFile.delete();
                tmpUtf8File.renameTo(sourceFile);
            }
        }
    }
}

