/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.DownloadUtils;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.OfficeToPdf;
import com.luues.openoffice.utils.PdfUtils;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OfficeFilePreviewImpl
implements FilePreview {
    @Autowired
    FileUtils fileUtils;
    @Autowired
    PdfUtils pdfUtils;
    @Autowired
    DownloadUtils downloadUtils;
    @Autowired
    private OfficeToPdf officeToPdf;
    @Autowired
    private ConfigConstants configConstants;
    public static final String OFFICE_PREVIEW_TYPE_PDF = "pdf";
    public static final String OFFICE_PREVIEW_TYPE_IMAGE = "image";
    public static final String OFFICE_PREVIEW_TYPE_ALLIMAGES = "allImages";

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String officePreviewType = this.configConstants.getOfficePreviewType();
        String originUrl = fileAttribute.getUrl();
        String suffix = fileAttribute.getSuffix();
        String fileName = fileAttribute.getName();
        boolean isHtml = suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx");
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + (isHtml ? "html" : OFFICE_PREVIEW_TYPE_PDF);
        String outFilePath = this.configConstants.getFileDir() + pdfName;
        if (!this.fileUtils.listConvertedFiles().containsKey(pdfName)) {
            String filePath = this.configConstants.getFileDir() + fileName;
            if (!new File(filePath).exists()) {
                ReturnResponse<String> response = this.downloadUtils.downLoad(fileAttribute, null);
                if (0 != response.getCode()) {
                    jsonObject.put("fileType", (Object)suffix);
                    jsonObject.put("msg", (Object)response.getMsg());
                    jsonObject.put("path", (Object)"fileNotSupported");
                    return jsonObject;
                }
                filePath = response.getContent();
            }
            if (StringUtils.hasText((String)outFilePath)) {
                this.officeToPdf.openOfficeToPDF(filePath, outFilePath);
                File f = new File(filePath);
                if (f.exists()) {
                    f.delete();
                }
                if (isHtml) {
                    this.fileUtils.doActionConvertedFile(outFilePath);
                }
                this.fileUtils.addConvertedFile(pdfName, this.fileUtils.getRelativePath(outFilePath));
            }
        }
        if (!isHtml && originUrl != null && (OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType) || OFFICE_PREVIEW_TYPE_ALLIMAGES.equals(officePreviewType))) {
            List<String> imageUrls = this.pdfUtils.pdf2jpg(outFilePath, pdfName, originUrl);
            if (imageUrls == null || imageUrls.size() < 1) {
                jsonObject.put("msg", (Object)"office\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                jsonObject.put("fileType", (Object)fileAttribute.getSuffix());
                jsonObject.put("path", (Object)"fileNotSupported");
                return jsonObject;
            }
            jsonObject.put("imgurls", imageUrls);
            jsonObject.put("currentUrl", (Object)imageUrls.get(0));
            if (OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType)) {
                jsonObject.put("path", (Object)"officePicture");
            } else {
                jsonObject.put("path", (Object)"picture");
            }
            return jsonObject;
        }
        jsonObject.put("pdfUrl", (Object)pdfName);
        if (isHtml) {
            jsonObject.put("path", (Object)"html");
        } else {
            jsonObject.put("path", (Object)OFFICE_PREVIEW_TYPE_PDF);
        }
        return jsonObject;
    }
}

