/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.service.cache.impl;

import com.luues.openoffice.service.cache.CacheService;
import java.util.List;
import java.util.Map;
import org.redisson.Redisson;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@ConditionalOnExpression(value="'${cache.type:default}'.equals('redis')")
@Service
public class CacheServiceRedisImpl
implements CacheService {
    private Config config;
    private static final String cache_key = "commons-openoffice-1.0:";
    private RedissonClient redissonClient;

    @Autowired
    public CacheServiceRedisImpl(Config config) {
        this.config = config;
        this.redissonClient = Redisson.create((Config)config);
    }

    @Override
    public void initPDFCachePool(Integer capacity) {
    }

    @Override
    public void initIMGCachePool(Integer capacity) {
    }

    @Override
    public void initPdfImagesCachePool(Integer capacity) {
    }

    @Override
    public void putPDFCache(String key, String value) {
        RMapCache convertedList = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdf-file");
        convertedList.fastPut((Object)key, (Object)value);
    }

    @Override
    public void putImgCache(String key, List<String> value) {
        RMapCache convertedList = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-imgs-file");
        convertedList.fastPut((Object)key, value);
    }

    @Override
    public Map<String, String> getPDFCache() {
        return this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdf-file");
    }

    @Override
    public String getPDFCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdf-file");
        return (String)convertedList.get((Object)key);
    }

    @Override
    public Map<String, List<String>> getImgCache() {
        return this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-imgs-file");
    }

    @Override
    public List<String> getImgCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-imgs-file");
        return (List)convertedList.get((Object)key);
    }

    @Override
    public Integer getPdfImageCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdfimgs-file");
        return (Integer)convertedList.get((Object)key);
    }

    @Override
    public void putPdfImageCache(String pdfFilePath, int num) {
        RMapCache convertedList = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdfimgs-file");
        convertedList.fastPut((Object)pdfFilePath, (Object)num);
    }

    @Override
    public void cleanCache() {
        this.cleanPdfCache();
        this.cleanImgCache();
        this.cleanPdfImgCache();
    }

    @Override
    public void addQueueTask(String url) {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue("FileConverQueueTask");
        queue.addAsync((Object)url);
    }

    @Override
    public String takeQueueTask() throws InterruptedException {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue("FileConverQueueTask");
        return (String)queue.take();
    }

    private void cleanPdfCache() {
        RMapCache pdfCache = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdf-file");
        pdfCache.clear();
    }

    private void cleanImgCache() {
        RMapCache imgCache = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-imgs-file");
        imgCache.clear();
    }

    private void cleanPdfImgCache() {
        RMapCache pdfImg = this.redissonClient.getMapCache("commons-openoffice-1.0:converted-preview-pdfimgs-file");
        pdfImg.clear();
    }
}

