/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core.office;

import com.luues.openoffice.config.ApplicationData;
import com.luues.openoffice.core.util.PlatformUtils;
import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfficeUtils {
    private static boolean flag = true;
    private static boolean flags = true;
    private static final String jar_name = "commons-openoffice.jar";
    private static final String bacapp_name = "application-bac.properties";
    private static final Logger logger = LoggerFactory.getLogger(OfficeUtils.class);
    public static final String SERVICE_DESKTOP = "com.sun.star.frame.Desktop";
    @Autowired
    private ApplicationData applicationData;

    public static <T> T cast(Class<T> type, Object object) {
        return (T)UnoRuntime.queryInterface(type, (Object)object);
    }

    public static PropertyValue property(String name, Object value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = name;
        propertyValue.Value = value;
        return propertyValue;
    }

    public static PropertyValue[] toUnoProperties(Map<String, ?> properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map subProperties = (Map)value;
                value = OfficeUtils.toUnoProperties(subProperties);
            }
            propertyValues[i++] = OfficeUtils.property(entry.getKey(), value);
        }
        return propertyValues;
    }

    public static String toUrl(File file) {
        String path = file.toURI().getRawPath();
        String url = path.startsWith("//") ? "file:" + path : "file://" + path;
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public File getDefaultOfficeHome() {
        if (null != this.applicationData.getOfficeHome() && !"null".equals(this.applicationData.getOfficeHome())) {
            return new File(this.applicationData.getOfficeHome());
        }
        if (PlatformUtils.isWindows()) {
            String programFiles = System.getenv("ProgramFiles(x86)");
            if (programFiles == null) {
                programFiles = System.getenv("ProgramFiles");
            }
            return OfficeUtils.findOfficeHome(programFiles + File.separator + "OpenOffice 4", programFiles + File.separator + "LibreOffice 4", "");
        }
        if (PlatformUtils.isMac()) {
            return OfficeUtils.findOfficeHome("/Applications/OpenOffice.org.app/Contents", "/Applications/OpenOffice.app/Contents", "/Applications/LibreOffice.app/Contents");
        }
        return OfficeUtils.findOfficeHome("/opt/openoffice.org3", "/opt/openoffice", "/opt/libreoffice", "/opt/openoffice4", "/usr/lib/openoffice", "/usr/lib/libreoffice");
    }

    private static File findOfficeHome(String ... knownPaths) {
        for (String path : knownPaths) {
            File home = new File(path);
            if (!OfficeUtils.getOfficeExecutable(home).isFile()) continue;
            return home;
        }
        logger.error("\u542f\u52a8openoffice\u5931\u8d25, \u8bf7\u5148\u5b89\u88c5openoffice, \u5982\u5df2\u5b89\u88c5\uff0c\u8bf7\u6dfb\u52a0\u914d\u7f6e:{}", (Object)"office.home=");
        return null;
    }

    public static File getOfficeExecutable(File officeHome) {
        if (PlatformUtils.isMac()) {
            return new File(officeHome, "MacOS/soffice.bin");
        }
        return new File(officeHome, "program/soffice.bin");
    }

    private static void createTmp(Enumeration<JarEntry> entries, String tmp_path, String jarPath) throws IOException {
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.getName().startsWith("office/")) {
                if (jarEntry.isDirectory()) {
                    File file_ = new File(tmp_path + File.separator + jarEntry.getName());
                    if (!file_.exists()) {
                        file_.mkdirs();
                    }
                } else {
                    File file2 = new File(tmp_path + File.separator + "office" + File.separator + jarEntry.getName().split("office/")[1]);
                    URL url1 = new URL("jar:file:" + jarPath + "!/office/" + jarEntry.getName().split("office/")[1]);
                    Files.copy(url1.openStream(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            if (!jarEntry.getName().equals("application.properties")) continue;
            URL url1 = new URL("jar:file:" + jarPath + "!/" + jarEntry.getName());
            File file2 = new File(tmp_path + File.separator + jarEntry.getName());
            Files.copy(url1.openStream(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void duplicateRemoval(String file) throws IOException {
        String str;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        while ((str = bufferedReader.readLine()) != null) {
            stringBuffer.append(str + "\n");
        }
        bufferedReader.close();
        StringBuffer add = new StringBuffer("\n");
        StringBuffer newStr = new StringBuffer();
        String content = stringBuffer.toString();
        for (String string : content.split("\n")) {
            if (string.length() == 0) {
                newStr.append("\n");
                continue;
            }
            int count = (content.length() - content.replace(string, "").length()) / string.length();
            if (count > 1) {
                boolean f = true;
                for (String s : add.toString().split("\n")) {
                    if (!s.equals(string)) continue;
                    f = false;
                }
                if (!f) continue;
                add.append(string + "\n");
                newStr.append(string + "\n");
                continue;
            }
            newStr.append(string + "\n");
        }
        File file1 = new File(new File(file).getParent() + File.separator + bacapp_name);
        BufferedWriter out = new BufferedWriter(new FileWriter(file1.getPath()));
        out.write(newStr.toString());
        out.close();
        new File(file).delete();
        file1.renameTo(new File(file1.getParent() + File.separator + "application.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeFiles(String outFile, String[] files) {
        FileChannel outChannel = null;
        try {
            outChannel = new FileOutputStream(outFile).getChannel();
            for (String file : files) {
                FileChannel fc = new FileInputStream(file).getChannel();
                ByteBuffer bb = ByteBuffer.allocate(1024);
                while (fc.read(bb) != -1) {
                    bb.flip();
                    outChannel.write(bb);
                    bb.clear();
                }
                fc.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

