/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core.office;

import com.luues.openoffice.core.office.OfficeConnection;
import com.luues.openoffice.core.office.OfficeException;
import com.luues.openoffice.core.office.OfficeManager;
import com.luues.openoffice.core.office.OfficeTask;
import com.luues.openoffice.core.office.UnoUrl;
import java.net.ConnectException;

class ExternalOfficeManager
implements OfficeManager {
    private final OfficeConnection connection;
    private final boolean connectOnStart;

    public ExternalOfficeManager(UnoUrl unoUrl, boolean connectOnStart) {
        this.connection = new OfficeConnection(unoUrl);
        this.connectOnStart = connectOnStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws OfficeException {
        if (this.connectOnStart) {
            OfficeConnection officeConnection = this.connection;
            synchronized (officeConnection) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (this.connection.isConnected()) {
                this.connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(OfficeTask task) throws OfficeException {
        OfficeConnection officeConnection = this.connection;
        synchronized (officeConnection) {
            if (!this.connection.isConnected()) {
                this.connect();
            }
            task.execute(this.connection);
        }
    }

    private void connect() {
        try {
            this.connection.connect();
        }
        catch (ConnectException connectException) {
            throw new OfficeException("could not connect to external office process", connectException);
        }
    }

    @Override
    public boolean isRunning() {
        return this.connection.isConnected();
    }
}

