/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionParameters;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionedRecyclerViewAdapter;

public abstract class Section {
    private State state = State.LOADED;
    boolean visible = true;
    boolean hasHeader = false;
    boolean hasFooter = false;
    @LayoutRes
    Integer headerResourceId;
    @LayoutRes
    Integer footerResourceId;
    @LayoutRes
    int itemResourceId;
    @LayoutRes
    private Integer loadingResourceId;
    @LayoutRes
    private Integer failedResourceId;
    @LayoutRes
    private Integer emptyResourceId;

    @Deprecated
    public Section(@LayoutRes int itemResourceId, @LayoutRes int loadingResourceId, @LayoutRes int failedResourceId) {
        this(new SectionParameters.Builder(itemResourceId).loadingResourceId(loadingResourceId).failedResourceId(failedResourceId).build());
    }

    @Deprecated
    public Section(@LayoutRes int headerResourceId, @LayoutRes int itemResourceId, @LayoutRes int loadingResourceId, @LayoutRes int failedResourceId) {
        this(new SectionParameters.Builder(itemResourceId).headerResourceId(headerResourceId).loadingResourceId(loadingResourceId).failedResourceId(failedResourceId).build());
    }

    @Deprecated
    public Section(@LayoutRes int headerResourceId, @LayoutRes int footerResourceId, @LayoutRes int itemResourceId, @LayoutRes int loadingResourceId, @LayoutRes int failedResourceId) {
        this(new SectionParameters.Builder(itemResourceId).headerResourceId(headerResourceId).footerResourceId(footerResourceId).loadingResourceId(loadingResourceId).failedResourceId(failedResourceId).build());
    }

    public Section(SectionParameters sectionParameters) {
        this.headerResourceId = sectionParameters.headerResourceId;
        this.footerResourceId = sectionParameters.footerResourceId;
        this.itemResourceId = sectionParameters.itemResourceId;
        this.loadingResourceId = sectionParameters.loadingResourceId;
        this.failedResourceId = sectionParameters.failedResourceId;
        this.hasHeader = this.headerResourceId != null;
        this.hasFooter = this.footerResourceId != null;
    }

    public final void setState(State state) {
        this.state = state;
    }

    public final State getState() {
        return this.state;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean hasHeader() {
        return this.hasHeader;
    }

    public final void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public final boolean hasFooter() {
        return this.hasFooter;
    }

    public final void setHasFooter(boolean hasFooter) {
        this.hasFooter = hasFooter;
    }

    public final Integer getHeaderResourceId() {
        return this.headerResourceId;
    }

    public final Integer getFooterResourceId() {
        return this.footerResourceId;
    }

    public final int getItemResourceId() {
        return this.itemResourceId;
    }

    public final Integer getLoadingResourceId() {
        return this.loadingResourceId;
    }

    public final Integer getFailedResourceId() {
        return this.failedResourceId;
    }

    public final Integer getEmptyResourceId() {
        return this.emptyResourceId;
    }

    public final void onBindContentViewHolder(RecyclerView.ViewHolder holder, int position) {
        switch (this.state) {
            case LOADING: {
                this.onBindLoadingViewHolder(holder);
                break;
            }
            case LOADED: {
                this.onBindItemViewHolder(holder, position);
                break;
            }
            case FAILED: {
                this.onBindFailedViewHolder(holder);
                break;
            }
            case EMPTY: {
                this.onBindEmptyViewHolder(holder);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
    }

    public final int getSectionItemsTotal() {
        int contentItemsTotal;
        switch (this.state) {
            case LOADING: {
                contentItemsTotal = 1;
                break;
            }
            case LOADED: {
                contentItemsTotal = this.getContentItemsTotal();
                break;
            }
            case FAILED: {
                contentItemsTotal = 1;
                break;
            }
            case EMPTY: {
                contentItemsTotal = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
        return contentItemsTotal + (this.hasHeader ? 1 : 0) + (this.hasFooter ? 1 : 0);
    }

    public abstract int getContentItemsTotal();

    public RecyclerView.ViewHolder getHeaderViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindHeaderViewHolder(RecyclerView.ViewHolder holder) {
    }

    public RecyclerView.ViewHolder getFooterViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindFooterViewHolder(RecyclerView.ViewHolder holder) {
    }

    public abstract RecyclerView.ViewHolder getItemViewHolder(View var1);

    public abstract void onBindItemViewHolder(RecyclerView.ViewHolder var1, int var2);

    public RecyclerView.ViewHolder getLoadingViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindLoadingViewHolder(RecyclerView.ViewHolder holder) {
    }

    public RecyclerView.ViewHolder getFailedViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindFailedViewHolder(RecyclerView.ViewHolder holder) {
    }

    public RecyclerView.ViewHolder getEmptyViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindEmptyViewHolder(RecyclerView.ViewHolder holder) {
    }

    public static enum State {
        LOADING,
        LOADED,
        FAILED,
        EMPTY;

    }
}

