/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.github.luizgrp.sectionedrecyclerviewadapter.Section;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class SectionedRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private LinkedHashMap<String, Section> sections = new LinkedHashMap();
    private HashMap<String, Integer> sectionViewTypeNumbers = new HashMap();
    private int viewTypeCount = 0;
    private static final int VIEW_TYPE_QTY = 5;

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder = null;
        View view = null;
        block7: for (Map.Entry<String, Integer> entry : this.sectionViewTypeNumbers.entrySet()) {
            if (viewType < entry.getValue() || viewType >= entry.getValue() + 5) continue;
            Section section = this.sections.get(entry.getKey());
            int sectionViewType = viewType - entry.getValue();
            switch (sectionViewType) {
                case 0: {
                    Integer resId = section.getHeaderResourceId();
                    if (resId == null) {
                        throw new NullPointerException("Missing 'header' resource id");
                    }
                    view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
                    viewHolder = section.getHeaderViewHolder(view);
                    continue block7;
                }
                case 1: {
                    Integer resId = section.getFooterResourceId();
                    if (resId == null) {
                        throw new NullPointerException("Missing 'footer' resource id");
                    }
                    view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
                    viewHolder = section.getFooterViewHolder(view);
                    continue block7;
                }
                case 2: {
                    view = LayoutInflater.from((Context)parent.getContext()).inflate(section.getItemResourceId(), parent, false);
                    viewHolder = section.getItemViewHolder(view);
                    continue block7;
                }
                case 3: {
                    Integer resId = section.getLoadingResourceId();
                    if (resId == null) {
                        throw new NullPointerException("Missing 'loading state' resource id");
                    }
                    view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
                    viewHolder = section.getLoadingViewHolder(view);
                    continue block7;
                }
                case 4: {
                    Integer resId = section.getFailedResourceId();
                    if (resId == null) {
                        throw new NullPointerException("Missing 'failed state' resource id");
                    }
                    view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
                    viewHolder = section.getFailedViewHolder(view);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Invalid viewType");
        }
        return viewHolder;
    }

    public void addSection(String tag, Section section) {
        this.sections.put(tag, section);
        this.sectionViewTypeNumbers.put(tag, this.viewTypeCount);
        this.viewTypeCount += 5;
    }

    public String addSection(Section section) {
        String tag = UUID.randomUUID().toString();
        this.addSection(tag, section);
        return tag;
    }

    public Section getSection(String tag) {
        return this.sections.get(tag);
    }

    public void removeSection(String tag) {
        this.sections.remove(tag);
    }

    public void removeAllSections() {
        this.sections.clear();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                if (section.hasHeader() && position == currentPos) {
                    this.getSectionForPosition(position).onBindHeaderViewHolder(holder);
                    return;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    this.getSectionForPosition(position).onBindFooterViewHolder(holder);
                    return;
                }
                this.getSectionForPosition(position).onBindContentViewHolder(holder, this.getSectionPosition(position));
                return;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getItemCount() {
        int count = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            count += section.getSectionItemsTotal();
        }
        return count;
    }

    public int getItemViewType(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                int viewType = this.sectionViewTypeNumbers.get(entry.getKey());
                if (section.hasHeader() && position == currentPos) {
                    return viewType;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    return viewType + 1;
                }
                switch (section.getState()) {
                    case LOADED: {
                        return viewType + 2;
                    }
                    case LOADING: {
                        return viewType + 3;
                    }
                    case FAILED: {
                        return viewType + 4;
                    }
                }
                throw new IllegalStateException("Invalid state");
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    Section getSectionForPosition(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return section;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    int getSectionPosition(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return position - currentPos - (section.hasHeader() ? 1 : 0);
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public static class EmptyViewHolder
    extends RecyclerView.ViewHolder {
        public EmptyViewHolder(View itemView) {
            super(itemView);
        }
    }
}

