/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionedRecyclerViewAdapter;

public abstract class Section {
    private State state = State.LOADED;
    boolean visible = true;
    boolean hasHeader = false;
    boolean hasFooter = false;
    Integer headerResourceId;
    Integer footerResourceId;
    int itemResourceId;
    private Integer loadingResourceId;
    private Integer failedResourceId;

    Section() {
    }

    public Section(int itemResourceId, int loadingResourceId, int failedResourceId) {
        this.itemResourceId = itemResourceId;
        this.loadingResourceId = loadingResourceId;
        this.failedResourceId = failedResourceId;
    }

    public Section(int headerResourceId, int itemResourceId, int loadingResourceId, int failedResourceId) {
        this(itemResourceId, loadingResourceId, failedResourceId);
        this.headerResourceId = headerResourceId;
        this.hasHeader = true;
    }

    public Section(int headerResourceId, int footerResourceId, int itemResourceId, int loadingResourceId, int failedResourceId) {
        this(headerResourceId, itemResourceId, loadingResourceId, failedResourceId);
        this.footerResourceId = footerResourceId;
        this.hasFooter = true;
    }

    public final void setState(State state) {
        this.state = state;
    }

    public final State getState() {
        return this.state;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    public final boolean hasHeader() {
        return this.hasHeader;
    }

    public final void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public final boolean hasFooter() {
        return this.hasFooter;
    }

    public final void setHasFooter(boolean hasFooter) {
        this.hasFooter = hasFooter;
    }

    public final Integer getHeaderResourceId() {
        return this.headerResourceId;
    }

    public final Integer getFooterResourceId() {
        return this.footerResourceId;
    }

    public final int getItemResourceId() {
        return this.itemResourceId;
    }

    public final Integer getLoadingResourceId() {
        return this.loadingResourceId;
    }

    public final Integer getFailedResourceId() {
        return this.failedResourceId;
    }

    public final void onBindContentViewHolder(RecyclerView.ViewHolder holder, int position) {
        switch (this.state) {
            case LOADING: {
                this.onBindLoadingViewHolder(holder);
                break;
            }
            case LOADED: {
                this.onBindItemViewHolder(holder, position);
                break;
            }
            case FAILED: {
                this.onBindFailedViewHolder(holder);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
    }

    public final int getSectionItemsTotal() {
        int contentItemsTotal = 0;
        switch (this.state) {
            case LOADING: {
                ++contentItemsTotal;
                break;
            }
            case LOADED: {
                contentItemsTotal += this.getContentItemsTotal();
                break;
            }
            case FAILED: {
                ++contentItemsTotal;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
        return contentItemsTotal + (this.hasHeader ? 1 : 0) + (this.hasFooter ? 1 : 0);
    }

    public abstract int getContentItemsTotal();

    public RecyclerView.ViewHolder getHeaderViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindHeaderViewHolder(RecyclerView.ViewHolder holder) {
    }

    public RecyclerView.ViewHolder getFooterViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindFooterViewHolder(RecyclerView.ViewHolder holder) {
    }

    public abstract RecyclerView.ViewHolder getItemViewHolder(View var1);

    public abstract void onBindItemViewHolder(RecyclerView.ViewHolder var1, int var2);

    public RecyclerView.ViewHolder getLoadingViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindLoadingViewHolder(RecyclerView.ViewHolder holder) {
    }

    public RecyclerView.ViewHolder getFailedViewHolder(View view) {
        return new SectionedRecyclerViewAdapter.EmptyViewHolder(view);
    }

    public void onBindFailedViewHolder(RecyclerView.ViewHolder holder) {
    }

    public static enum State {
        LOADING,
        LOADED,
        FAILED;

    }
}

