/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.frescoimageviewer;

import android.content.Context;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.stfalcon.frescoimageviewer.AnimationUtils;
import com.stfalcon.frescoimageviewer.ImageViewer;
import com.stfalcon.frescoimageviewer.ImageViewerAdapter;
import com.stfalcon.frescoimageviewer.MultiTouchViewPager;
import com.stfalcon.frescoimageviewer.OnDismissListener;
import com.stfalcon.frescoimageviewer.R;
import com.stfalcon.frescoimageviewer.SwipeDirectionDetector;
import com.stfalcon.frescoimageviewer.SwipeToDismissListener;

class ImageViewerView
extends RelativeLayout
implements OnDismissListener,
SwipeToDismissListener.OnViewMoveListener {
    private View backgroundView;
    private MultiTouchViewPager pager;
    private ImageViewerAdapter adapter;
    private SwipeDirectionDetector directionDetector;
    private ScaleGestureDetector scaleDetector;
    private ViewPager.OnPageChangeListener pageChangeListener;
    private GestureDetectorCompat gestureDetector;
    private ViewGroup dismissContainer;
    private SwipeToDismissListener swipeDismissListener;
    private View overlayView;
    private SwipeDirectionDetector.Direction direction;
    private ImageRequestBuilder customImageRequestBuilder;
    private GenericDraweeHierarchyBuilder customDraweeHierarchyBuilder;
    private PipelineDraweeControllerBuilder customDraweeControllerBuilder;
    private boolean wasScaled;
    private OnDismissListener onDismissListener;
    private boolean isOverlayWasClicked;
    private boolean isZoomingAllowed = true;
    private boolean isSwipeToDismissAllowed = true;

    public ImageViewerView(Context context) {
        super(context);
        this.init();
    }

    public ImageViewerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ImageViewerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setUrls(ImageViewer.DataSet<?> dataSet, int startPosition) {
        this.adapter = new ImageViewerAdapter(this.getContext(), dataSet, this.customImageRequestBuilder, this.customDraweeHierarchyBuilder, this.customDraweeControllerBuilder, this.isZoomingAllowed);
        this.pager.setAdapter(this.adapter);
        this.setStartPosition(startPosition);
    }

    public void setCustomImageRequestBuilder(ImageRequestBuilder customImageRequestBuilder) {
        this.customImageRequestBuilder = customImageRequestBuilder;
    }

    public void setCustomDraweeHierarchyBuilder(GenericDraweeHierarchyBuilder customDraweeHierarchyBuilder) {
        this.customDraweeHierarchyBuilder = customDraweeHierarchyBuilder;
    }

    public void setCustomDraweeControllerBuilder(PipelineDraweeControllerBuilder customDraweeControllerBuilder) {
        this.customDraweeControllerBuilder = customDraweeControllerBuilder;
    }

    public void setBackgroundColor(int color) {
        this.findViewById(R.id.backgroundView).setBackgroundColor(color);
    }

    public void setOverlayView(View view) {
        this.overlayView = view;
        if (this.overlayView != null) {
            this.dismissContainer.addView(view);
        }
    }

    public void allowZooming(boolean allowZooming) {
        this.isZoomingAllowed = allowZooming;
    }

    public void allowSwipeToDismiss(boolean allowSwipeToDismiss) {
        this.isSwipeToDismissAllowed = allowSwipeToDismiss;
    }

    public void setImageMargin(int marginPixels) {
        this.pager.setPageMargin(marginPixels);
    }

    public void setContainerPadding(int[] paddingPixels) {
        this.pager.setPadding(paddingPixels[0], paddingPixels[1], paddingPixels[2], paddingPixels[3]);
    }

    private void init() {
        ImageViewerView.inflate((Context)this.getContext(), (int)R.layout.image_viewer, (ViewGroup)this);
        this.backgroundView = this.findViewById(R.id.backgroundView);
        this.pager = (MultiTouchViewPager)this.findViewById(R.id.pager);
        this.dismissContainer = (ViewGroup)this.findViewById(R.id.container);
        this.swipeDismissListener = new SwipeToDismissListener(this.findViewById(R.id.dismissView), this, this);
        this.dismissContainer.setOnTouchListener((View.OnTouchListener)this.swipeDismissListener);
        this.directionDetector = new SwipeDirectionDetector(this.getContext()){

            @Override
            public void onDirectionDetected(SwipeDirectionDetector.Direction direction) {
                ImageViewerView.this.direction = direction;
            }
        };
        this.scaleDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener());
        this.gestureDetector = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (ImageViewerView.this.pager.isScrolled()) {
                    ImageViewerView.this.onClick(e, ImageViewerView.this.isOverlayWasClicked);
                }
                return false;
            }
        });
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        this.onUpDownEvent(event);
        if (this.direction == null && (this.scaleDetector.isInProgress() || event.getPointerCount() > 1)) {
            this.wasScaled = true;
            return this.pager.dispatchTouchEvent(event);
        }
        if (!this.adapter.isScaled(this.pager.getCurrentItem())) {
            this.directionDetector.onTouchEvent(event);
            if (this.direction != null) {
                switch (this.direction) {
                    case UP: 
                    case DOWN: {
                        if (!this.isSwipeToDismissAllowed || this.wasScaled || !this.pager.isScrolled()) break;
                        return this.swipeDismissListener.onTouch((View)this.dismissContainer, event);
                    }
                    case LEFT: 
                    case RIGHT: {
                        return this.pager.dispatchTouchEvent(event);
                    }
                }
            }
            return true;
        }
        return super.dispatchTouchEvent(event);
    }

    @Override
    public void onDismiss() {
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss();
        }
    }

    @Override
    public void onViewMove(float translationY, int translationLimit) {
        float alpha = 1.0f - 1.0f / (float)translationLimit / 4.0f * Math.abs(translationY);
        this.backgroundView.setAlpha(alpha);
        if (this.overlayView != null) {
            this.overlayView.setAlpha(alpha);
        }
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
    }

    public void resetScale() {
        this.adapter.resetScale(this.pager.getCurrentItem());
    }

    public boolean isScaled() {
        return this.adapter.isScaled(this.pager.getCurrentItem());
    }

    public String getUrl() {
        return this.adapter.getUrl(this.pager.getCurrentItem());
    }

    public void setPageChangeListener(ViewPager.OnPageChangeListener pageChangeListener) {
        this.pager.removeOnPageChangeListener(this.pageChangeListener);
        this.pageChangeListener = pageChangeListener;
        this.pager.addOnPageChangeListener(pageChangeListener);
        pageChangeListener.onPageSelected(this.pager.getCurrentItem());
    }

    private void setStartPosition(int position) {
        this.pager.setCurrentItem(position);
    }

    private void onUpDownEvent(MotionEvent event) {
        if (event.getAction() == 1) {
            this.onActionUp(event);
        }
        if (event.getAction() == 0) {
            this.onActionDown(event);
        }
        this.scaleDetector.onTouchEvent(event);
        this.gestureDetector.onTouchEvent(event);
    }

    private void onActionDown(MotionEvent event) {
        this.direction = null;
        this.wasScaled = false;
        this.pager.dispatchTouchEvent(event);
        this.swipeDismissListener.onTouch((View)this.dismissContainer, event);
        this.isOverlayWasClicked = this.dispatchOverlayTouch(event);
    }

    private void onActionUp(MotionEvent event) {
        this.swipeDismissListener.onTouch((View)this.dismissContainer, event);
        this.pager.dispatchTouchEvent(event);
        this.isOverlayWasClicked = this.dispatchOverlayTouch(event);
    }

    private void onClick(MotionEvent event, boolean isOverlayWasClicked) {
        if (this.overlayView != null && !isOverlayWasClicked) {
            AnimationUtils.animateVisibility(this.overlayView);
            super.dispatchTouchEvent(event);
        }
    }

    private boolean dispatchOverlayTouch(MotionEvent event) {
        return this.overlayView != null && this.overlayView.getVisibility() == 0 && this.overlayView.dispatchTouchEvent(event);
    }
}

