/*
 * Decompiled with CFR 0.152.
 */
package com.stfalcon.frescoimageviewer;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.stfalcon.frescoimageviewer.ImageViewer;
import com.stfalcon.frescoimageviewer.adapter.RecyclingPagerAdapter;
import com.stfalcon.frescoimageviewer.adapter.ViewHolder;
import com.stfalcon.frescoimageviewer.drawee.ZoomableDraweeView;
import java.util.HashSet;
import me.relex.photodraweeview.OnScaleChangeListener;

class ImageViewerAdapter
extends RecyclingPagerAdapter<ImageViewHolder> {
    private Context context;
    private ImageViewer.DataSet<?> dataSet;
    private HashSet<ImageViewHolder> holders;
    private ImageRequestBuilder imageRequestBuilder;
    private GenericDraweeHierarchyBuilder hierarchyBuilder;
    private PipelineDraweeControllerBuilder controllerBuilder;
    private boolean isZoomingAllowed;

    ImageViewerAdapter(Context context, ImageViewer.DataSet<?> dataSet, ImageRequestBuilder imageRequestBuilder, GenericDraweeHierarchyBuilder hierarchyBuilder, PipelineDraweeControllerBuilder controllerBuilder, boolean isZoomingAllowed) {
        this.context = context;
        this.dataSet = dataSet;
        this.holders = new HashSet();
        this.imageRequestBuilder = imageRequestBuilder;
        this.controllerBuilder = controllerBuilder;
        this.hierarchyBuilder = hierarchyBuilder;
        this.isZoomingAllowed = isZoomingAllowed;
    }

    @Override
    public ImageViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ZoomableDraweeView drawee = new ZoomableDraweeView(this.context);
        drawee.setEnabled(this.isZoomingAllowed);
        ImageViewHolder holder = new ImageViewHolder((View)drawee);
        this.holders.add(holder);
        return holder;
    }

    @Override
    public void onBindViewHolder(ImageViewHolder holder, int position) {
        holder.bind(position);
    }

    @Override
    public int getItemCount() {
        return this.dataSet.getData().size();
    }

    boolean isScaled(int index) {
        for (ImageViewHolder holder : this.holders) {
            if (holder.position != index) continue;
            return holder.isScaled;
        }
        return false;
    }

    void resetScale(int index) {
        for (ImageViewHolder holder : this.holders) {
            if (holder.position != index) continue;
            holder.resetScale();
            break;
        }
    }

    String getUrl(int index) {
        return this.dataSet.format(index);
    }

    private BaseControllerListener<ImageInfo> getDraweeControllerListener(final ZoomableDraweeView drawee) {
        return new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, ImageInfo imageInfo, Animatable animatable) {
                super.onFinalImageSet(id2, (Object)imageInfo, animatable);
                if (imageInfo == null) {
                    return;
                }
                drawee.update(imageInfo.getWidth(), imageInfo.getHeight());
            }
        };
    }

    class ImageViewHolder
    extends ViewHolder
    implements OnScaleChangeListener {
        private int position;
        private ZoomableDraweeView drawee;
        private boolean isScaled;

        ImageViewHolder(View itemView) {
            super(itemView);
            this.position = -1;
            this.drawee = (ZoomableDraweeView)itemView;
        }

        void bind(int position) {
            this.position = position;
            this.tryToSetHierarchy();
            this.setController(ImageViewerAdapter.this.dataSet.format(position));
            this.drawee.setOnScaleChangeListener(this);
        }

        public void onScaleChange(float scaleFactor, float focusX, float focusY) {
            this.isScaled = this.drawee.getScale() > 1.0f;
        }

        void resetScale() {
            this.drawee.setScale(1.0f, true);
        }

        private void tryToSetHierarchy() {
            if (ImageViewerAdapter.this.hierarchyBuilder != null) {
                ImageViewerAdapter.this.hierarchyBuilder.setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER);
                this.drawee.setHierarchy((DraweeHierarchy)ImageViewerAdapter.this.hierarchyBuilder.build());
            }
        }

        private void setController(String url) {
            PipelineDraweeControllerBuilder builder = ImageViewerAdapter.this.controllerBuilder;
            if (builder == null) {
                builder = Fresco.newDraweeControllerBuilder();
            }
            builder.setUri(url);
            builder.setOldController(this.drawee.getController());
            builder.setControllerListener((ControllerListener)ImageViewerAdapter.this.getDraweeControllerListener(this.drawee));
            if (ImageViewerAdapter.this.imageRequestBuilder != null) {
                ImageViewerAdapter.this.imageRequestBuilder.setSource(Uri.parse((String)url));
                builder.setImageRequest((Object)ImageViewerAdapter.this.imageRequestBuilder.build());
            }
            this.drawee.setController((DraweeController)builder.build());
        }
    }
}

