/*
 * Decompiled with CFR 0.152.
 */
package com.github.lucapino.versions.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Mojo(name="list")
public class VersionsListMojo
extends AbstractMojo {
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> projectRepos;
    @Parameter(required=true)
    private String startingVersion;
    @Parameter(defaultValue="false", required=true)
    private boolean includeSnapshots;
    @Parameter(defaultValue="${project.groupId}", required=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId})", required=true)
    private String artifactId;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String versionListPropertyName;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            DefaultArtifact artifact = new DefaultArtifact(this.groupId, this.artifactId, this.project.getPackaging(), "[" + this.startingVersion + ",)");
            VersionRangeRequest rangeRequest = new VersionRangeRequest();
            rangeRequest.setArtifact((Artifact)artifact);
            rangeRequest.setRepositories(this.projectRepos);
            VersionRangeResult rangeResult = this.repoSystem.resolveVersionRange(this.repoSession, rangeRequest);
            this.getLog().info((CharSequence)("Retrieving version of " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getExtension()));
            List availableVersions = rangeResult.getVersions();
            this.getLog().info((CharSequence)("Available versions " + availableVersions));
            if (!this.includeSnapshots) {
                this.filterSnapshots(availableVersions);
            }
            Collections.reverse(availableVersions);
            ArrayList<String> versionList = new ArrayList<String>();
            for (Version version : availableVersions) {
                versionList.add(version.toString());
            }
            this.project.getProperties().put(this.versionListPropertyName, versionList);
        }
        catch (VersionRangeResolutionException ex) {
            throw new MojoExecutionException("Error in plugin", ex.getCause());
        }
    }

    private void filterSnapshots(List<Version> versions) {
        Iterator<Version> versionIterator = versions.iterator();
        while (versionIterator.hasNext()) {
            Version version = versionIterator.next();
            if (!version.toString().endsWith("SNAPSHOT")) continue;
            versionIterator.remove();
        }
    }
}

