/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ZstdInputStream
extends FilterInputStream {
    private long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private byte[] src = new byte[srcBuffSize];
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = false;

    private static native long recommendedDInSize();

    private static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        if (this.src == null) {
            throw new IOException("Error allocating the input buffer of size " + srcBuffSize);
        }
        this.stream = ZstdInputStream.createDStream();
        int n = this.initDStream(this.stream);
        if (Zstd.isError(n)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(n));
        }
    }

    public ZstdInputStream setContinuous(boolean bl) {
        this.isContinuous = bl;
        return this;
    }

    public boolean getContinuous() {
        return this.isContinuous;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " from offset " + n + " in buffer of size " + byArray.length);
        }
        int n3 = n + n2;
        this.dstPos = n;
        while (this.dstPos < (long)n3) {
            int n4;
            if (this.srcSize - this.srcPos == 0L) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        return (int)(this.dstPos - (long)n);
                    }
                    throw new IOException("Read error or truncated source");
                }
                this.frameFinished = false;
            }
            if (Zstd.isError(n4 = this.decompressStream(this.stream, byArray, n3, this.src, (int)this.srcSize))) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n4));
            }
            if (n4 != 0) continue;
            this.frameFinished = true;
            n4 = this.initDStream(this.stream);
            if (Zstd.isError(n4)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n4));
            }
            return (int)(this.dstPos - (long)n);
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n > 0) {
            return byArray[0] & 0xFF;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.srcSize - this.srcPos > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        int n = (int)ZstdInputStream.recommendedDOutSize();
        byte[] byArray = new byte[n];
        while (l > (long)n) {
            long l3 = this.read(byArray, 0, n);
            l -= l3;
            l2 += l3;
        }
        return l2 += (long)this.read(byArray, 0, (int)l);
    }

    @Override
    public void close() throws IOException {
        ZstdInputStream.freeDStream(this.stream);
        this.in.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStream.recommendedDInSize();
    }
}

