/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdLegacyInputStream;
import com.github.luben.zstd.util.Native;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ZstdInputStreamV07
extends ZstdLegacyInputStream {
    protected long ctx = ZstdInputStreamV07.createDCtx();
    protected int blockSize = -1;
    protected int oBuffSize = -1;
    protected ByteBuffer oBuff = null;
    protected int oPos = 0;
    protected int oEnd = 0;
    protected byte[] iBuff = null;

    protected static native long createDCtx();

    protected static native int decompressBegin(long var0);

    protected static native int freeDCtx(long var0);

    protected static native int findBlockSize(byte[] var0, long var1);

    protected static native int findOBuffSize(byte[] var0, long var1);

    protected static native int nextSrcSizeToDecompress(long var0);

    protected static native int decompressContinue(long var0, ByteBuffer var2, long var3, long var5, byte[] var7, long var8, long var10);

    public ZstdInputStreamV07(InputStream inputStream, byte[] byArray, int n) throws IOException {
        super(inputStream);
        int n2;
        ZstdInputStreamV07.decompressBegin(this.ctx);
        while (this.blockSize < 0) {
            this.blockSize = ZstdInputStreamV07.findBlockSize(byArray, n);
            if (this.blockSize >= 0) continue;
            n += this.in.read(byArray, n, -this.blockSize - n);
        }
        this.iBuff = new byte[this.blockSize];
        if (this.iBuff == null) {
            throw new IOException("Error allocating the input buffer of size " + this.blockSize);
        }
        while (this.oBuffSize < 0) {
            this.oBuffSize = ZstdInputStreamV07.findOBuffSize(byArray, n);
            if (this.oBuffSize >= 0) continue;
            n += this.in.read(byArray, n, -this.oBuffSize - n);
        }
        this.oBuff = ByteBuffer.allocateDirect(this.oBuffSize);
        if (this.oBuff == null) {
            throw new IOException("Error allocating the output buffers of size " + this.oBuffSize);
        }
        for (long i = 0L; i < (long)n; i += (long)n2) {
            n2 = ZstdInputStreamV07.nextSrcSizeToDecompress(this.ctx);
            int n3 = ZstdInputStreamV07.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, byArray, i, n2);
            if (Zstd.isError(n3)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(n3));
            }
            this.oEnd += n3;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " exceeds the buffer size " + byArray.length + " from offset " + n);
        }
        while (this.oEnd == this.oPos) {
            int n4;
            n3 = 0;
            int n5 = ZstdInputStreamV07.nextSrcSizeToDecompress(this.ctx);
            if (n5 == 0) {
                return -1;
            }
            if (this.oBuffSize - this.oPos < this.blockSize) {
                this.oPos = 0;
                this.oEnd = 0;
            }
            while (n3 < n5) {
                n4 = this.in.read(this.iBuff, n3, n5 - n3);
                if (n4 > 0) {
                    n3 += n4;
                    continue;
                }
                throw new IOException("Read error or truncated source");
            }
            n4 = ZstdInputStreamV07.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, this.iBuff, 0L, n3);
            if (Zstd.isError(n4)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(n4));
            }
            this.oEnd += n4;
        }
        n3 = Math.min(n2, this.oEnd - this.oPos);
        this.oBuff.position(this.oPos);
        this.oBuff.get(byArray, n, n3);
        this.oPos += n3;
        return n3;
    }

    @Override
    public int read_truncated(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("Requested lenght " + n2 + " exceeds the buffer size " + byArray.length + " from offset " + n);
        }
        while (this.oEnd == this.oPos) {
            if (this.toRead - this.iPos == 0) {
                this.iPos = 0;
                this.toRead = ZstdInputStreamV07.nextSrcSizeToDecompress(this.ctx);
            }
            if (this.toRead == 0) {
                return -1;
            }
            if (this.oBuffSize - this.oPos < this.blockSize) {
                this.oPos = 0;
                this.oEnd = 0;
            }
            while (this.iPos < this.toRead) {
                n3 = this.in.read(this.iBuff, this.iPos, this.toRead - this.iPos);
                if (n3 > 0) {
                    this.iPos += n3;
                    continue;
                }
                return 0;
            }
            n3 = ZstdInputStreamV07.decompressContinue(this.ctx, this.oBuff, this.oPos, this.oBuffSize - this.oPos, this.iBuff, 0L, this.iPos);
            if (Zstd.isError(n3)) {
                throw new IOException("Decode Error: " + Zstd.getErrorName(n3));
            }
            this.oEnd += n3;
        }
        n3 = Math.min(n2, this.oEnd - this.oPos);
        this.oBuff.position(this.oPos);
        this.oBuff.get(byArray, n, n3);
        this.oPos += n3;
        return n3;
    }

    @Override
    public int available() throws IOException {
        return this.oEnd - this.oPos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long l) throws IOException {
        if (l <= (long)(this.oEnd - this.oPos)) {
            this.oPos = (int)((long)this.oPos + l);
            return l;
        }
        long l2 = this.oEnd - this.oPos;
        this.oPos = this.oEnd;
        return l2;
    }

    @Override
    public void close() throws IOException {
        ZstdInputStreamV07.freeDCtx(this.ctx);
        this.in.close();
    }

    static {
        Native.load();
    }
}

