/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model.element;

import fr.w3blog.zpl.constant.ZebraRotation;
import fr.w3blog.zpl.model.ZebraElement;
import fr.w3blog.zpl.utils.ZplUtils;

public abstract class ZebraBarCode
extends ZebraElement {
    Integer barCodeHeigth;
    Integer moduleWidth;
    Integer wideBarRatio;
    ZebraRotation zebraRotation = ZebraRotation.NORMAL;
    boolean showTextInterpretation = true;
    boolean showTextInterpretationAbove = false;
    String text;

    public ZebraBarCode(int positionX, int positionY, String text) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.text = text;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.text = text;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth, int moduleWidth, int wideBarRatio) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.text = text;
        this.moduleWidth = moduleWidth;
        this.wideBarRatio = wideBarRatio;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth, boolean showTextInterpretation, int moduleWidth, int wideBarRatio) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.showTextInterpretation = showTextInterpretation;
        this.text = text;
        this.moduleWidth = moduleWidth;
        this.wideBarRatio = wideBarRatio;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth, boolean showTextInterpretation, boolean showTextInterpretationAbove) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.text = text;
        this.showTextInterpretation = showTextInterpretation;
        this.showTextInterpretationAbove = showTextInterpretationAbove;
    }

    public StringBuilder getStartZplCodeBuilder() {
        StringBuilder zpl = new StringBuilder();
        zpl.append(this.getZplCodePosition());
        zpl.append("\n");
        if (this.moduleWidth != null) {
            zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("BY", this.moduleWidth, this.wideBarRatio, this.barCodeHeigth));
        }
        return zpl;
    }

    public Integer getBarCodeWidth() {
        return this.moduleWidth;
    }

    public Integer getBarCodeHeigth() {
        return this.barCodeHeigth;
    }

    public Integer getWideBarRatio() {
        return this.wideBarRatio;
    }

    public ZebraRotation getZebraRotation() {
        return this.zebraRotation;
    }

    public boolean isShowTextInterpretation() {
        return this.showTextInterpretation;
    }

    public boolean isShowTextInterpretationAbove() {
        return this.showTextInterpretationAbove;
    }

    public String getText() {
        return this.text;
    }

    public ZebraBarCode setBarCodeWidth(Integer barCodeWidth) {
        this.moduleWidth = barCodeWidth;
        return this;
    }

    public ZebraBarCode setBarCodeHeigth(Integer barCodeHeigth) {
        this.barCodeHeigth = barCodeHeigth;
        return this;
    }

    public ZebraBarCode setWideBarRatio(Integer wideBarRatio) {
        this.wideBarRatio = wideBarRatio;
        return this;
    }

    public ZebraBarCode setZebraRotation(ZebraRotation zebraRotation) {
        this.zebraRotation = zebraRotation;
        return this;
    }

    public ZebraBarCode setShowTextInterpretation(boolean showTextInterpretation) {
        this.showTextInterpretation = showTextInterpretation;
        return this;
    }

    public ZebraBarCode setShowTextInterpretationAbove(boolean showTextInterpretationAbove) {
        this.showTextInterpretationAbove = showTextInterpretationAbove;
        return this;
    }

    public ZebraBarCode setText(String text) {
        this.text = text;
        return this;
    }
}

