/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;
import com.zebra.printconnectintentswrapper.PCTemplateFileNamePrintSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class PCTemplateFileNamePrint
extends PCIntentsBase {
    private onPrintFileNameResult mPrintTemplateFileNameCallback = null;

    public PCTemplateFileNamePrint(Context aContext) {
        super(aContext);
    }

    public void execute(PCTemplateFileNamePrintSettings settings, onPrintFileNameResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mPrintTemplateFileNameCallback = callback;
        if (settings.mTemplateFileName.isEmpty() && this.mPrintTemplateFileNameCallback != null) {
            this.mPrintTemplateFileNameCallback.error("Error: no filename specified.", -1, null, settings);
        }
        super.execute(settings);
        switch (settings.mFileMode) {
            case PRINTCONNECTCONFIGFOLDER: {
                Log.d((String)TAG, (String)("Printing from printer memory:" + settings.mTemplateFileName));
                this.PrintTemplateFileNameFromPrintConnectAssetsFolder(settings);
                break;
            }
            case FILE_SYSTEM: {
                Log.d((String)TAG, (String)("Printing from file system: " + settings.mTemplateFileName));
                this.PrintTemplateFileNameFromFileSystem(settings);
            }
        }
    }

    private String getFileStringFromFileSystem(PCTemplateFileNamePrintSettings settings) throws IOException {
        String zplString = "";
        StringBuilder strb = new StringBuilder();
        BufferedReader bfr = new BufferedReader(new FileReader(settings.mTemplateFileName));
        String line = "";
        while ((line = bfr.readLine()) != null) {
            strb.append(line);
        }
        bfr.close();
        zplString = strb.toString();
        Log.d((String)TAG, (String)("String read from file: \n" + zplString.toString()));
        return zplString;
    }

    private void PrintTemplateFileNameFromPrintConnectAssetsFolder(final PCTemplateFileNamePrintSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.TemplatePrintService"));
        intent.putExtra("com.zebra.printconnect.PrintService.TEMPLATE_FILE_NAME", settings.mTemplateFileName);
        if (settings.mVariableData != null && settings.mVariableData.size() > 0) {
            intent.putExtra("com.zebra.printconnect.PrintService.VARIABLE_DATA", settings.mVariableData);
        }
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCTemplateFileNamePrint.this.cleanAll();
                if (resultCode == 0) {
                    if (PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback != null) {
                        PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback != null) {
                        PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    private void PrintTemplateFileNameFromFileSystem(final PCTemplateFileNamePrintSettings settings) {
        File myFile = new File(settings.mTemplateFileName);
        if (!myFile.exists()) {
            if (this.mPrintTemplateFileNameCallback != null) {
                this.mPrintTemplateFileNameCallback.error("File not found", -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        String sZPLTemplateString = "";
        try {
            sZPLTemplateString = this.getFileStringFromFileSystem(settings);
        }
        catch (IOException e) {
            if (this.mPrintTemplateFileNameCallback != null) {
                this.mPrintTemplateFileNameCallback.error(e.getMessage(), -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        if (sZPLTemplateString == null || sZPLTemplateString.isEmpty()) {
            if (this.mPrintTemplateFileNameCallback != null) {
                this.mPrintTemplateFileNameCallback.error("Error: no zpl data.", -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        byte[] templateBytes = null;
        try {
            templateBytes = sZPLTemplateString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (this.mPrintTemplateFileNameCallback != null) {
                this.mPrintTemplateFileNameCallback.error(e.getMessage(), -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.TemplatePrintWithContentService"));
        intent.putExtra("com.zebra.printconnect.PrintService.TEMPLATE_DATA", templateBytes);
        if (settings.mVariableData != null && settings.mVariableData.size() > 0) {
            intent.putExtra("com.zebra.printconnect.PrintService.VARIABLE_DATA", settings.mVariableData);
        }
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCTemplateFileNamePrint.this.cleanAll();
                if (resultCode == 0) {
                    if (PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback != null) {
                        PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback != null) {
                        PCTemplateFileNamePrint.this.mPrintTemplateFileNameCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mPrintTemplateFileNameCallback != null) {
            this.mPrintTemplateFileNameCallback.timeOut((PCTemplateFileNamePrintSettings)settings);
        }
    }

    public static interface onPrintFileNameResult {
        public void success(PCTemplateFileNamePrintSettings var1);

        public void error(String var1, int var2, Bundle var3, PCTemplateFileNamePrintSettings var4);

        public void timeOut(PCTemplateFileNamePrintSettings var1);
    }
}

