/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;
import java.util.HashMap;

public class PCPrinterStatus
extends PCIntentsBase {
    private onPrinterStatusResult mPrinterStatusCallback = null;

    public PCPrinterStatus(Context aContext) {
        super(aContext);
    }

    public void execute(PCIntentsBaseSettings settings, onPrinterStatusResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mPrinterStatusCallback = callback;
        super.execute(settings);
        this.GetPrinterStatus(settings);
    }

    private void GetPrinterStatus(final PCIntentsBaseSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.GetPrinterStatusService"));
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCPrinterStatus.this.cleanAll();
                if (resultCode == 0) {
                    if (PCPrinterStatus.this.mPrinterStatusCallback != null) {
                        HashMap printerStatusMap = (HashMap)resultData.getSerializable("PrinterStatusMap");
                        PCPrinterStatus.this.mPrinterStatusCallback.success(settings, printerStatusMap);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCPrinterStatus.this.mPrinterStatusCallback != null) {
                        PCPrinterStatus.this.mPrinterStatusCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mPrinterStatusCallback != null) {
            this.mPrinterStatusCallback.timeOut(settings);
        }
    }

    public static interface onPrinterStatusResult {
        public void success(PCIntentsBaseSettings var1, HashMap<String, String> var2);

        public void error(String var1, int var2, Bundle var3, PCIntentsBaseSettings var4);

        public void timeOut(PCIntentsBaseSettings var1);
    }
}

