/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;
import com.zebra.printconnectintentswrapper.PCLinePrintPassthroughPrintSettings;
import java.io.UnsupportedEncodingException;

public class PCLinePrintPassthroughPrint
extends PCIntentsBase {
    private onLinePrintPassthroughResult mLinePrintPassthroughCallback = null;

    public PCLinePrintPassthroughPrint(Context aContext) {
        super(aContext);
    }

    public void execute(PCLinePrintPassthroughPrintSettings settings, onLinePrintPassthroughResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mLinePrintPassthroughCallback = callback;
        super.execute(settings);
        this.LinePrintPassthroughPrint(settings);
    }

    private void LinePrintPassthroughPrint(final PCLinePrintPassthroughPrintSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.LinePrintPassthroughService"));
        byte[] linePrintPassthroughBytes = null;
        try {
            linePrintPassthroughBytes = settings.mLineToPrint.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (this.mLinePrintPassthroughCallback != null) {
                this.mLinePrintPassthroughCallback.error(e.getMessage(), -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        intent.putExtra("com.zebra.printconnect.PrintService.LINE_PRINT_DATA", linePrintPassthroughBytes);
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCLinePrintPassthroughPrint.this.cleanAll();
                if (resultCode == 0) {
                    if (PCLinePrintPassthroughPrint.this.mLinePrintPassthroughCallback != null) {
                        PCLinePrintPassthroughPrint.this.mLinePrintPassthroughCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCLinePrintPassthroughPrint.this.mLinePrintPassthroughCallback != null) {
                        PCLinePrintPassthroughPrint.this.mLinePrintPassthroughCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mLinePrintPassthroughCallback != null) {
            this.mLinePrintPassthroughCallback.timeOut((PCLinePrintPassthroughPrintSettings)settings);
        }
    }

    public static interface onLinePrintPassthroughResult {
        public void success(PCLinePrintPassthroughPrintSettings var1);

        public void error(String var1, int var2, Bundle var3, PCLinePrintPassthroughPrintSettings var4);

        public void timeOut(PCLinePrintPassthroughPrintSettings var1);
    }
}

