/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.Context;
import android.os.Handler;
import android.os.Parcel;
import android.os.ResultReceiver;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;

public abstract class PCIntentsBase {
    protected static String TAG = "PCINTENTSAPI";
    protected Context mContext = null;
    protected PCIntentsBaseSettings mSettings = null;
    protected Handler mTimeOutHandler;
    protected Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            PCIntentsBase.this.onTimeOut(PCIntentsBase.this.mSettings);
        }
    };

    public PCIntentsBase(Context aContext) {
        this.mContext = aContext;
        this.mTimeOutHandler = new Handler(this.mContext.getMainLooper());
    }

    protected void execute(PCIntentsBaseSettings settings) {
        this.mSettings = settings;
        if (settings.mEnableTimeOutMechanism) {
            this.mTimeOutHandler.postDelayed(this.mTimeOutRunnable, this.mSettings.mTimeOutMS);
        }
    }

    protected ResultReceiver buildIPCSafeReceiver(ResultReceiver actualReceiver) {
        Parcel parcel = Parcel.obtain();
        actualReceiver.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        ResultReceiver receiverForSending = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return receiverForSending;
    }

    protected abstract void onTimeOut(PCIntentsBaseSettings var1);

    protected void cleanAll() {
        if (this.mTimeOutHandler != null) {
            this.mTimeOutHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }
}

