/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.zebra.datawedgeprofileintents.DWProfileBase;
import com.zebra.datawedgeprofileintents.DWProfileCheckerSettings;
import java.util.Arrays;

public class DWProfileChecker
extends DWProfileBase {
    private Handler broadcastReceiverHandler = null;
    private HandlerThread broadcastReceiverThread = null;
    private Looper broadcastReceiverThreadLooper = null;
    private onProfileExistResult mProfileExistsCallback = null;
    private checkProfileReceiver mBroadcastReceiver = new checkProfileReceiver();

    public DWProfileChecker(Context aContext) {
        super(aContext);
    }

    public void execute(DWProfileCheckerSettings settings, onProfileExistResult callback) {
        super.execute(settings);
        this.mProfileExistsCallback = callback;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.symbol.datawedge.api.RESULT_ACTION");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        this.broadcastReceiverThread = new HandlerThread(settings.mProfileName.isEmpty() ? this.mContext.getPackageName() : settings.mProfileName + ".ENUMERATESCANNERS.THREAD");
        this.broadcastReceiverThread.start();
        this.broadcastReceiverThreadLooper = this.broadcastReceiverThread.getLooper();
        this.broadcastReceiverHandler = new Handler(this.broadcastReceiverThreadLooper);
        this.mContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, intentFilter, null, this.broadcastReceiverHandler);
        this.sendDataWedgeIntentWithExtra("com.symbol.datawedge.api.ACTION", "com.symbol.datawedge.api.GET_PROFILES_LIST", "");
    }

    @Override
    protected void cleanAll() {
        this.mSettings.mProfileName = "";
        this.mProfileExistsCallback = null;
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        if (this.broadcastReceiverThread != null) {
            this.broadcastReceiverThreadLooper.quit();
            this.broadcastReceiverThreadLooper = null;
            this.broadcastReceiverThread = null;
            this.broadcastReceiverHandler = null;
        }
        super.cleanAll();
    }

    @Override
    protected void onTimeOut() {
        if (this.mProfileExistsCallback != null) {
            this.mProfileExistsCallback.timeOut(this.mSettings.mProfileName);
            this.cleanAll();
        }
    }

    private class checkProfileReceiver
    extends BroadcastReceiver {
        private checkProfileReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("com.symbol.datawedge.api.RESULT_GET_PROFILES_LIST")) {
                String[] profilesList = intent.getStringArrayExtra("com.symbol.datawedge.api.RESULT_GET_PROFILES_LIST");
                boolean exists = Arrays.asList(profilesList).contains(DWProfileChecker.this.mSettings.mProfileName);
                if (DWProfileChecker.this.mProfileExistsCallback != null) {
                    DWProfileChecker.this.mProfileExistsCallback.result(DWProfileChecker.this.mSettings.mProfileName, exists);
                    DWProfileChecker.this.cleanAll();
                }
            }
        }
    }

    public static interface onProfileExistResult {
        public void result(String var1, boolean var2);

        public void timeOut(String var1);
    }
}

