/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.zebra.datawedgeprofileenums.SC_E_SCANNER_IDENTIFIER;
import com.zebra.datawedgeprofileintents.DWEnumerateScannersSettings;
import com.zebra.datawedgeprofileintents.DWProfileBase;
import java.util.ArrayList;
import java.util.List;

public class DWEnumerateScanners
extends DWProfileBase {
    private Handler broadcastReceiverHandler = null;
    private HandlerThread broadcastReceiverThread = null;
    private Looper broadcastReceiverThreadLooper = null;
    private onEnumerateScannerResult mEnumerateScannerCallback = null;
    private enumerateScannerReceiver mBroadcastReceiver = new enumerateScannerReceiver();

    public DWEnumerateScanners(Context aContext) {
        super(aContext);
    }

    public void execute(DWEnumerateScannersSettings settings, onEnumerateScannerResult callback) {
        super.execute(settings);
        this.mEnumerateScannerCallback = callback;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.symbol.datawedge.api.RESULT_ACTION");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        this.broadcastReceiverThread = new HandlerThread(settings.mProfileName.isEmpty() ? this.mContext.getPackageName() : settings.mProfileName + ".ENUMERATESCANNERS.THREAD");
        this.broadcastReceiverThread.start();
        this.broadcastReceiverThreadLooper = this.broadcastReceiverThread.getLooper();
        this.broadcastReceiverHandler = new Handler(this.broadcastReceiverThreadLooper);
        this.mContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, intentFilter, null, this.broadcastReceiverHandler);
        this.sendDataWedgeIntentWithExtra("com.symbol.datawedge.api.ACTION", "com.symbol.datawedge.api.ENUMERATE_SCANNERS", "");
    }

    @Override
    protected void cleanAll() {
        this.mSettings.mProfileName = "";
        this.mEnumerateScannerCallback = null;
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        if (this.broadcastReceiverThread != null) {
            this.broadcastReceiverThreadLooper.quit();
            this.broadcastReceiverThreadLooper = null;
            this.broadcastReceiverThread = null;
            this.broadcastReceiverHandler = null;
        }
        super.cleanAll();
    }

    @Override
    protected void onTimeOut() {
        if (this.mEnumerateScannerCallback != null) {
            this.mEnumerateScannerCallback.timeOut(this.mSettings.mProfileName);
            this.cleanAll();
        }
    }

    private class enumerateScannerReceiver
    extends BroadcastReceiver {
        private enumerateScannerReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("com.symbol.datawedge.api.RESULT_ENUMERATE_SCANNERS")) {
                ArrayList<Scanner> returnList = new ArrayList<Scanner>();
                ArrayList scannerList = (ArrayList)intent.getSerializableExtra("com.symbol.datawedge.api.RESULT_ENUMERATE_SCANNERS");
                if (scannerList != null && scannerList.size() > 0) {
                    for (Bundle bunb : scannerList) {
                        Scanner scanner = new Scanner();
                        scanner.mName = bunb.getString("SCANNER_NAME");
                        scanner.mScannerConnectionState = bunb.getBoolean("SCANNER_CONNECTION_STATE");
                        scanner.mIndex = bunb.getInt("SCANNER_INDEX");
                        scanner.mScannerIdentifier = SC_E_SCANNER_IDENTIFIER.fromString(bunb.getString("SCANNER_IDENTIFIER"));
                        returnList.add(scanner);
                    }
                }
                if (DWEnumerateScanners.this.mEnumerateScannerCallback != null) {
                    DWEnumerateScanners.this.mEnumerateScannerCallback.result(DWEnumerateScanners.this.mSettings.mProfileName, returnList);
                    DWEnumerateScanners.this.cleanAll();
                }
            }
        }
    }

    public static interface onEnumerateScannerResult {
        public void result(String var1, List<Scanner> var2);

        public void timeOut(String var1);
    }

    public static class Scanner {
        public String mName = "";
        public int mIndex = -1;
        public boolean mScannerConnectionState = false;
        public SC_E_SCANNER_IDENTIFIER mScannerIdentifier = SC_E_SCANNER_IDENTIFIER.AUTO;
    }
}

