/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.criticalpermissionshelper;

import android.content.Context;
import android.os.Handler;
import com.zebra.criticalpermissionshelper.CommandBaseSettings;

abstract class CommandBase {
    protected static String TAG = "DIWrapperMX";
    protected Context mContext = null;
    protected CommandBaseSettings mSettings = null;
    protected Handler mTimeOutHandler;
    protected Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            CommandBase.this.onTimeOut(CommandBase.this.mSettings);
        }
    };

    protected CommandBase(Context aContext) {
        this.mContext = aContext;
        this.mTimeOutHandler = new Handler(this.mContext.getMainLooper());
    }

    protected void execute(CommandBaseSettings settings) {
        this.mSettings = settings;
        if (settings.mEnableTimeOutMechanism) {
            this.mTimeOutHandler.postDelayed(this.mTimeOutRunnable, this.mSettings.mTimeOutMS);
        }
    }

    protected void onTimeOut(CommandBaseSettings settings) {
        this.cleanAll();
    }

    protected void cleanAll() {
        if (this.mTimeOutHandler != null) {
            this.mTimeOutHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }
}

